/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

class ImageDataImageDescriptor
extends ImageDescriptor {
    private ImageData data;
    private Image originalImage = null;
    private Device originalDevice = null;

    ImageDataImageDescriptor(Image image, Device device) {
        this(image.getImageData());
        this.originalImage = image;
        this.originalDevice = device;
    }

    ImageDataImageDescriptor(Image image) {
        this(image.getImageData());
        this.originalImage = image;
    }

    ImageDataImageDescriptor(ImageData imageData) {
        this.data = imageData;
    }

    public Object createResource(Device device) throws DeviceResourceException {
        if (this.originalImage != null) {
            if (this.originalDevice == null) {
                Image image = this.createImage(false, device);
                if (image == null) {
                    throw new DeviceResourceException(this);
                }
                if (image.equals((Object)this.originalImage)) {
                    image.dispose();
                    this.originalDevice = device;
                    return this.originalImage;
                }
                return image;
            }
            if (this.originalDevice == device) {
                return this.originalImage;
            }
        }
        return super.createResource(device);
    }

    public void destroyResource(Object object) {
        if (object == this.originalImage) {
            return;
        }
        super.destroyResource(object);
    }

    public ImageData getImageData() {
        return this.data;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageDataImageDescriptor)) {
            return false;
        }
        ImageDataImageDescriptor imageDataImageDescriptor = (ImageDataImageDescriptor)object;
        if (this.originalImage != null) {
            return imageDataImageDescriptor.originalImage == this.originalImage;
        }
        return imageDataImageDescriptor.originalImage == null && this.data.equals(imageDataImageDescriptor.data);
    }
}

