/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ercp.xml.dom.AttrImpl;
import org.eclipse.ercp.xml.dom.AttributeMap;
import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.dom.NodeImpl;
import org.eclipse.ercp.xml.dom.NodeListImpl;
import org.eclipse.ercp.xml.dom.TreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementImpl
extends TreeNode
implements Element {
    AttributeMap attributes = new AttributeMap(this);

    public ElementImpl(DocumentImpl ownerDocument, String qualifiedName) {
        super(ownerDocument, qualifiedName);
    }

    public ElementImpl(DocumentImpl ownerDocument, String namespaceURI, String qualifiedName) {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public String getAttribute(String name) {
        Attr attribute = this.getAttributeNode(name);
        return attribute == null ? "" : attribute.getValue();
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.attributes.setNamedItem(name, value);
    }

    public void removeAttribute(String name) throws DOMException {
        this.attributes.removeNamedItem(name);
    }

    public Attr getAttributeNode(String name) {
        return (Attr)this.attributes.getNamedItem(name);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return (Attr)this.attributes.setNamedItem(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return (Attr)this.attributes.removeItem(oldAttr);
    }

    protected void getElementByTagName(String name, NodeListImpl list) {
        if ("*".equals(name) || this.getTagName().equals(name)) {
            list.addNode(this);
        }
        super.getElementByTagName(name, list);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attribute = this.getAttributeNodeNS(namespaceURI, localName);
        return attribute == null ? "" : attribute.getValue();
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.attributes.setNamedItemNS(namespaceURI, qualifiedName, value);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.attributes.removeNamedItemNS(namespaceURI, localName);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr);
    }

    void getElementsByTagNameNS(String namespaceURI, String localName, NodeListImpl list) {
        if (("*".equals(namespaceURI) || this.getNamespaceURI().equals(namespaceURI)) && ("*".equals(localName) || this.getLocalName().equals(localName))) {
            list.addNode(this);
        }
        super.getElementsByTagNameNS(namespaceURI, localName, list);
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public short getNodeType() {
        return 1;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes.getLength() != 0;
    }

    public Node cloneNode(boolean deep) {
        ElementImpl clone = new ElementImpl(this.ownerDocument, this.namespaceURI, this.qualifiedName);
        Hashtable attTable = this.attributes.attributes;
        Enumeration keys = attTable.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            AttrImpl att = (AttrImpl)attTable.get(key);
            AttrImpl attClone = (AttrImpl)att.cloneNode(deep);
            attClone.ownerElement = clone;
            clone.setAttributeNode(attClone);
        }
        if (deep) {
            int len = this.getLength();
            int i = 0;
            while (i < len) {
                Node child = this.item(i);
                Node childClone = child.cloneNode(deep);
                clone.appendChild(childClone);
                ++i;
            }
        }
        return clone;
    }

    protected void spreadOwnerDocument(DocumentImpl ownerDocument) {
        if (this.ownerDocument.ownerDocument == ownerDocument) {
            return;
        }
        super.spreadOwnerDocument(ownerDocument);
        Hashtable attTable = this.attributes.attributes;
        Enumeration keys = attTable.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            AttrImpl att = (AttrImpl)attTable.get(key);
            att.spreadOwnerDocument(ownerDocument);
        }
        int len = this.getLength();
        int i = 0;
        while (i < len) {
            ((NodeImpl)this.item(i)).spreadOwnerDocument(ownerDocument);
            ++i;
        }
    }
}

