/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.dom;

import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.dom.ElementImpl;
import org.eclipse.ercp.xml.dom.NSNodeImpl;
import org.eclipse.ercp.xml.dom.NodeImpl;
import org.eclipse.ercp.xml.dom.NodeListImpl;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class TreeNode
extends NSNodeImpl {
    protected TreeNode nextSibling = null;
    protected TreeNode previousSibling = null;
    protected TreeNode parentNode = null;
    protected TreeNode firstChild = null;
    protected TreeNode lastChild = null;
    protected int length = 0;

    public TreeNode(DocumentImpl ownerDocument) {
        super(ownerDocument);
    }

    public TreeNode(DocumentImpl ownerDocument, String qualifiedName) {
        super(ownerDocument, qualifiedName);
    }

    public TreeNode(DocumentImpl ownerDocument, String namespaceURI, String qualifiedName) {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        block9: {
            try {
                if (newChild != null) break block9;
                return null;
            }
            catch (ClassCastException classCastException) {
                throw new DOMException(3, EXmlMsg.getDefault().getString(59));
            }
        }
        this.checkHierarchy(newChild);
        this.checkOwnerDocument(newChild);
        TreeNode newChildImpl = (TreeNode)newChild;
        if (refChild == null) {
            if (this.firstChild == null) {
                this.firstChild = this.lastChild = newChildImpl;
            } else {
                this.lastChild.nextSibling = newChildImpl;
                newChildImpl.previousSibling = this.lastChild;
                this.lastChild = newChildImpl;
            }
            newChildImpl.parentNode = this;
        } else {
            if (refChild.getParentNode() != this) {
                throw new DOMException(8, EXmlMsg.getDefault().getString(32));
            }
            TreeNode refChildImpl = (TreeNode)refChild;
            newChildImpl.previousSibling = refChildImpl.previousSibling;
            newChildImpl.nextSibling = refChildImpl;
            refChildImpl.previousSibling = newChildImpl;
            newChildImpl.parentNode = this;
            if (this.firstChild == refChildImpl) {
                this.firstChild = newChildImpl;
            }
        }
        ++this.length;
        return newChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        TreeNode oldChildImpl = (TreeNode)oldChild;
        if (oldChildImpl.previousSibling != null) {
            oldChildImpl.previousSibling.nextSibling = oldChildImpl.nextSibling;
        }
        if (oldChildImpl.nextSibling != null) {
            oldChildImpl.nextSibling.previousSibling = oldChildImpl.previousSibling;
        }
        if (oldChildImpl.parentNode.firstChild == oldChild) {
            oldChildImpl.parentNode.firstChild = oldChildImpl.nextSibling;
        }
        if (oldChildImpl.parentNode.lastChild == oldChild) {
            oldChildImpl.parentNode.lastChild = oldChildImpl.previousSibling;
        }
        --this.length;
        return oldChild;
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.insertBefore(newChild, oldChild);
        this.removeChild(oldChild);
        return oldChild;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    public int getLength() {
        return this.length;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node item(int index) {
        TreeNode node = this.firstChild;
        int i = 0;
        while (i < index && node != null) {
            node = node.nextSibling;
            ++i;
        }
        return node;
    }

    public NodeList getElementsByTagName(String name) {
        NodeListImpl list = new NodeListImpl();
        this.getElementByTagName(name, list);
        return list;
    }

    protected void getElementByTagName(String name, NodeListImpl list) {
        TreeNode node = this.firstChild;
        while (node != null) {
            if (node.getNodeType() == 1) {
                ((ElementImpl)node).getElementByTagName(name, list);
            }
            node = node.nextSibling;
        }
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        NodeListImpl list = new NodeListImpl();
        this.getElementsByTagNameNS(namespaceURI, localName, list);
        return list;
    }

    void getElementsByTagNameNS(String namespaceURI, String localName, NodeListImpl list) {
        TreeNode node = this.firstChild;
        while (node != null) {
            if (node.getNodeType() == 1) {
                ((ElementImpl)node).getElementsByTagNameNS(namespaceURI, localName, list);
            }
            node = node.nextSibling;
        }
    }

    public void normalize() {
        Node child = this.getFirstChild();
        Text lastText = null;
        while (child != null) {
            Node sibling = child.getNextSibling();
            switch (child.getNodeType()) {
                case 3: {
                    if (child.getNodeValue().length() == 0) {
                        this.removeChild(child);
                        break;
                    }
                    if (lastText == null) {
                        lastText = (Text)child;
                        break;
                    }
                    lastText.appendData(child.getNodeValue());
                    this.removeChild(child);
                    break;
                }
                case 1: {
                    child.normalize();
                    break;
                }
            }
            child = sibling;
        }
    }

    private void checkOwnerDocument(Node childNode) throws DOMException {
        Document childDoc = childNode.getOwnerDocument();
        Document myDoc = this.getOwnerDocument();
        if (myDoc == null && this instanceof DocumentImpl) {
            myDoc = (DocumentImpl)this;
        }
        if (childDoc == null) {
            ((NodeImpl)childNode).setOwnerDocument((DocumentImpl)myDoc);
            return;
        }
        if (childDoc != myDoc) {
            throw new DOMException(4, EXmlMsg.getDefault().getString(30));
        }
    }

    private void checkHierarchy(Node childNode) {
        if (!(childNode instanceof TreeNode)) {
            throw new DOMException(3, EXmlMsg.getDefault().getString(59));
        }
        Node parent = this;
        while (parent != null) {
            if (parent == childNode) {
                throw new DOMException(3, EXmlMsg.getDefault().getString(59));
            }
            parent = parent.getParentNode();
        }
    }
}

