/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.WrappedLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbsScreen
implements SelectionListener,
ControlListener {
    protected final int NONE = 0;
    protected final int BACK = 1;
    protected final int CANCEL = 2;
    protected final int NEXT = 3;
    protected final int FINISHED = 4;
    NormalView view;
    Composite screen;
    Composite screenPane;
    WrappedLabel titleLabel;
    Button backButton;
    Button cancelButton;
    Button nextButton;
    Composite buttonPane;

    public AbsScreen() {
    }

    public AbsScreen(NormalView view) {
        this.view = view;
    }

    public void show(boolean refreshIt) {
        if (this.screen == null) {
            this.createScreen();
        }
        if (refreshIt) {
            this.refresh();
            this.setVisible(true);
            this.action();
        } else {
            this.setVisible(true);
        }
    }

    public void setVisible(boolean bVis) {
        this.screen.setVisible(bVis);
        if (bVis) {
            this.setDefaultFocus();
        }
    }

    protected abstract void createScreen();

    protected abstract void refresh();

    protected abstract void action();

    protected abstract void setDefaultFocus();

    protected void init(String title) {
        this.init(title, false);
    }

    protected Composite init(String title, boolean scrollable) {
        if (scrollable) {
            this.screen = new Composite(this.view.parent, 512);
            this.screen.getVerticalBar().setVisible(false);
            this.screen.setBounds(this.view.parent.getClientArea());
            this.screen.setLayout((Layout)new GridLayout(1, false));
            this.screen.setLayoutData((Object)new GridData(1808));
            this.screen.addControlListener((ControlListener)this);
            this.screenPane = new Composite(this.screen, 0);
            this.screenPane.setLayout((Layout)new GridLayout(1, false));
            this.screenPane.setLayoutData((Object)new GridData(1808));
        } else {
            this.screen = new Composite(this.view.parent, 0);
            this.screen.setBounds(this.view.parent.getClientArea());
            this.screen.setLayout((Layout)new GridLayout(1, false));
            this.screen.setLayoutData((Object)new GridData(1808));
            this.screen.addControlListener((ControlListener)this);
            this.screenPane = this.screen;
        }
        if (title != null) {
            this.titleLabel = new WrappedLabel(this.screenPane, 0, 0);
            this.titleLabel.setFont(new Font((Device)Display.getCurrent(), "Arial", 10, 1));
            this.titleLabel.setText(title);
        }
        return this.screenPane;
    }

    protected void fillSpace() {
        new Composite(this.screenPane, 0).setLayoutData((Object)new GridData(1040));
    }

    protected void separator() {
        new Label(this.screenPane, 258).setLayoutData((Object)new GridData(768));
    }

    protected void setButtons(int back, int cancel, int next) {
        this.buttonPane = new Composite(this.screenPane, 0);
        GridData gd = new GridData(768);
        this.buttonPane.setLayoutData((Object)gd);
        RowLayout paneLayout = new RowLayout(256);
        paneLayout.justify = true;
        paneLayout.wrap = false;
        this.buttonPane.setLayout((Layout)paneLayout);
        if (back == 1) {
            this.backButton = new Button(this.buttonPane, 8);
            this.backButton.setText(UIMessages.Back);
            this.backButton.addSelectionListener((SelectionListener)this);
        }
        if (cancel == 2) {
            this.cancelButton = new Button(this.buttonPane, 8);
            this.cancelButton.setText(UIMessages.Cancel);
            this.cancelButton.addSelectionListener((SelectionListener)this);
        }
        if (next != 0) {
            this.nextButton = new Button(this.buttonPane, 8);
            if (next == 3) {
                this.nextButton.setText(UIMessages.Next);
            } else {
                this.nextButton.setText(UIMessages.Finished);
            }
            this.nextButton.addSelectionListener((SelectionListener)this);
        }
        this.buttonPane.layout();
        if (this.nextButton != null && this.nextButton.getLocation().x > this.screenPane.getSize().x) {
            paneLayout.wrap = true;
            this.buttonPane.setLayoutData((Object)new GridData(768));
            this.screen.layout();
        }
    }

    public abstract void widgetSelected(SelectionEvent var1);

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.widgetSelected(arg0);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (!this.screen.isDisposed()) {
            this.screen.setBounds(this.view.parent.getClientArea());
        }
    }
}

