/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.runtime.auth.Activator;
import org.eclipse.core.internal.runtime.auth.CipherInputStream;
import org.eclipse.core.internal.runtime.auth.CipherOutputStream;
import org.eclipse.core.internal.runtime.auth.Messages;
import org.eclipse.core.internal.runtime.auth.URLTool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AuthorizationDatabase {
    public static final String PI_RUNTIME_AUTH = "org.eclipse.core.runtime.auth.compatibility";
    public static final int FAILED_READ_METADATA = 4;
    public static final int FAILED_WRITE_METADATA = 5;
    private static final int KEYRING_FILE_VERSION = 1;
    private Hashtable authorizationInfo = new Hashtable(5);
    private Hashtable protectionSpace = new Hashtable(5);
    private File file = null;
    private String password = null;
    private boolean needsSaving = true;

    public AuthorizationDatabase() {
    }

    public AuthorizationDatabase(String string, String string2) throws CoreException {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        this.password = string2;
        this.file = new File(string);
        this.load();
    }

    public void addAuthorizationInfo(URL uRL, String string, String string2, Map map) {
        Hashtable<String, Map> hashtable;
        Assert.isNotNull((Object)uRL);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)map);
        String string3 = uRL.toString();
        Hashtable<String, Hashtable<String, Map>> hashtable2 = (Hashtable<String, Hashtable<String, Map>>)this.authorizationInfo.get(string3);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<String, Hashtable<String, Map>>(5);
            this.authorizationInfo.put(string3, hashtable2);
        }
        if ((hashtable = (Hashtable<String, Map>)hashtable2.get(string)) == null) {
            hashtable = new Hashtable<String, Map>(5);
            hashtable2.put(string, hashtable);
        }
        hashtable.put(string2.toLowerCase(), map);
        this.needsSaving = true;
    }

    public void addProtectionSpace(URL uRL, String string) {
        String string2;
        Assert.isNotNull((Object)uRL);
        Assert.isNotNull((Object)string);
        if (!uRL.getFile().endsWith("/")) {
            uRL = URLTool.getParent(uRL);
        }
        if ((string2 = this.getProtectionSpace(uRL)) != null && string2.equals(string)) {
            return;
        }
        String string3 = uRL.toString();
        Enumeration enumeration = this.protectionSpace.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!string3.startsWith(string4) && !string4.startsWith(string3)) continue;
            this.protectionSpace.remove(string4);
            break;
        }
        this.protectionSpace.put(string3, string);
        this.needsSaving = true;
    }

    public void flushAuthorizationInfo(URL uRL, String string, String string2) {
        Hashtable hashtable = (Hashtable)this.authorizationInfo.get(uRL.toString());
        if (hashtable == null) {
            return;
        }
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        if (hashtable2 == null) {
            return;
        }
        hashtable2.remove(string2.toLowerCase());
        this.needsSaving = true;
    }

    public Map getAuthorizationInfo(URL uRL, String string, String string2) {
        Hashtable hashtable = (Hashtable)this.authorizationInfo.get(uRL.toString());
        if (hashtable == null) {
            return null;
        }
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        if (hashtable2 == null) {
            return null;
        }
        return (Map)hashtable2.get(string2.toLowerCase());
    }

    public String getProtectionSpace(URL uRL) {
        while (uRL != null) {
            String string = (String)this.protectionSpace.get(uRL.toString());
            if (string != null) {
                return string;
            }
            uRL = URLTool.getParent(uRL);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load() throws CoreException {
        if (this.file == null) {
            return;
        }
        if (!this.file.exists()) {
            this.save();
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            try {
                this.load(fileInputStream);
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            {
                Object var2_6 = null;
                ((InputStream)fileInputStream).close();
                return;
            }
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 4, NLS.bind((String)Messages.meta_unableToReadAuthorization, (Object)this.file), (Throwable)iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 4, NLS.bind((String)Messages.meta_unableToReadAuthorization, (Object)this.file), (Throwable)classNotFoundException));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load(InputStream inputStream) throws IOException, ClassNotFoundException, CoreException {
        int n = inputStream.read();
        if (n == 1) {
            CipherInputStream cipherInputStream = new CipherInputStream(inputStream, this.password);
            ObjectInputStream objectInputStream = new ObjectInputStream(cipherInputStream);
            try {
                this.authorizationInfo = (Hashtable)objectInputStream.readObject();
                this.protectionSpace = (Hashtable)objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                objectInputStream.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                objectInputStream.close();
                return;
            }
        }
        Activator.log((IStatus)new Status(2, PI_RUNTIME_AUTH, 4, Messages.meta_authFormatChanged, null));
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        this.needsSaving = true;
        this.save();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws CoreException {
        if (!this.needsSaving || this.file == null) {
            return;
        }
        try {
            this.file.delete();
            if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs() || !AuthorizationDatabase.canWrite(this.file.getParentFile())) {
                throw new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 5, NLS.bind((String)Messages.meta_unableToWriteAuthorization, (Object)this.file), null));
            }
            this.file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            try {
                this.save(fileOutputStream);
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                fileOutputStream.close();
                throw throwable;
            }
            {
                Object var2_5 = null;
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 5, NLS.bind((String)Messages.meta_unableToWriteAuthorization, (Object)this.file), (Throwable)iOException));
        }
        this.needsSaving = false;
    }

    /*
     * Exception decompiling
     */
    private static boolean canWrite(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 55->58)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save(FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write(1);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(fileOutputStream, this.password);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(cipherOutputStream);
        try {
            objectOutputStream.writeObject(this.authorizationInfo);
            objectOutputStream.writeObject(this.protectionSpace);
            fileOutputStream.flush();
            fileOutputStream.getFD().sync();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            objectOutputStream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        objectOutputStream.close();
    }

    public boolean setPassword(String string, String string2) {
        if (!string.equals(this.password)) {
            return false;
        }
        this.password = string2;
        this.needsSaving = true;
        return true;
    }
}

