/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Tray
extends Widget {
    private Vector items = new Vector();

    Tray(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            Tray.error(22);
        }
        this.display = display;
        this.createWidget(0);
        final Display tmp = display;
        this.display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (event.display == tmp) {
                    Tray.this.dispose();
                }
            }
        });
    }

    public TrayItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error(6);
        }
        return (TrayItem)this.items.get(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public TrayItem[] getItems() {
        this.checkWidget();
        TrayItem[] result = new TrayItem[this.items.size()];
        this.items.toArray(result);
        return result;
    }

    public void dispose() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            TrayItem item = (TrayItem)this.items.get(i);
            item.dispose();
        }
        this.items.clear();
        super.dispose();
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = OS.Tray_New(this.display.internal_handle);
    }

    boolean hasNativeEvents() {
        return false;
    }

    void addItem(TrayItem item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
        }
    }

    void removeItem(TrayItem item) {
        this.items.remove(item);
    }
}

