/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PerspectiveRegistryReader
extends RegistryReader {
    private static final String TAG_LAYOUT = "perspective";
    private PerspectiveRegistry registry;

    public PerspectiveRegistryReader(PerspectiveRegistry perspectiveRegistry) {
        this.registry = perspectiveRegistry;
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_LAYOUT)) {
            try {
                PerspectiveDescriptor perspectiveDescriptor = new PerspectiveDescriptor(iConfigurationElement.getAttribute("id"), iConfigurationElement);
                this.registry.addPerspective(perspectiveDescriptor);
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log("Unable to create layout descriptor.", coreException.getStatus());
            }
            return true;
        }
        return false;
    }

    public void readPerspectives(IExtensionRegistry iExtensionRegistry) {
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui", "perspectives");
    }
}

