/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;

public final class WorkbenchWindowConfigurer
implements IWorkbenchWindowConfigurer {
    private WorkbenchWindow window;
    private int shellStyle = 1264;
    private String windowTitle;
    private boolean showFastViewBars = false;
    private boolean showPerspectiveBar = false;
    private boolean showStatusLine = true;
    private boolean showToolBar = true;
    private boolean showMenuBar = true;
    private boolean showProgressIndicator = false;
    private Map extraData = new HashMap(1);
    private ArrayList transferTypes = new ArrayList(3);
    private Point initialSize = new Point(1024, 768);

    WorkbenchWindowConfigurer(WorkbenchWindow workbenchWindow) {
        if (workbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        this.window = workbenchWindow;
        if (this.windowTitle == null) {
            this.windowTitle = "";
        }
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public IWorkbenchConfigurer getWorkbenchConfigurer() {
        return Workbench.getInstance().getWorkbenchConfigurer();
    }

    String basicGetTitle() {
        return this.windowTitle;
    }

    public String getTitle() {
        Shell shell = this.window.getShell();
        if (shell != null) {
            this.windowTitle = shell.getText();
            return this.windowTitle;
        }
        return this.windowTitle;
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.windowTitle = string;
        Shell shell = this.window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(string);
        }
    }

    public boolean getShowFastViewBars() {
        return this.showFastViewBars;
    }

    public void setShowFastViewBars(boolean bl) {
        this.showFastViewBars = bl;
    }

    public boolean getShowPerspectiveBar() {
        return this.showPerspectiveBar;
    }

    public boolean getShowStatusLine() {
        return this.showStatusLine;
    }

    public void setShowStatusLine(boolean bl) {
        this.showStatusLine = bl;
    }

    public boolean getShowProgressIndicator() {
        return this.showProgressIndicator;
    }

    public void setShowProgressIndicator(boolean bl) {
        this.showProgressIndicator = bl;
    }

    public Object getData(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.extraData.get(string);
    }

    public void setData(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (object != null) {
            this.extraData.put(string, object);
        } else {
            this.extraData.remove(string);
        }
    }

    public void addEditorAreaTransfer(Transfer transfer) {
        if (transfer != null && !this.transferTypes.contains(transfer)) {
            this.transferTypes.add(transfer);
            Transfer[] transferArray = new Transfer[this.transferTypes.size()];
            this.transferTypes.toArray(transferArray);
            this.window.getPages();
        }
    }

    public void configureEditorAreaDropListener() {
        IWorkbenchPage[] iWorkbenchPageArray = this.window.getPages();
        int n = 0;
        while (n < iWorkbenchPageArray.length) {
            WorkbenchPage cfr_ignored_0 = (WorkbenchPage)iWorkbenchPageArray[n];
            ++n;
        }
    }

    Transfer[] getTransfers() {
        Transfer[] transferArray = new Transfer[this.transferTypes.size()];
        this.transferTypes.toArray(transferArray);
        return transferArray;
    }

    public int getShellStyle() {
        return this.shellStyle;
    }

    public void setShellStyle(int n) {
        this.shellStyle = n;
    }

    public Point getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Point point) {
        this.initialSize = point;
    }

    public void createDefaultContents(Shell shell) {
        this.window.createDefaultContents(shell);
    }

    public Control createStatusLineControl(Composite composite) {
        return null;
    }

    public Control createPageComposite(Composite composite) {
        return this.window.createPageComposite(composite);
    }
}

