/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;

public class WorkbenchPreferenceManager
extends PreferenceManager
implements IExtensionChangeHandler {
    public WorkbenchPreferenceManager(char c) {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
    }

    public void addPages(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof WorkbenchPreferenceNode)) continue;
            WorkbenchPreferenceNode workbenchPreferenceNode = (WorkbenchPreferenceNode)e;
            this.addToRoot((IPreferenceNode)workbenchPreferenceNode);
            this.registerNode(workbenchPreferenceNode);
        }
    }

    private void registerNode(WorkbenchPreferenceNode workbenchPreferenceNode) {
        PlatformUI.getWorkbench().getExtensionTracker().registerObject(workbenchPreferenceNode.getConfigurationElement().getDeclaringExtension(), (Object)workbenchPreferenceNode, 2);
        IPreferenceNode[] iPreferenceNodeArray = workbenchPreferenceNode.getSubNodes();
        int n = 0;
        while (n < iPreferenceNodeArray.length) {
            this.registerNode((WorkbenchPreferenceNode)iPreferenceNodeArray[n]);
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            WorkbenchPreferenceNode workbenchPreferenceNode = PreferencePageRegistryReader.createNode(iConfigurationElementArray[n]);
            if (workbenchPreferenceNode != null) {
                this.registerNode(workbenchPreferenceNode);
                String string = workbenchPreferenceNode.getCategory();
                if (string == null) {
                    this.addToRoot((IPreferenceNode)workbenchPreferenceNode);
                } else {
                    WorkbenchPreferenceNode workbenchPreferenceNode2 = null;
                    Iterator iterator = this.getElements(1).iterator();
                    while (iterator.hasNext()) {
                        WorkbenchPreferenceNode workbenchPreferenceNode3 = (WorkbenchPreferenceNode)iterator.next();
                        if (!string.equals(workbenchPreferenceNode3.getId())) continue;
                        workbenchPreferenceNode2 = workbenchPreferenceNode3;
                        break;
                    }
                    if (workbenchPreferenceNode2 == null) {
                        System.out.println("Invalid preference page path: " + string);
                        this.addToRoot((IPreferenceNode)workbenchPreferenceNode);
                    } else {
                        workbenchPreferenceNode2.add((IPreferenceNode)workbenchPreferenceNode);
                    }
                }
            }
            ++n;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "preferencePages");
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof WorkbenchPreferenceNode) {
                WorkbenchPreferenceNode workbenchPreferenceNode = (WorkbenchPreferenceNode)objectArray[n];
                workbenchPreferenceNode.disposeResources();
                this.deepRemove(this.getRoot(), (IPreferenceNode)workbenchPreferenceNode);
            }
            ++n;
        }
    }

    private boolean deepRemove(IPreferenceNode iPreferenceNode, IPreferenceNode iPreferenceNode2) {
        if (iPreferenceNode == iPreferenceNode2 && iPreferenceNode == this.getRoot()) {
            this.removeAll();
            return true;
        }
        if (iPreferenceNode.remove(iPreferenceNode2)) {
            return true;
        }
        IPreferenceNode[] iPreferenceNodeArray = iPreferenceNode.getSubNodes();
        int n = 0;
        while (n < iPreferenceNodeArray.length) {
            if (this.deepRemove(iPreferenceNodeArray[n], iPreferenceNode2)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

