/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.IShellProvider;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PerspectiveListenerList;
import org.eclipse.ui.internal.SameShellProvider;
import org.eclipse.ui.internal.ShellPool;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.layout.TrimLayoutData;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.UIExtensionTracker;

public class WorkbenchWindow
implements IWorkbenchWindow {
    private boolean operationInProgress = false;
    private static int orientation = 0;
    private Control contents;
    private int returnCode = 0;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private IShellProvider parentShell;
    private static IShellProvider defaultModalParent = new IShellProvider(){

        public Shell getShell() {
            Display d = Display.getCurrent();
            if (d == null) {
                return null;
            }
            Shell parent = d.getActiveShell();
            if (parent == null) {
                parent = WorkbenchWindow.getModalChild(Display.getCurrent().getShells());
            } else {
                Shell modalChild = WorkbenchWindow.getModalChild(parent.getShells());
                if (modalChild != null) {
                    parent = modalChild;
                }
            }
            return parent;
        }
    };
    private WorkbenchWindowAdvisor windowAdvisor;
    private PageList pageList = new PageList();
    private PerspectiveListenerList perspectiveListeners = new PerspectiveListenerList();
    private boolean updateDisabled = true;
    private boolean closing = false;
    private boolean shellActivated = false;
    private TrimLayout defaultLayout;
    private boolean emptyWindowContentsCreated = false;
    private Control emptyWindowContents;
    private Rectangle normalBounds;
    private boolean asMaximizedState = false;
    private Composite pageComposite;
    private int submenus = 0;
    private WorkbenchWindowConfigurer windowConfigurer = null;
    private ShellPool detachedWindowShells;
    private int shellStyle;
    static final String GRP_PAGES = "pages";
    static final String GRP_PERSPECTIVES = "perspectives";
    static final String GRP_FAST_VIEWS = "fastViews";
    static final int VGAP = 0;
    static final int CLIENT_INSET = 3;
    static final int BAR_SIZE = 23;
    public static final int SHOW_VIEW_SUBMENU = 1;
    public static final int OPEN_PERSPECTIVE_SUBMENU = 2;
    public static final int NEW_WIZARD_SUBMENU = 4;
    private boolean perspectiveBarVisible = true;
    private boolean statusLineVisible = true;
    private Map actionSetHandlersByCommandId = new HashMap();
    private Map globalActionHandlersByCommandId = new HashMap();
    private List handlerActivations = new ArrayList();
    private int largeUpdates = 0;
    private IExtensionTracker tracker;
    private Shell shell;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void addSubmenu(int type) {
        this.submenus |= type;
    }

    public boolean containsSubmenu(int type) {
        return (this.submenus & type) != 0;
    }

    public WorkbenchWindow() {
        PlatformUI.getWorkbench();
        this.fireWindowOpening();
        this.setShellStyle(this.getWindowConfigurer().getShellStyle());
        Shell parentShell = this.getWorkbench().getDisplay().getActiveShell();
        this.setParentShell(parentShell);
    }

    protected void setShellStyle(int newShellStyle) {
        this.shellStyle = newShellStyle;
    }

    protected void setParentShell(Shell newParentShell) {
        Assert.isTrue(this.shell == null, "There must not be an existing shell.");
        this.parentShell = new SameShellProvider((Control)newParentShell);
    }

    protected int perspectiveBarStyle() {
        return 8520000;
    }

    void submitActionSetAndGlobalHandlers() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbench.getAdapter(clazz);
        HashMap handlersByCommandId = new HashMap();
        handlersByCommandId.putAll(this.actionSetHandlersByCommandId);
        handlersByCommandId.putAll(this.globalActionHandlersByCommandId);
        ArrayList<IHandlerActivation> newHandlers = new ArrayList<IHandlerActivation>(handlersByCommandId.size());
        Iterator existingIter = this.handlerActivations.iterator();
        while (existingIter.hasNext()) {
            IHandlerActivation next = (IHandlerActivation)existingIter.next();
            String cmdId = next.getCommandId();
            Object handler = handlersByCommandId.get(cmdId);
            if (handler == next.getHandler()) {
                handlersByCommandId.remove(cmdId);
                newHandlers.add(next);
                continue;
            }
            handlerService.deactivateHandler(next);
        }
        this.handlerActivations = newHandlers;
    }

    public void addPageListener(IPageListener l) {
    }

    public void addPerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.addPerspectiveListener(l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean busyClose() {
        boolean windowClosed;
        block8: {
            windowClosed = false;
            this.closing = true;
            this.updateDisabled = true;
            try {
                Workbench workbench = this.getWorkbenchImpl();
                int count = workbench.getWorkbenchWindowCount();
                if (!workbench.isStarting() && !workbench.isClosing() && count <= 1 && workbench.getWorkbenchConfigurer().getExitOnLastWindowClose()) {
                    windowClosed = workbench.close();
                } else if (this.okToClose()) {
                    windowClosed = this.hardClose();
                }
                Object var4_6 = null;
                if (!windowClosed) {
                    this.closing = false;
                    this.updateDisabled = false;
                }
                if (!windowClosed || this.tracker == null) break block8;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (!windowClosed) {
                    this.closing = false;
                    this.updateDisabled = false;
                }
                throw throwable;
            }
            this.tracker.close();
        }
        return windowClosed;
    }

    protected IWorkbenchPage busyOpenPage(String perspID, IAdaptable input) throws WorkbenchException {
        IWorkbenchPage newPage = null;
        if (this.pageList.isEmpty()) {
            newPage = new WorkbenchPage(this, perspID, input);
            this.pageList.add(newPage);
            this.firePageOpened(newPage);
            this.setActivePage(newPage);
        } else {
            IWorkbenchWindow window = this.getWorkbench().openWorkbenchWindow(perspID, input);
            newPage = window.getActivePage();
        }
        return newPage;
    }

    public int open() {
        if (this.getPages().length == 0) {
            this.showEmptyWindowContents();
        }
        this.fireWindowCreated();
        this.getWindowAdvisor().openIntro();
        int result = this.windowOpen();
        this.fireWindowOpened();
        return result;
    }

    public int windowOpen() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        if (((Workbench)this.getWorkbench()).isOpenShellEnabled()) {
            this.shell.open();
        }
        return this.returnCode;
    }

    protected void constrainShellSize() {
        Rectangle constrained;
        Rectangle bounds = this.shell.getBounds();
        if (!bounds.equals((Object)(constrained = this.getConstrainedShellBounds(bounds)))) {
            this.shell.setBounds(constrained);
        }
    }

    public void create() {
        this.shell = this.createShell();
        this.contents = this.createContents((Composite)this.shell);
        this.initializeBounds();
    }

    protected final Shell createShell() {
        Shell newParent = this.getParentShell();
        if (newParent != null && newParent.isDisposed()) {
            this.parentShell = new SameShellProvider(null);
            newParent = this.getParentShell();
        }
        Shell newShell = new Shell(Display.getCurrent(), this.getShellStyle());
        newShell.setData((Object)this);
        newShell.addShellListener(this.getShellListener());
        this.configureShell(newShell);
        return newShell;
    }

    protected Shell getParentShell() {
        Shell parent = this.parentShell.getShell();
        int modal = 229376;
        if ((this.getShellStyle() & modal) != 0 && parent == null) {
            parent = defaultModalParent.getShell();
        }
        return parent;
    }

    private static Shell getModalChild(Shell[] toSearch) {
        int modal = 229376;
        int i = toSearch.length - 1;
        while (i >= 0) {
            Shell shell = toSearch[i];
            Shell[] children = shell.getShells();
            Shell modalChild = WorkbenchWindow.getModalChild(children);
            if (modalChild != null) {
                return modalChild;
            }
            if (shell.isVisible() && (shell.getStyle() & modal) != 0) {
                return shell;
            }
            --i;
        }
        return null;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected ShellListener getShellListener() {
        return new ShellListener(){

            public void shellClosed(ShellEvent event) {
                event.doit = false;
                if (WorkbenchWindow.this.canHandleShellCloseEvent()) {
                    WorkbenchWindow.this.handleShellCloseEvent();
                }
            }

            public void shellActivated(ShellEvent arg0) {
            }

            public void shellDeactivated(ShellEvent arg0) {
            }

            public void shellDeiconified(ShellEvent arg0) {
            }

            public void shellIconified(ShellEvent arg0) {
            }
        };
    }

    protected int getShellStyle() {
        return this.shellStyle;
    }

    protected void handleShellCloseEvent() {
        this.setReturnCode(1);
        this.close();
    }

    protected void setReturnCode(int code) {
        this.returnCode = code;
    }

    protected boolean canHandleShellCloseEvent() {
        if (this.operationInProgress) {
            return false;
        }
        return this.fireWindowShellClosing();
    }

    public boolean close() {
        boolean[] ret = new boolean[]{this.busyClose()};
        return ret[0];
    }

    protected boolean isClosing() {
        return this.closing || this.getWorkbenchImpl().isClosing();
    }

    private void closeAllPages() {
        this.setActivePage(null);
        PageList oldList = this.pageList;
        this.pageList = new PageList();
        Iterator itr = oldList.iterator();
        while (itr.hasNext()) {
            WorkbenchPage page = (WorkbenchPage)itr.next();
            this.firePageClosed(page);
            page.dispose();
        }
        if (!this.closing) {
            this.showEmptyWindowContents();
        }
    }

    public void closeAllPages(boolean save) {
        boolean ret;
        if (save && !(ret = this.saveAllPages(true))) {
            return;
        }
        this.closeAllPages();
    }

    protected boolean closePage(IWorkbenchPage in, boolean save) {
        WorkbenchPage newPage;
        boolean oldIsActive;
        if (!this.pageList.contains(in)) {
            return false;
        }
        WorkbenchPage oldPage = (WorkbenchPage)in;
        boolean bl = oldIsActive = oldPage == this.getActiveWorkbenchPage();
        if (oldIsActive) {
            this.setActivePage(null);
        }
        this.pageList.remove(oldPage);
        oldPage.dispose();
        if (oldIsActive && (newPage = this.pageList.getNextActive()) != null) {
            this.setActivePage(newPage);
        }
        if (!this.closing && this.pageList.isEmpty()) {
            this.showEmptyWindowContents();
        }
        return true;
    }

    private void showEmptyWindowContents() {
        if (!this.emptyWindowContentsCreated) {
            Composite parent = this.getPageComposite();
            this.emptyWindowContentsCreated = true;
            parent.layout();
        }
    }

    private void hideEmptyWindowContents() {
        if (this.emptyWindowContentsCreated) {
            if (this.emptyWindowContents != null) {
                this.emptyWindowContents.dispose();
                this.emptyWindowContents = null;
                this.getPageComposite().layout();
            }
            this.emptyWindowContentsCreated = false;
        }
    }

    protected void configureShell(Shell shell) {
        Layout layout = this.getLayout();
        if (layout != null) {
            shell.setLayout(layout);
        }
        this.detachedWindowShells = new ShellPool(shell, 0x10 | WorkbenchWindow.getDefaultOrientation());
        String title = this.getWindowConfigurer().basicGetTitle();
        if (title != null) {
            shell.setText(title);
        }
        this.trackShellActivation(shell);
        this.trackShellResize(shell);
    }

    public static int getDefaultOrientation() {
        return orientation;
    }

    public static void setDefaultOrientation(int defaultOrientation) {
        orientation = defaultOrientation;
    }

    ShellPool getDetachedWindowPool() {
        return this.detachedWindowShells;
    }

    protected void createTrimWidgets(Shell shell) {
    }

    protected Composite createPageComposite(Composite parent) {
        this.pageComposite = new Composite(parent, 524288);
        this.pageComposite.setLayout((Layout)new FillLayout());
        return this.pageComposite;
    }

    protected Control createContents(Composite parent) {
        this.getWindowAdvisor().createWindowContents((Shell)parent);
        Assert.isNotNull(this.pageComposite, "createWindowContents must call configurer.createPageComposite");
        return this.pageComposite;
    }

    protected void createDefaultContents(Shell shell) {
        this.defaultLayout = new TrimLayout();
        this.defaultLayout.setSpacing(5, 5, 2, 2);
        shell.setLayout((Layout)this.defaultLayout);
        this.createPageComposite((Composite)shell);
        this.setLayoutDataForContents();
    }

    private void fireWindowOpening() {
        this.getWindowAdvisor().preWindowOpen();
    }

    void fireWindowRestored() throws WorkbenchException {
        this.getWindowAdvisor().postWindowRestore();
    }

    private void fireWindowCreated() {
        this.getWindowAdvisor().postWindowCreate();
    }

    private void fireWindowOpened() {
        this.getWorkbenchImpl().fireWindowOpened(this);
        this.getWindowAdvisor().postWindowOpen();
    }

    private boolean fireWindowShellClosing() {
        return this.getWindowAdvisor().preWindowShellClose();
    }

    private void fireWindowClosed() {
        this.getWindowAdvisor().postWindowClose();
        this.getWorkbenchImpl().fireWindowClosed(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePageActivated(IWorkbenchPage page) {
        String label = null;
        if (UIStats.isDebugging(11)) {
            label = "activated " + page.getLabel();
        }
        try {
            UIStats.start(11, label);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(11, page.getLabel(), label);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(11, page.getLabel(), label);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePageClosed(IWorkbenchPage page) {
        String label = null;
        if (UIStats.isDebugging(11)) {
            label = "closed " + page.getLabel();
        }
        try {
            UIStats.start(11, label);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(11, page.getLabel(), label);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(11, page.getLabel(), label);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void firePageOpened(IWorkbenchPage page) {
        String label = null;
        if (UIStats.isDebugging(11)) {
            label = "opened " + page.getLabel();
        }
        try {
            UIStats.start(11, label);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            UIStats.end(11, page.getLabel(), label);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        UIStats.end(11, page.getLabel(), label);
    }

    void firePerspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveListeners.firePerspectiveActivated(page, perspective);
    }

    void firePerspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveListeners.firePerspectiveDeactivated(page, perspective);
    }

    void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (perspective != null) {
            this.perspectiveListeners.firePerspectiveChanged(page, perspective, changeId);
        }
    }

    void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        if (perspective != null) {
            this.perspectiveListeners.firePerspectiveChanged(page, perspective, partRef, changeId);
        }
    }

    void firePerspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveListeners.firePerspectiveClosed(page, perspective);
    }

    void firePerspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.perspectiveListeners.firePerspectiveOpened(page, perspective);
    }

    void firePerspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
        this.perspectiveListeners.firePerspectiveSavedAs(page, oldPerspective, newPerspective);
    }

    public IWorkbenchPage getActivePage() {
        return this.pageList.getActive();
    }

    WorkbenchPage getActiveWorkbenchPage() {
        return this.pageList.getActive();
    }

    protected Composite getPageComposite() {
        return this.pageComposite;
    }

    public IWorkbenchPage[] getPages() {
        return this.pageList.getPages();
    }

    public IPartService getPartService() {
        System.out.println("WorkbenchWindow:getPartService: might need to restore this");
        return null;
    }

    protected Layout getLayout() {
        return null;
    }

    public ISelectionService getSelectionService() {
        System.out.println("WorkbenchWindow:getSelectionService: might need to restore this");
        return null;
    }

    public boolean getShellActivated() {
        return this.shellActivated;
    }

    public StatusLineManager getStatusLineManager2() {
        return null;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hardClose() {
        try {
            IWorkbench workbench = this.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            IHandlerService handlerService = (IHandlerService)workbench.getAdapter(clazz);
            handlerService.deactivateHandlers(this.handlerActivations);
            Iterator activationItr = this.handlerActivations.iterator();
            while (true) {
                block7: {
                    if (activationItr.hasNext()) break block7;
                    this.handlerActivations.clear();
                    this.actionSetHandlersByCommandId.clear();
                    this.globalActionHandlersByCommandId.clear();
                    this.closeAllPages();
                    this.fireWindowClosed();
                    this.getWindowAdvisor().dispose();
                    break;
                }
                IHandlerActivation activation = (IHandlerActivation)activationItr.next();
                activation.getHandler().dispose();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            boolean result = this.appWindowClose();
            throw throwable;
        }
        {
            Object var6_7 = null;
            return this.appWindowClose();
        }
    }

    public boolean appWindowClose() {
        if (this.operationInProgress) {
            return false;
        }
        return this.windowClose();
    }

    public boolean windowClose() {
        if (this.shell == null || this.shell.isDisposed()) {
            return true;
        }
        this.shell.dispose();
        this.shell = null;
        this.contents = null;
        return true;
    }

    public boolean isApplicationMenu(String menuID) {
        return false;
    }

    public boolean okToClose() {
        return this.getWorkbenchImpl().isClosing() || this.saveAllPages(true);
    }

    public IWorkbenchPage openPage(String perspId, IAdaptable input) throws WorkbenchException {
        Assert.isNotNull(perspId);
        Object[] result = new Object[1];
        try {
            result[0] = this.busyOpenPage(perspId, input);
        }
        catch (WorkbenchException e) {
            result[0] = e;
        }
        if (result[0] instanceof IWorkbenchPage) {
            return (IWorkbenchPage)result[0];
        }
        if (result[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)result[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.WorkbenchWindow_exceptionMessage);
    }

    public IWorkbenchPage openPage(IAdaptable input) throws WorkbenchException {
        String perspId = this.getWorkbenchImpl().getPerspectiveRegistry().getDefaultPerspective();
        return this.openPage(perspId, input);
    }

    public void removePageListener(IPageListener l) {
    }

    public void removePerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.removePerspectiveListener(l);
    }

    private IStatus unableToRestorePage(IMemento pageMem) {
        String pageName = pageMem.getString("label");
        if (pageName == null) {
            pageName = "";
        }
        return new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.WorkbenchWindow_unableToRestorePerspective, (Object)pageName), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus restoreState(IMemento memento, IPerspectiveDescriptor activeDescriptor) {
        Assert.isNotNull(this.getShell());
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.WorkbenchWindow_problemsRestoringWindow, null);
        Rectangle displayBounds = this.getShell().getDisplay().getBounds();
        Rectangle shellBounds = new Rectangle(0, 0, 0, 0);
        Integer bigInt = memento.getInteger("x");
        shellBounds.x = bigInt == null ? 0 : bigInt;
        bigInt = memento.getInteger("y");
        shellBounds.y = bigInt == null ? 0 : bigInt;
        bigInt = memento.getInteger("width");
        shellBounds.width = bigInt == null ? 0 : bigInt;
        bigInt = memento.getInteger("height");
        int n = shellBounds.height = bigInt == null ? 0 : bigInt;
        if (!shellBounds.isEmpty()) {
            if (!shellBounds.intersects(displayBounds)) {
                Rectangle clientArea = this.getShell().getDisplay().getClientArea();
                shellBounds.x = clientArea.x;
                shellBounds.y = clientArea.y;
            }
            this.getShell().setBounds(shellBounds);
        }
        if ("true".equals(memento.getString("maximized"))) {
            this.getShell().setMaximized(true);
        }
        "true".equals(memento.getString("minimized"));
        WorkbenchPage newActivePage = null;
        IMemento[] pageArray = memento.getChildren("page");
        int i = 0;
        while (i < pageArray.length) {
            block17: {
                IAdaptable input;
                String strFocus;
                IMemento pageMem;
                block18: {
                    Object var16_19;
                    String factoryID;
                    IMemento inputMem;
                    block19: {
                        pageMem = pageArray[i];
                        strFocus = pageMem.getString("focus");
                        if (strFocus == null || strFocus.length() == 0) break block17;
                        input = null;
                        inputMem = pageMem.getChild("input");
                        if (inputMem == null) break block18;
                        factoryID = inputMem.getString("factoryID");
                        if (factoryID != null) break block19;
                        WorkbenchPlugin.log("Unable to restore page - no input factory ID.");
                        result.add(this.unableToRestorePage(pageMem));
                        break block17;
                    }
                    try {
                        block22: {
                            block21: {
                                IElementFactory factory;
                                block20: {
                                    UIStats.start(4, "WorkbenchPageFactory");
                                    factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
                                    if (factory != null) break block20;
                                    WorkbenchPlugin.log("Unable to restore page - cannot instantiate input factory: " + factoryID);
                                    result.add(this.unableToRestorePage(pageMem));
                                    break block21;
                                }
                                input = factory.createElement(inputMem);
                                if (input != null) break block22;
                                WorkbenchPlugin.log("Unable to restore page - cannot instantiate input element: " + factoryID);
                                result.add(this.unableToRestorePage(pageMem));
                            }
                            var16_19 = null;
                            UIStats.end(4, factoryID, "WorkbenchPageFactory");
                            break block17;
                        }
                        var16_19 = null;
                    }
                    catch (Throwable throwable) {
                        var16_19 = null;
                        UIStats.end(4, factoryID, "WorkbenchPageFactory");
                        throw throwable;
                    }
                    UIStats.end(4, factoryID, "WorkbenchPageFactory");
                }
                WorkbenchPage newPage = null;
                try {
                    newPage = new WorkbenchPage(this, input);
                    result.add(newPage.restoreState(pageMem, activeDescriptor));
                    this.pageList.add(newPage);
                    this.firePageOpened(newPage);
                }
                catch (WorkbenchException e) {
                    WorkbenchPlugin.log("Unable to restore perspective - constructor failed.", (Throwable)((Object)e));
                    result.add(e.getStatus());
                    break block17;
                }
                if (strFocus != null && strFocus.length() > 0) {
                    newActivePage = newPage;
                }
            }
            ++i;
        }
        if (this.pageList.isEmpty()) {
            try {
                String defPerspID = this.getWorkbenchImpl().getPerspectiveRegistry().getDefaultPerspective();
                if (defPerspID != null) {
                    WorkbenchPage newPage = new WorkbenchPage(this, defPerspID, this.getDefaultPageInput());
                    this.pageList.add(newPage);
                    this.firePageOpened(newPage);
                }
            }
            catch (WorkbenchException e) {
                WorkbenchPlugin.log("Unable to create default perspective - constructor failed.", (Throwable)((Object)e));
                result.add(e.getStatus());
            }
        }
        if (newActivePage == null) {
            newActivePage = this.pageList.getNextActive();
        }
        this.setActivePage(newActivePage);
        return result;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.appWindowRun(fork, cancelable, runnable);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void appWindowRun(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        try {
            this.operationInProgress = true;
            runnable.run((IProgressMonitor)new NullProgressMonitor());
            contents = this.getContents();
            display = contents.getDisplay();
            shell = this.getShell();
            contentsWasEnabled = contents.getEnabled();
            shells = display.getShells();
            enabled = new boolean[shells.length];
            i = 0;
            while (true) {
                if (i >= shells.length) {
                    currentFocus = display.getFocusControl();
                    ** try [egrp 1[TRYBLOCK] [2 : 128->219)] { 
lbl15:
                    // 1 sources

                    break;
                }
                current = shells[i];
                if (current != shell && current != null && !current.isDisposed()) {
                    enabled[i] = current.getEnabled();
                    current.setEnabled(false);
                }
                ++i;
            }
            {
                contents.setEnabled(false);
                holder = new Exception[1];
                try {
                    ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.getProgressMonitor(), (Display)display);
                }
                catch (InvocationTargetException ite) {
                    holder[0] = ite;
                }
                catch (InterruptedException ie) {
                    holder[0] = ie;
                }
                if (holder[0] != null) {
                    if (holder[0] instanceof InvocationTargetException) {
                        throw (InvocationTargetException)holder[0];
                    }
                    if (holder[0] instanceof InterruptedException) {
                        throw (InterruptedException)holder[0];
                    }
                }
                ** GOTO lbl-1000
            }
lbl38:
            // 1 sources

            catch (Throwable var14_16) {
                var13_17 = null;
                this.operationInProgress = false;
                i = 0;
            }
            while (true) {
                if (i >= shells.length) {
                    if (!contents.isDisposed()) {
                        contents.setEnabled(contentsWasEnabled);
                    }
                    if (currentFocus == null) throw var14_16;
                    if (currentFocus.isDisposed() != false) throw var14_16;
                    currentFocus.forceFocus();
                    throw var14_16;
                }
                current = shells[i];
                if (current != shell && current != null && !current.isDisposed()) {
                    current.setEnabled(enabled[i]);
                }
                ++i;
            }
lbl-1000:
            // 1 sources

            {
                var13_18 = null;
                this.operationInProgress = false;
                i = 0;
                while (true) {
                    if (i >= shells.length) {
                        if (!contents.isDisposed()) {
                            contents.setEnabled(contentsWasEnabled);
                        }
                        if (currentFocus == null || currentFocus.isDisposed()) break;
                        currentFocus.forceFocus();
                        break;
                    }
                    current = shells[i];
                    if (current != shell && current != null && !current.isDisposed()) {
                        current.setEnabled(enabled[i]);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable var18_23) {
            var17_24 = null;
            this.operationInProgress = false;
            throw var18_23;
        }
        {
            var17_25 = null;
            this.operationInProgress = false;
            return;
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected Control getContents() {
        return this.contents;
    }

    private boolean saveAllPages(boolean bConfirm) {
        boolean bRet = true;
        Iterator itr = this.pageList.iterator();
        while (bRet && itr.hasNext()) {
            WorkbenchPage page = (WorkbenchPage)itr.next();
            bRet = page.saveAllEditors(bConfirm);
        }
        return bRet;
    }

    public IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.WorkbenchWindow_problemsSavingWindow, null);
        if (this.getShell().getMaximized() || this.asMaximizedState) {
            memento.putString("maximized", "true");
        }
        if (this.getShell().getMinimized()) {
            memento.putString("minimized", "true");
        }
        if (this.normalBounds == null) {
            this.normalBounds = this.getShell().getBounds();
        }
        memento.putInteger("x", this.normalBounds.x);
        memento.putInteger("y", this.normalBounds.y);
        memento.putInteger("width", this.normalBounds.width);
        memento.putInteger("height", this.normalBounds.height);
        Iterator itr = this.pageList.iterator();
        while (itr.hasNext()) {
            IPersistableElement persistable;
            IAdaptable input;
            WorkbenchPage page = (WorkbenchPage)itr.next();
            IMemento pageMem = memento.createChild("page");
            pageMem.putString("label", page.getLabel());
            result.add(page.saveState(pageMem));
            if (page == this.getActiveWorkbenchPage()) {
                pageMem.putString("focus", "true");
            }
            if ((input = page.getInput()) == null) continue;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.IPersistableElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((persistable = (IPersistableElement)input.getAdapter((Class)clazz)) == null) {
                WorkbenchPlugin.log("Unable to save page input: " + input + ", because it does not adapt to IPersistableElement");
                continue;
            }
            IMemento inputMem = pageMem.createChild("input");
            inputMem.putString("factoryID", persistable.getFactoryId());
            persistable.saveState(inputMem);
        }
        return result;
    }

    public void setActivePage(IWorkbenchPage in) {
        WorkbenchPage newPage;
        if (this.getActiveWorkbenchPage() == in) {
            return;
        }
        WorkbenchPage currentPage = this.getActiveWorkbenchPage();
        if (currentPage != null) {
            currentPage.onDeactivate();
        }
        if (in == null || this.pageList.contains(in)) {
            this.pageList.setActive(in);
        }
        if ((newPage = this.pageList.getActive()) != null) {
            this.hideEmptyWindowContents();
            newPage.onActivate();
            this.firePageActivated(newPage);
            if (newPage.getPerspective() != null) {
                this.firePerspectiveActivated(newPage, newPage.getPerspective());
            }
        }
        if (this.isClosing()) {
            return;
        }
        this.updateDisabled = false;
    }

    private void trackShellActivation(Shell shell) {
        shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = true;
                WorkbenchWindow.this.getWorkbenchImpl().setActivatedWindow(WorkbenchWindow.this);
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null) {
                    IWorkbenchPart part = currentPage.getActivePart();
                    if (part != null) {
                        PartSite site = (PartSite)part.getSite();
                        site.getPane().shellActivated();
                    }
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowActivated(WorkbenchWindow.this);
                }
            }

            public void shellDeactivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = false;
                WorkbenchPage currentPage = WorkbenchWindow.this.getActiveWorkbenchPage();
                if (currentPage != null) {
                    IWorkbenchPart part = currentPage.getActivePart();
                    if (part != null) {
                        PartSite site = (PartSite)part.getSite();
                        site.getPane().shellDeactivated();
                    }
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowDeactivated(WorkbenchWindow.this);
                }
            }

            public void shellClosed(ShellEvent arg0) {
            }

            public void shellDeiconified(ShellEvent arg0) {
            }

            public void shellIconified(ShellEvent arg0) {
            }
        });
    }

    private void trackShellResize(Shell newShell) {
        newShell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                this.saveBounds();
            }

            public void controlResized(ControlEvent e) {
                this.saveBounds();
            }

            private void saveBounds() {
                Shell shell = WorkbenchWindow.this.getShell();
                if (shell == null) {
                    return;
                }
                if (shell.isDisposed()) {
                    return;
                }
                if (shell.getMinimized()) {
                    return;
                }
                if (shell.getMaximized()) {
                    WorkbenchWindow.this.asMaximizedState = true;
                    return;
                }
                WorkbenchWindow.this.asMaximizedState = false;
                WorkbenchWindow.this.normalBounds = shell.getBounds();
            }
        });
    }

    public void updateActionBars() {
        if (this.updateDisabled || this.updatesDeferred()) {
            return;
        }
    }

    private boolean updatesDeferred() {
        return this.largeUpdates > 0;
    }

    public final void largeUpdateStart() {
        ++this.largeUpdates;
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            this.updateActionBars();
        }
    }

    WorkbenchWindowConfigurer getWindowConfigurer() {
        if (this.windowConfigurer == null) {
            this.windowConfigurer = new WorkbenchWindowConfigurer(this);
        }
        return this.windowConfigurer;
    }

    private WorkbenchAdvisor getAdvisor() {
        return this.getWorkbenchImpl().getAdvisor();
    }

    private WorkbenchWindowAdvisor getWindowAdvisor() {
        if (this.windowAdvisor == null) {
            this.windowAdvisor = this.getAdvisor().createWorkbenchWindowAdvisor(this.getWindowConfigurer());
            Assert.isNotNull(this.windowAdvisor);
        }
        return this.windowAdvisor;
    }

    private Workbench getWorkbenchImpl() {
        return Workbench.getInstance();
    }

    protected void initializeBounds() {
        Point size = this.getInitialSize();
        Point location = this.getInitialLocation(size);
        this.getShell().setBounds(this.getConstrainedShellBounds(new Rectangle(location.x, location.y, size.x, size.y)));
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        return preferredSize;
    }

    protected Point getInitialLocation(Point size) {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getLocation();
        }
        return this.getInitialLocation(size);
    }

    protected Point getInitialSize() {
        return this.getWindowConfigurer().getInitialSize();
    }

    public void setPerspectiveBarVisible(boolean visible) {
        boolean oldValue = this.perspectiveBarVisible;
        this.perspectiveBarVisible = visible;
        if (oldValue != this.perspectiveBarVisible) {
            this.updateLayoutDataForContents();
        }
    }

    public boolean getPerspectiveBarVisible() {
        return this.perspectiveBarVisible;
    }

    public void setStatusLineVisible(boolean visible) {
        boolean oldValue = this.statusLineVisible;
        this.statusLineVisible = visible;
        if (oldValue != this.statusLineVisible) {
            this.updateLayoutDataForContents();
        }
    }

    public boolean getStatusLineVisible() {
        return this.statusLineVisible;
    }

    private void updateLayoutDataForContents() {
        if (this.defaultLayout == null) {
            return;
        }
        this.defaultLayout.setCenterControl((Control)this.getPageComposite());
    }

    public boolean getShowFastViewBars() {
        return this.getWindowConfigurer().getShowFastViewBars();
    }

    private void setLayoutDataForContents() {
        this.updateLayoutDataForContents();
    }

    protected boolean showTopSeperator() {
        return false;
    }

    public void addToTrim(Control control, int side) {
        Control reference = null;
        control.setLayoutData((Object)new TrimLayoutData(false, -1, -1));
        this.defaultLayout.addTrim(control, side, reference);
    }

    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getWorkbench().getDisplay());
        }
        return this.tracker;
    }

    IAdaptable getDefaultPageInput() {
        return this.getWorkbenchImpl().getDefaultPageInput();
    }

    public Shell getShell() {
        return this.shell;
    }

    class PageList {
        private List pagesInCreationOrder = new ArrayList(4);
        private List pageInActivationOrder = new ArrayList(4);
        private Object active;

        public boolean add(Object object) {
            this.pagesInCreationOrder.add(object);
            this.pageInActivationOrder.add(0, object);
            return true;
        }

        public Iterator iterator() {
            return this.pagesInCreationOrder.iterator();
        }

        public boolean contains(Object object) {
            return this.pagesInCreationOrder.contains(object);
        }

        public boolean remove(Object object) {
            if (this.active == object) {
                this.active = null;
            }
            this.pageInActivationOrder.remove(object);
            return this.pagesInCreationOrder.remove(object);
        }

        public boolean isEmpty() {
            return this.pagesInCreationOrder.isEmpty();
        }

        public IWorkbenchPage[] getPages() {
            int nSize = this.pagesInCreationOrder.size();
            IWorkbenchPage[] retArray = new IWorkbenchPage[nSize];
            this.pagesInCreationOrder.toArray(retArray);
            return retArray;
        }

        public void setActive(Object page) {
            if (this.active == page) {
                return;
            }
            this.active = page;
            if (page != null) {
                this.pageInActivationOrder.remove(page);
                this.pageInActivationOrder.add(page);
            }
        }

        public WorkbenchPage getActive() {
            return (WorkbenchPage)this.active;
        }

        public WorkbenchPage getNextActive() {
            if (this.active == null) {
                if (this.pageInActivationOrder.isEmpty()) {
                    return null;
                }
                return (WorkbenchPage)this.pageInActivationOrder.get(this.pageInActivationOrder.size() - 1);
            }
            if (this.pageInActivationOrder.size() < 2) {
                return null;
            }
            return (WorkbenchPage)this.pageInActivationOrder.get(this.pageInActivationOrder.size() - 2);
        }
    }
}

