/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.jaxp.implForCore;

import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    private Node currentNode = null;
    private Document document = null;
    private Locator locator = null;
    private ErrorHandler errorHandler = null;
    private boolean fNamespaces = false;
    private boolean cdataStarted = false;

    public Document getDocument() {
        return this.document;
    }

    public void setNamespaces(boolean namespaces) {
        this.fNamespaces = namespaces;
    }

    public void setNamespacePrefixes(boolean namespacePrefixes) {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.document = new DocumentImpl();
        this.currentNode = this.document;
    }

    public void endDocument() throws SAXException {
        if (this.currentNode == this.document) {
            this.currentNode = null;
        } else {
            this.warning(EXmlMsg.getDefault().getString(56));
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element element = this.fNamespaces ? this.document.createElementNS(namespaceURI, qName) : this.document.createElement(qName);
        this.currentNode.appendChild(element);
        this.currentNode = element;
        int length = atts.getLength();
        if (this.fNamespaces) {
            int i = 0;
            while (i < length) {
                element.setAttributeNS(atts.getURI(i), atts.getQName(i), atts.getValue(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                element.setAttribute(atts.getQName(i), atts.getValue(i));
                ++i;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.fNamespaces) {
            this.endElementNS(namespaceURI, localName);
        } else {
            this.endElement(qName);
        }
    }

    protected void endElement(String qName) throws SAXException {
        if (this.currentNode.getNodeName().equals(qName)) {
            this.currentNode = this.currentNode.getParentNode();
        } else {
            Node node = this.retreiveSuperNode(qName, this.currentNode);
            if (node == this.document) {
                this.warning(EXmlMsg.getDefault().getString(33, this.currentNode.getNodeName()));
                this.currentNode = this.document;
            } else if (node == null) {
                this.warning(EXmlMsg.getDefault().getString(55, qName));
                this.currentNode = this.document;
            } else {
                this.currentNode = node.getParentNode();
            }
        }
    }

    protected Node retreiveSuperNode(String qName, Node node) throws SAXException {
        while (node != null && node != this.document) {
            if (node.getNodeName().equals(qName)) {
                return node;
            }
            this.warning(EXmlMsg.getDefault().getString(33, this.currentNode.getNodeName()));
            node = node.getParentNode();
        }
        return null;
    }

    protected void endElementNS(String namespaceURI, String localName) throws SAXException {
        if (this.currentNode.getNamespaceURI().equals(namespaceURI) && this.currentNode.getLocalName().equals(localName)) {
            this.currentNode = this.currentNode.getParentNode();
        } else {
            this.warning(EXmlMsg.getDefault().getString(33, this.currentNode.getNodeName()));
            Node node = this.retreiveSuperNodeNS(namespaceURI, localName, this.currentNode.getParentNode());
            if (node != null) {
                this.currentNode = node.getParentNode();
            }
        }
    }

    protected Node retreiveSuperNodeNS(String namespaceURI, String localName, Node node) throws SAXException {
        while (node != null) {
            if (node.getNamespaceURI().equals(namespaceURI) && node.getLocalName().equals(localName)) {
                return node;
            }
            this.warning(EXmlMsg.getDefault().getString(33, this.currentNode.getNodeName()));
            node = node.getParentNode();
        }
        return null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentNode != this.document) {
            Text text = !this.cdataStarted ? this.document.createTextNode(new String(ch, start, length)) : this.document.createCDATASection(new String(ch, start, length));
            this.currentNode.appendChild(text);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.currentNode != this.document) {
            ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
            this.currentNode.appendChild(pi);
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void warning(String message) throws SAXException {
        if (this.errorHandler == null) {
            throw new SAXParseException(message, this.locator);
        }
        this.errorHandler.warning(new SAXParseException(message, this.locator));
    }

    protected void fatalError(String message) throws SAXException {
        if (this.errorHandler == null) {
            throw new SAXParseException(message, this.locator);
        }
        this.errorHandler.fatalError(new SAXParseException(message, this.locator));
    }

    protected String getQNameOf(Node node) {
        return node.getPrefix().equals("") ? node.getLocalName() : String.valueOf(node.getPrefix()) + ":" + node.getLocalName();
    }

    public void startCDATA() throws SAXException {
        this.cdataStarted = true;
    }

    public void endCDATA() throws SAXException {
        this.cdataStarted = false;
    }

    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String arg0) throws SAXException {
    }

    public void startEntity(String arg0) throws SAXException {
    }
}

