/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import java.io.InputStream;

public class SimpleBufferedInputStream
extends InputStream {
    InputStream in;
    byte[] buf;
    int bytesAvailable;
    int pos;
    static final int DefaultBufferSize = 2048;

    public SimpleBufferedInputStream(InputStream inputStream) throws IOException {
        this.in = inputStream;
        this.pos = 0;
        this.buf = new byte[2048];
        this.fillByteBuffer();
    }

    public int read() throws IOException {
        if (this.pos < this.bytesAvailable) {
            return this.buf[this.pos++] & 0xFF;
        }
        if (this.fillByteBuffer() != -1) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n >= 0 && n <= byArray.length && n2 >= 0 && n2 <= byArray.length - n) {
            int n3;
            int n4;
            if (n2 == 0) {
                return 0;
            }
            if (this.pos < this.bytesAvailable) {
                n4 = this.bytesAvailable - this.pos >= n2 ? n2 : this.bytesAvailable - this.pos;
                System.arraycopy(this.buf, this.pos, byArray, n, n4);
                this.pos += n4;
                if (n4 == n2 || this.in.available() == 0) {
                    return n4;
                }
                n += n4;
                n3 = n2 - n4;
            } else {
                n3 = n2;
            }
            while (true) {
                if (n3 >= this.buf.length) {
                    n4 = this.in.read(byArray, n, n3);
                    if (n4 == -1) {
                        return n3 == n2 ? -1 : n2 - n3;
                    }
                } else {
                    if (this.fillByteBuffer() == -1) {
                        return n3 == n2 ? -1 : n2 - n3;
                    }
                    n4 = this.bytesAvailable - this.pos >= n3 ? n3 : this.bytesAvailable - this.pos;
                    System.arraycopy(this.buf, this.pos, byArray, n, n4);
                    this.pos += n4;
                }
                if ((n3 -= n4) == 0) {
                    return n2;
                }
                if (this.in.available() == 0) {
                    return n2 - n3;
                }
                n += n4;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void unread(byte[] byArray, int n) {
        if (this.pos >= n) {
            this.pos -= n;
        } else {
            int n2 = n - this.pos;
            byte[] byArray2 = new byte[this.buf.length + n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            System.arraycopy(this.buf, 0, byArray2, n2, this.buf.length);
            this.buf = byArray2;
        }
    }

    int fillByteBuffer() throws IOException {
        int n = this.in.read(this.buf, 0, this.buf.length);
        this.bytesAvailable = n == -1 ? 0 : n;
        this.pos = 0;
        return n;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.buf = null;
    }

    public int available() throws IOException {
        return this.bytesAvailable - this.pos + this.in.available();
    }

    public synchronized long skip(long l) throws IOException {
        if (l < 1L) {
            return 0L;
        }
        if ((long)(this.bytesAvailable - this.pos) >= l) {
            this.pos = (int)((long)this.pos + l);
            return l;
        }
        long l2 = this.bytesAvailable - this.pos;
        this.pos = this.bytesAvailable;
        return l2 + this.in.skip(l - l2);
    }
}

