/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class ContentViewer
extends Viewer {
    private IContentProvider contentProvider = null;
    private Object input = null;
    private IBaseLabelProvider labelProvider = null;
    private final ILabelProviderListener labelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
            ContentViewer.this.handleLabelProviderChanged(labelProviderChangedEvent);
        }
    };

    protected ContentViewer() {
    }

    public IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public Object getInput() {
        return this.input;
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider();
        }
        return this.labelProvider;
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
        if (this.contentProvider != null) {
            this.contentProvider.inputChanged(this, this.getInput(), null);
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
        if (this.labelProvider != null) {
            this.labelProvider.removeListener(this.labelProviderListener);
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        this.labelProviderChanged();
    }

    protected void hookControl(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ContentViewer.this.handleDispose(disposeEvent);
            }
        });
    }

    protected void labelProviderChanged() {
        this.refresh();
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        Assert.isNotNull(iContentProvider);
        IContentProvider iContentProvider2 = this.contentProvider;
        this.contentProvider = iContentProvider;
        if (iContentProvider2 != null) {
            Object object = this.getInput();
            iContentProvider2.inputChanged(this, object, null);
            iContentProvider2.dispose();
            iContentProvider.inputChanged(this, null, object);
            this.refresh();
        }
    }

    public void setInput(Object object) {
        Assert.isTrue(this.getContentProvider() != null, "ContentViewer must have a content provider when input is set.");
        Object object2 = this.getInput();
        this.contentProvider.inputChanged(this, object2, object);
        this.input = object;
        this.inputChanged(this.input, object2);
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        IBaseLabelProvider iBaseLabelProvider2 = this.labelProvider;
        if (iBaseLabelProvider == iBaseLabelProvider2) {
            return;
        }
        if (iBaseLabelProvider2 != null) {
            iBaseLabelProvider2.removeListener(this.labelProviderListener);
        }
        this.labelProvider = iBaseLabelProvider;
        if (iBaseLabelProvider != null) {
            iBaseLabelProvider.addListener(this.labelProviderListener);
        }
        this.refresh();
        if (iBaseLabelProvider2 != null) {
            iBaseLabelProvider2.dispose();
        }
    }
}

