/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.util.INode;

public class FeatureWrap
implements INode {
    public static final int UNKNOWN = 0;
    public static final int RESOLVED = 1;
    public static final int NO_RESOLVED = 2;
    private VersionedIdentifier vid = null;
    private String showedName = "";
    private ISiteFeatureReference featureReference = null;
    private boolean selected = false;
    private IFeature feature = null;
    private String version = "?.?.?";
    private Vector uiObjects = new Vector();
    private boolean previousSelected = false;
    private int resolvedStatus = 0;

    public FeatureWrap() {
    }

    public FeatureWrap(ISiteFeatureReference iSiteFeatureReference) {
        this.featureReference = iSiteFeatureReference;
        try {
            this.vid = iSiteFeatureReference.getVersionedIdentifier();
            this.version = this.vid.getVersion().toString();
            this.showedName = "{" + this.vid.getIdentifier() + "}" + " (" + this.version + ")";
        }
        catch (CoreException coreException) {}
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public Vector getUiObjects() {
        return this.uiObjects;
    }

    public void addUiObject(Object object) {
        this.uiObjects.add(object);
    }

    public String getShowedName() {
        return this.showedName;
    }

    public INode findByUiObject(Object object) {
        int n = 0;
        while (n < this.uiObjects.size()) {
            if (this.uiObjects.elementAt(n).equals(object)) {
                return this;
            }
            ++n;
        }
        return null;
    }

    public boolean isFeatureReady() {
        return this.feature != null;
    }

    public boolean downloadFeature(IProgressMonitor iProgressMonitor) {
        if (this.feature == null) {
            try {
                this.feature = this.featureReference.getFeature(iProgressMonitor);
                this.showedName = String.valueOf(this.feature.getLabel()) + " (" + this.version + ")";
                return true;
            }
            catch (CoreException coreException) {
                this.feature = null;
            }
        }
        return false;
    }

    public long getFeatureIncludeSize() {
        long l;
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        if (this.feature != null && (l = this.feature.getDownloadSize() + this.feature.getInstallSize()) > 0L) {
            return l;
        }
        return 0L;
    }

    public long getFeatureSize() {
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        if (this.feature != null) {
            HashSet<IPluginEntry> hashSet = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> hashSet2 = new HashSet<INonPluginEntry>();
            IPluginEntry[] iPluginEntryArray = this.feature.getPluginEntries();
            hashSet.addAll(Arrays.asList(iPluginEntryArray));
            INonPluginEntry[] iNonPluginEntryArray = this.feature.getNonPluginEntries();
            hashSet2.addAll(Arrays.asList(iNonPluginEntryArray));
            IPluginEntry[] iPluginEntryArray2 = new IPluginEntry[hashSet.size()];
            INonPluginEntry[] iNonPluginEntryArray2 = new INonPluginEntry[hashSet2.size()];
            if (hashSet.size() != 0) {
                hashSet.toArray(iPluginEntryArray2);
            }
            if (hashSet2.size() != 0) {
                hashSet2.toArray(iNonPluginEntryArray2);
            }
            long l = 0L;
            try {
                l = this.feature.getFeatureContentProvider().getDownloadSizeFor(iPluginEntryArray2, iNonPluginEntryArray2) + this.feature.getFeatureContentProvider().getInstallSizeFor(iPluginEntryArray2, iNonPluginEntryArray2);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            if (l > 0L) {
                return l;
            }
        }
        return 0L;
    }

    public String getDescription() {
        IURLEntry iURLEntry;
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        if (this.feature != null && (iURLEntry = this.feature.getDescription()) != null) {
            return iURLEntry.getAnnotation();
        }
        return "";
    }

    public String getLicense() {
        IURLEntry iURLEntry;
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        if (this.feature != null && (iURLEntry = this.feature.getLicense()) != null) {
            return iURLEntry.getAnnotation();
        }
        return "";
    }

    public IFeature getFeature() {
        if (this.feature == null) {
            this.downloadFeature(null);
        }
        return this.feature;
    }

    public void releaseFeature() {
        this.feature = null;
    }

    public boolean isPreviousSelected() {
        return this.previousSelected;
    }

    public void setPreviousSelected(boolean bl) {
        this.previousSelected = bl;
    }

    public int getResolvedStatus() {
        return this.resolvedStatus;
    }

    public void setResolvedStatus(int n) {
        this.resolvedStatus = n;
    }

    public VersionedIdentifier getVID() {
        return this.vid;
    }
}

