/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import com.ibm.ugl.eswt.OS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.InternalGCData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;

public final class Image
implements Drawable {
    public int type;
    public int internal_handle;
    Device device;
    static final int DEFAULT_SCANLINE_PAD = 4;
    GC memGC;

    static ImageData createImageDataFromNativeImage(int handle) {
        ImageData imageData;
        Object[] pixels;
        int depth = OS.Image_GetDepth(handle);
        boolean isDirect = OS.Image_IsDirect(handle);
        PaletteData palette = null;
        int alphaMask = 0;
        int alphaShift = 0;
        if (isDirect) {
            int[] masks = OS.Image_GetDirectPaletteMasks(handle);
            palette = new PaletteData(masks[0], masks[1], masks[2]);
            alphaMask = masks[3];
            alphaShift = Image.countBits(alphaMask, 0);
        } else {
            int numColors = Compatibility.pow2(depth);
            byte[] red = new byte[numColors];
            byte[] green = new byte[numColors];
            byte[] blue = new byte[numColors];
            OS.Image_GetIndexedPalette(handle, red, green, blue);
            RGB[] rgb = new RGB[numColors];
            for (int i = 0; i < numColors; ++i) {
                rgb[i] = new RGB(red[i] & 0xFF, green[i] & 0xFF, blue[i] & 0xFF);
            }
            palette = new PaletteData(rgb);
        }
        int[] bounds = OS.Image_GetBounds(handle);
        int width = bounds[2];
        int height = bounds[3];
        if (depth > 8) {
            pixels = OS.Image_GetPixelsHighColor(handle);
            int pixelIndex = 0;
            imageData = new ImageData(width, height, depth, palette);
            if (alphaMask != 0) {
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int alpha = Image.getPixelRGBComponent(pixels[pixelIndex], alphaMask, alphaShift);
                        imageData.setAlpha(x, y, alpha);
                        imageData.setPixel(x, y, pixels[pixelIndex]);
                        ++x;
                        ++pixelIndex;
                    }
                }
            } else {
                imageData.setPixels(0, 0, pixels.length, (int[])pixels, 0);
            }
        } else {
            pixels = OS.Image_GetPixelsLowColor(handle);
            int bytesPerLine = pixels.length / height;
            int usedBytesPerLine = Compatibility.ceil(width * depth, 8);
            int scanlinePad = bytesPerLine - usedBytesPerLine + 1;
            while (bytesPerLine % scanlinePad > 0) {
                ++scanlinePad;
            }
            imageData = new ImageData(width, height, depth, palette, scanlinePad, (byte[])pixels);
        }
        imageData.transparentPixel = OS.Image_GetTransparentColor(handle);
        return imageData;
    }

    static int getPixelRGBComponent(int pixel, int mask, int shift) {
        return (pixel & mask) >>> shift;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static int imageFormat(String fileName) {
        InputStream stream = null;
        stream = Compatibility.newFileInputStream(fileName);
        byte[] buffer = new byte[32];
        stream.read(buffer, 0, buffer.length);
        stream.close();
        int n = Image.imageFormat(buffer);
        Object var5_5 = null;
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return n;
        catch (IOException e) {
            try {
                SWT.error(39, e);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {}
        }
        return -1;
    }

    static int imageFormat(byte[] streamBytes) {
        if (Image.isPNGFormat(streamBytes)) {
            return 5;
        }
        if (Image.isGIFFormat(streamBytes)) {
            return 2;
        }
        if (Image.isJPEGFormat(streamBytes)) {
            return 4;
        }
        return -1;
    }

    static boolean isPNGFormat(byte[] streamBytes) {
        if (streamBytes.length < 8) {
            return false;
        }
        if ((streamBytes[0] & 0xFF) != 137) {
            return false;
        }
        if ((streamBytes[1] & 0xFF) != 80) {
            return false;
        }
        if ((streamBytes[2] & 0xFF) != 78) {
            return false;
        }
        if ((streamBytes[3] & 0xFF) != 71) {
            return false;
        }
        if ((streamBytes[4] & 0xFF) != 13) {
            return false;
        }
        if ((streamBytes[5] & 0xFF) != 10) {
            return false;
        }
        if ((streamBytes[6] & 0xFF) != 26) {
            return false;
        }
        return (streamBytes[7] & 0xFF) == 10;
    }

    static boolean isGIFFormat(byte[] streamBytes) {
        if (streamBytes.length < 3) {
            return false;
        }
        if (streamBytes[0] != 71) {
            return false;
        }
        if (streamBytes[1] != 73) {
            return false;
        }
        return streamBytes[2] == 70;
    }

    static boolean isJPEGFormat(byte[] streamBytes) {
        if (streamBytes.length < 2) {
            return false;
        }
        if ((streamBytes[0] & 0xFF) != 255) {
            return false;
        }
        return (streamBytes[1] & 0xFF) == 216;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readImageStream(InputStream stream) {
        byte[] buffer = new byte[512];
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        try {
            boolean done = false;
            while (!done) {
                int length = stream.read(buffer);
                if (-1 == length) {
                    done = true;
                    continue;
                }
                baoStream.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        finally {
            try {
                baoStream.close();
            }
            catch (IOException iOException) {}
        }
        return baoStream.toByteArray();
    }

    static int countBits(int mask, int bit) {
        int count = 0;
        if (mask == 0) {
            return 0;
        }
        while ((mask >> count & 1) == bit) {
            ++count;
        }
        return count;
    }

    Image() {
    }

    public Image(Device device, ImageData data) {
        this.init(device, data);
    }

    public Image(Device device, InputStream stream) {
        this.init(device, stream);
    }

    public Image(Device device, int width, int height) {
        this.init(device, width, height);
    }

    public Image(Device device, Rectangle bounds) {
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(device, bounds.width, bounds.height);
    }

    public Image(Device device, String filename) {
        this.init(device, filename);
    }

    public void dispose() {
        if (this.internal_handle == 0) {
            return;
        }
        if (this.memGC != null) {
            this.memGC.dispose();
            this.memGC = null;
        }
        OS.Image_Dispose(this.internal_handle);
        this.internal_handle = 0;
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.internal_handle == image.internal_handle;
    }

    public Rectangle getBounds() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0) {
            SWT.error(40);
        }
        int[] rect = OS.Image_GetBounds(this.internal_handle);
        return new Rectangle(rect[0], rect[1], rect[2], rect[3]);
    }

    public ImageData getImageData() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0) {
            SWT.error(40);
        }
        ImageData imageData = Image.createImageDataFromNativeImage(this.internal_handle);
        return imageData;
    }

    public int hashCode() {
        return this.internal_handle;
    }

    void init(Device device, ImageData imageData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (imageData == null) {
            SWT.error(4);
        }
        int depth = imageData.depth;
        this.device = device;
        PaletteData palette = imageData.palette;
        if (palette.isDirect) {
            byte[] byteData = imageData.data;
            int width = imageData.width;
            int height = imageData.height;
            int[] intData = new int[width * height];
            int bytesPerPixel = depth / 8;
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int redShift = Image.countBits(redMask, 0);
            int greenShift = Image.countBits(greenMask, 0);
            int blueShift = Image.countBits(blueMask, 0);
            int redMax8bit = 0;
            int greenMax8bit = 0;
            int blueMax8bit = 0;
            if (depth == 8) {
                int redSize = Image.countBits(redMask >> redShift, 1);
                int greenSize = Image.countBits(greenMask >> greenShift, 1);
                int blueSize = Image.countBits(blueMask >> blueShift, 1);
                redMax8bit = (1 << redSize) - 1;
                greenMax8bit = (1 << greenSize) - 1;
                blueMax8bit = (1 << blueSize) - 1;
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int byteIndex = y * imageData.bytesPerLine + x * bytesPerPixel;
                    int pixel = depth == 8 ? byteData[byteIndex] : (depth == 16 ? (byteData[byteIndex + 1] & 0xFF) << 8 | byteData[byteIndex] & 0xFF : (depth == 24 ? (byteData[byteIndex] & 0xFF) << 16 | (byteData[byteIndex + 1] & 0xFF) << 8 | byteData[byteIndex + 2] & 0xFF : (byteData[byteIndex] & 0xFF) << 24 | (byteData[byteIndex + 1] & 0xFF) << 16 | (byteData[byteIndex + 2] & 0xFF) << 8 | byteData[byteIndex + 3] & 0xFF));
                    int red = Image.getPixelRGBComponent(pixel, redMask, redShift);
                    int green = Image.getPixelRGBComponent(pixel, greenMask, greenShift);
                    int blue = Image.getPixelRGBComponent(pixel, blueMask, blueShift);
                    if (depth == 8) {
                        int RedMax16bit = 31;
                        int GreenMax16bit = 63;
                        int BlueMax16bit = 31;
                        if (redMax8bit != 0) {
                            red = red * 31 / redMax8bit;
                        }
                        if (greenMax8bit != 0) {
                            green = green * 63 / greenMax8bit;
                        }
                        if (blueMax8bit != 0) {
                            blue = blue * 31 / blueMax8bit;
                        }
                        intData[y * width + x] = red << 11 | green << 5 | blue;
                        continue;
                    }
                    intData[y * width + x] = depth == 16 ? red << 11 | green << 5 | blue : (depth == 24 ? red << 16 | green << 8 | blue : (imageData.alpha == -1 && imageData.alphaData == null && imageData.transparentPixel == -1 ? 0xFF000000 | red << 16 | green << 8 | blue : red << 16 | green << 8 | blue));
                }
            }
            if (depth == 8) {
                depth = 16;
            }
            this.internal_handle = OS.Image_NewFromIntData(device.internal_handle, width, height, intData, depth, imageData.transparentPixel, imageData.alpha, imageData.alphaData);
        } else {
            RGB[] rgbs = imageData.getRGBs();
            int paletteSize = Math.min(rgbs.length, 1 << depth);
            byte[] indexedReds = new byte[paletteSize];
            byte[] indexedGreens = new byte[paletteSize];
            byte[] indexedBlues = new byte[paletteSize];
            for (int i = 0; i < paletteSize; ++i) {
                RGB rgb = rgbs[i];
                indexedReds[i] = (byte)rgb.red;
                indexedGreens[i] = (byte)rgb.green;
                indexedBlues[i] = (byte)rgb.blue;
            }
            this.internal_handle = OS.Image_NewFromByteData(device.internal_handle, imageData.width, imageData.height, imageData.data, imageData.bytesPerLine, depth, indexedReds, indexedGreens, indexedBlues, paletteSize, imageData.transparentPixel);
        }
    }

    void init(Device device, String fileName) {
        int imageFormat;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fileName == null) {
            SWT.error(4);
        }
        if ((imageFormat = Image.imageFormat(fileName)) == -1) {
            SWT.error(42);
        }
        this.internal_handle = OS.Image_NewFromFile(device.internal_handle, fileName);
        this.device = device;
    }

    void init(Device device, InputStream stream) {
        byte[] buffer;
        int imageFormat;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (stream == null) {
            SWT.error(4);
        }
        if ((imageFormat = Image.imageFormat(buffer = Image.readImageStream(stream))) == -1) {
            SWT.error(42);
        }
        this.internal_handle = OS.Image_NewFromFileData(device.internal_handle, buffer, buffer.length);
        this.device = device;
    }

    void init(Device device, int width, int height) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (width <= 0 | height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.internal_handle = OS.Image_NewFromSize(device.internal_handle, width, height, -16777216);
        if (this.internal_handle == 0) {
            SWT.error(2);
        }
    }

    public void internal_copyArea(int destImageHandle, int srcX, int srcY, int srcWidth, int srcHeight) {
        OS.Image_CopyArea(this.internal_handle, destImageHandle, srcX, srcY, srcWidth, srcHeight);
    }

    public void internal_dispose_GC(int painter, InternalGCData data) {
    }

    public Rectangle internal_getBounds() {
        return this.getBounds();
    }

    public int internal_getDepth() {
        return OS.Image_GetDepth(this.internal_handle);
    }

    public int internal_new_GC(InternalGCData data) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int gcHandle = OS.Image_NewGraphics(this.internal_handle);
        data.device = this.device;
        data.image = this;
        return gcHandle;
    }

    public boolean isDisposed() {
        return this.internal_handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.internal_handle + "}";
    }

    public Rectangle internal_getDefaultClipping() {
        return this.getBounds();
    }
}

