/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Date;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;

public class MessageHelper {
    public static String getResolutionFailureMessage(VersionConstraint versionConstraint) {
        if (versionConstraint.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (versionConstraint instanceof ImportPackageSpecification) {
            return NLS.bind(EclipseAdaptorMsg.ECLIPSE_MISSING_IMPORTED_PACKAGE, MessageHelper.toString(versionConstraint));
        }
        if (versionConstraint instanceof BundleSpecification) {
            if (((BundleSpecification)versionConstraint).isOptional()) {
                return NLS.bind(EclipseAdaptorMsg.ECLIPSE_MISSING_OPTIONAL_REQUIRED_BUNDLE, MessageHelper.toString(versionConstraint));
            }
            return NLS.bind(EclipseAdaptorMsg.ECLIPSE_MISSING_REQUIRED_BUNDLE, MessageHelper.toString(versionConstraint));
        }
        return NLS.bind(EclipseAdaptorMsg.ECLIPSE_MISSING_HOST, MessageHelper.toString(versionConstraint));
    }

    public static void debug(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new Date(System.currentTimeMillis()));
        stringBuffer.append(" - [");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append("] ");
        stringBuffer.append(string);
        System.out.println(((Object)stringBuffer).toString());
    }

    private static String toString(VersionConstraint versionConstraint) {
        VersionRange versionRange = versionConstraint.getVersionRange();
        if (versionRange == null) {
            return versionConstraint.getName();
        }
        return String.valueOf(versionConstraint.getName()) + '_' + versionRange;
    }
}

