/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class WorkbenchCommandSupport
implements IWorkbenchCommandSupport {
    private Map activationsBySubmission = null;
    private final IHandlerService handlerService;

    public WorkbenchCommandSupport(CommandManager commandManager, ContextManager contextManager, IHandlerService iHandlerService) {
        if (iHandlerService == null) {
            throw new NullPointerException("The handler service cannot be null");
        }
        this.handlerService = iHandlerService;
    }

    public final void addHandlerSubmission(HandlerSubmission handlerSubmission) {
    }

    public final void addHandlerSubmissions(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addHandlerSubmission((HandlerSubmission)iterator.next());
        }
    }

    public CommandManager getCommandManager() {
        return null;
    }

    public final void removeHandlerSubmission(HandlerSubmission handlerSubmission) {
        if (this.activationsBySubmission == null) {
            return;
        }
        Object v = this.activationsBySubmission.remove(handlerSubmission);
        if (v instanceof IHandlerActivation) {
            IHandlerActivation iHandlerActivation = (IHandlerActivation)v;
            this.handlerService.deactivateHandler(iHandlerActivation);
        }
    }

    public final void removeHandlerSubmissions(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeHandlerSubmission((HandlerSubmission)iterator.next());
        }
    }
}

