/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistryReader;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectiveRegistry
implements IPerspectiveRegistry,
IExtensionChangeHandler {
    private String defaultPerspID;
    private static final String EXT = "_persp.xml";
    private static final String ID_DEF_PERSP = "PerspectiveRegistry.DEFAULT_PERSP";
    private static final String PERSP = "_persp";
    private static final char SPACE_DELIMITER = ' ';
    private List perspectives = new ArrayList(10);
    private ArrayList perspToRemove = new ArrayList(5);

    public PerspectiveRegistry() {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, null);
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().endsWith(PerspectiveRegistry.PERSP)) {
                    this.mergePerspectives(propertyChangeEvent);
                } else if (propertyChangeEvent.getProperty().equals("perspectives")) {
                    this.updatePreferenceList((IPreferenceStore)propertyChangeEvent.getSource());
                }
            }

            private void mergePerspectives(PropertyChangeEvent propertyChangeEvent) {
                String string;
                IPreferenceStore iPreferenceStore = (IPreferenceStore)propertyChangeEvent.getSource();
                if (propertyChangeEvent.getNewValue() == null) {
                    IPerspectiveDescriptor[] iPerspectiveDescriptorArray = PerspectiveRegistry.this.getPerspectives();
                    int n = 0;
                    while (n < iPerspectiveDescriptorArray.length) {
                        String string2 = iPerspectiveDescriptorArray[n].getId();
                        if (propertyChangeEvent.getProperty().startsWith(string2)) {
                            if (!PerspectiveRegistry.this.perspToRemove.contains(string2)) {
                                iPreferenceStore.setValue(String.valueOf(string2) + PerspectiveRegistry.PERSP, (String)propertyChangeEvent.getOldValue());
                            } else {
                                PerspectiveRegistry.this.perspToRemove.remove(string2);
                            }
                        }
                        ++n;
                    }
                } else if ((propertyChangeEvent.getOldValue() == null || propertyChangeEvent.getOldValue().equals("")) && PerspectiveRegistry.this.findPerspectiveWithId(string = propertyChangeEvent.getProperty().substring(0, propertyChangeEvent.getProperty().lastIndexOf(PerspectiveRegistry.PERSP))) == null) {
                    PerspectiveDescriptor perspectiveDescriptor = new PerspectiveDescriptor(null, null, null);
                    StringReader stringReader = new StringReader((String)propertyChangeEvent.getNewValue());
                    try {
                        XMLMemento xMLMemento = XMLMemento.createReadRoot(stringReader);
                        perspectiveDescriptor.restoreState(xMLMemento);
                        PerspectiveRegistry.this.addPerspective(perspectiveDescriptor);
                    }
                    catch (WorkbenchException workbenchException) {
                        PerspectiveRegistry.this.unableToLoadPerspective(workbenchException.getStatus());
                    }
                }
                this.updatePreferenceList(iPreferenceStore);
            }

            private void updatePreferenceList(IPreferenceStore iPreferenceStore) {
                IPerspectiveDescriptor[] iPerspectiveDescriptorArray = PerspectiveRegistry.this.getPerspectives();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < iPerspectiveDescriptorArray.length) {
                    PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveDescriptorArray[n];
                    if (PerspectiveRegistry.this.hasCustomDefinition(perspectiveDescriptor)) {
                        stringBuffer.append(perspectiveDescriptor.getId()).append(' ');
                    }
                    ++n;
                }
                String string = stringBuffer.toString().trim();
                iPreferenceStore.setValue("perspectives", string);
            }
        });
    }

    public void addPerspective(PerspectiveDescriptor perspectiveDescriptor) {
        if (perspectiveDescriptor == null) {
            return;
        }
        this.add(perspectiveDescriptor);
    }

    private void add(PerspectiveDescriptor perspectiveDescriptor) {
        this.perspectives.add(perspectiveDescriptor);
        IConfigurationElement iConfigurationElement = perspectiveDescriptor.getConfigElement();
        if (iConfigurationElement != null) {
            PlatformUI.getWorkbench().getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), (Object)perspectiveDescriptor, 2);
        }
    }

    public PerspectiveDescriptor createPerspective(String string, PerspectiveDescriptor perspectiveDescriptor) {
        if (!this.validateLabel(string)) {
            return null;
        }
        if (this.findPerspectiveWithLabel(string) != null) {
            return null;
        }
        String string2 = string.replace(' ', '_');
        string2 = string2.trim();
        PerspectiveDescriptor perspectiveDescriptor2 = new PerspectiveDescriptor(string2, string, perspectiveDescriptor);
        this.add(perspectiveDescriptor2);
        return perspectiveDescriptor2;
    }

    public void revertPerspectives(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)arrayList.get(n);
            this.perspToRemove.add(perspectiveDescriptor.getId());
            perspectiveDescriptor.revertToPredefined();
            ++n;
        }
    }

    public void deletePerspectives(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            this.deletePerspective((IPerspectiveDescriptor)arrayList.get(n));
            ++n;
        }
    }

    public void deletePerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveDescriptor;
        if (!perspectiveDescriptor.isPredefined()) {
            this.perspToRemove.add(perspectiveDescriptor.getId());
            this.perspectives.remove(perspectiveDescriptor);
            perspectiveDescriptor.deleteCustomDefinition();
            this.verifyDefaultPerspective();
        }
    }

    private void internalDeletePerspective(PerspectiveDescriptor perspectiveDescriptor) {
        this.perspToRemove.add(perspectiveDescriptor.getId());
        this.perspectives.remove(perspectiveDescriptor);
        perspectiveDescriptor.deleteCustomDefinition();
        this.verifyDefaultPerspective();
    }

    void deleteCustomDefinition(PerspectiveDescriptor perspectiveDescriptor) {
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setToDefault(String.valueOf(perspectiveDescriptor.getId()) + PERSP);
    }

    boolean hasCustomDefinition(PerspectiveDescriptor perspectiveDescriptor) {
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.contains(String.valueOf(perspectiveDescriptor.getId()) + PERSP);
    }

    public IPerspectiveDescriptor findPerspectiveWithId(String string) {
        Iterator iterator = this.perspectives.iterator();
        while (iterator.hasNext()) {
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iterator.next();
            if (!perspectiveDescriptor.getId().equals(string)) continue;
            return perspectiveDescriptor;
        }
        return null;
    }

    public IPerspectiveDescriptor findPerspectiveWithLabel(String string) {
        Iterator iterator = this.perspectives.iterator();
        while (iterator.hasNext()) {
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iterator.next();
            if (!perspectiveDescriptor.getLabel().equals(string)) continue;
            return perspectiveDescriptor;
        }
        return null;
    }

    public String getDefaultPerspective() {
        return this.defaultPerspID;
    }

    public IPerspectiveDescriptor[] getPerspectives() {
        return this.perspectives.toArray(new IPerspectiveDescriptor[this.perspectives.size()]);
    }

    public void load() {
        this.loadPredefined();
        this.loadCustom();
        this.verifyDefaultPerspective();
    }

    private void loadCustom() {
        Object object;
        Object object2;
        Object object3;
        Reader reader = null;
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("perspectives");
        String[] stringArray = StringConverter.asArray((String)string);
        int n = 0;
        while (n < stringArray.length) {
            try {
                object3 = iPreferenceStore.getString(String.valueOf(stringArray[n]) + PERSP);
                if (object3 != null && ((String)object3).length() != 0) {
                    reader = new StringReader((String)object3);
                }
                object2 = XMLMemento.createReadRoot(reader);
                PerspectiveDescriptor perspectiveDescriptor = new PerspectiveDescriptor(null, null, null);
                perspectiveDescriptor.restoreState((IMemento)object2);
                String string2 = perspectiveDescriptor.getId();
                object = this.findPerspectiveWithId(string2);
                if (object == null) {
                    this.add(perspectiveDescriptor);
                }
                reader.close();
            }
            catch (IOException iOException) {
                this.unableToLoadPerspective(null);
            }
            catch (WorkbenchException workbenchException) {
                this.unableToLoadPerspective(workbenchException.getStatus());
            }
            ++n;
        }
        IPath iPath = WorkbenchPlugin.getDefault().getDataLocation();
        if (iPath == null) {
            return;
        }
        object3 = iPath.toFile();
        if (((File)object3).isDirectory()) {
            object2 = ((File)object3).listFiles();
            int n2 = ((File[])object2).length;
            int n3 = 0;
            while (n3 < n2) {
                object = object2[n3];
                if (((File)object).getName().endsWith(EXT)) {
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream((File)object);
                        reader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                        XMLMemento xMLMemento = XMLMemento.createReadRoot(reader);
                        PerspectiveDescriptor perspectiveDescriptor = new PerspectiveDescriptor(null, null, null);
                        perspectiveDescriptor.restoreState(xMLMemento);
                        IPerspectiveDescriptor iPerspectiveDescriptor = this.findPerspectiveWithId(perspectiveDescriptor.getId());
                        if (iPerspectiveDescriptor == null) {
                            this.add(perspectiveDescriptor);
                        }
                        this.saveCustomPersp(perspectiveDescriptor, xMLMemento);
                        ((File)object).delete();
                        reader.close();
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        this.unableToLoadPerspective(null);
                    }
                    catch (WorkbenchException workbenchException) {
                        this.unableToLoadPerspective(workbenchException.getStatus());
                    }
                }
                ++n3;
            }
        }
    }

    private void unableToLoadPerspective(IStatus iStatus) {
        String string = WorkbenchMessages.Perspective_problemLoadingTitle;
        String string2 = WorkbenchMessages.Perspective_errorLoadingState;
        if (iStatus == null) {
            ShowMessage.openError(null, string, string2);
        } else {
            ShowMessage.openError(null, string, string2);
        }
    }

    public void saveCustomPersp(PerspectiveDescriptor perspectiveDescriptor, XMLMemento xMLMemento) throws IOException {
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        StringWriter stringWriter = new StringWriter();
        xMLMemento.save(stringWriter);
        ((Writer)stringWriter).close();
        iPreferenceStore.setValue(String.valueOf(perspectiveDescriptor.getId()) + PERSP, ((Object)stringWriter).toString());
    }

    public IMemento getCustomPersp(String string) throws WorkbenchException, IOException {
        Reader reader = null;
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        String string2 = iPreferenceStore.getString(String.valueOf(string) + PERSP);
        if (string2 != null && string2.length() != 0) {
            reader = new StringReader(string2);
        }
        XMLMemento xMLMemento = XMLMemento.createReadRoot(reader);
        reader.close();
        return xMLMemento;
    }

    private void loadPredefined() {
        PerspectiveRegistryReader perspectiveRegistryReader = new PerspectiveRegistryReader(this);
        perspectiveRegistryReader.readPerspectives(Platform.getExtensionRegistry());
    }

    public void setDefaultPerspective(String string) {
        IPerspectiveDescriptor iPerspectiveDescriptor = this.findPerspectiveWithId(string);
        if (iPerspectiveDescriptor != null) {
            this.defaultPerspID = string;
            PrefUtil.getAPIPreferenceStore().setValue("defaultPerspectiveId", string);
        }
    }

    public boolean validateLabel(String string) {
        return (string = string.trim()).length() > 0;
    }

    private void verifyDefaultPerspective() {
        IPerspectiveDescriptor iPerspectiveDescriptor = null;
        if (this.defaultPerspID != null) {
            iPerspectiveDescriptor = this.findPerspectiveWithId(this.defaultPerspID);
        }
        if (iPerspectiveDescriptor != null) {
            return;
        }
        String string = PrefUtil.getAPIPreferenceStore().getString("defaultPerspectiveId");
        if (string != null && string.length() > 0) {
            iPerspectiveDescriptor = this.findPerspectiveWithId(string);
        }
        if (iPerspectiveDescriptor != null) {
            this.defaultPerspID = string;
            return;
        }
        this.defaultPerspID = Workbench.getInstance().getDefaultPerspectiveId();
    }

    public IPerspectiveDescriptor clonePerspective(String string, String string2, IPerspectiveDescriptor iPerspectiveDescriptor) {
        if (string2 == null || string2.trim().length() <= 0) {
            throw new IllegalArgumentException();
        }
        IPerspectiveDescriptor iPerspectiveDescriptor2 = this.findPerspectiveWithId(string);
        if (iPerspectiveDescriptor2 != null) {
            throw new IllegalArgumentException();
        }
        iPerspectiveDescriptor2 = new PerspectiveDescriptor(string, string2, (PerspectiveDescriptor)iPerspectiveDescriptor);
        this.add((PerspectiveDescriptor)iPerspectiveDescriptor2);
        return iPerspectiveDescriptor2;
    }

    public void revertPerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveDescriptor;
        this.perspToRemove.add(perspectiveDescriptor.getId());
        perspectiveDescriptor.revertToPredefined();
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof PerspectiveDescriptor) {
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)objectArray[n];
                int n2 = 0;
                while (n2 < iWorkbenchWindowArray.length) {
                    IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
                    int n3 = 0;
                    while (n3 < iWorkbenchPageArray.length) {
                        WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPageArray[n3];
                        workbenchPage.closePerspective(perspectiveDescriptor, true, true);
                        ++n3;
                    }
                    ++n2;
                }
                this.internalDeletePerspective(perspectiveDescriptor);
            }
            ++n;
        }
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            PerspectiveRegistryReader perspectiveRegistryReader = new PerspectiveRegistryReader(this);
            perspectiveRegistryReader.readElement(iConfigurationElementArray[n]);
            ++n;
        }
    }
}

