/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class EqualsExpression
extends Expression {
    private static final int HASH_INITIAL;
    private Object fExpectedValue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.EqualsExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    public EqualsExpression(Object object) {
        Assert.isNotNull((Object)object);
        this.fExpectedValue = object;
    }

    public EqualsExpression(IConfigurationElement iConfigurationElement) throws CoreException {
        String string = iConfigurationElement.getAttribute("value");
        Expressions.checkAttribute("value", string);
        this.fExpectedValue = Expressions.convertArgument(string);
    }

    public EqualsExpression(Element element) throws CoreException {
        String string = element.getAttribute("value");
        Expressions.checkAttribute("value", string.length() > 0 ? string : null);
        this.fExpectedValue = Expressions.convertArgument(string);
    }

    public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        Object object = iEvaluationContext.getDefaultVariable();
        return EvaluationResult.valueOf(object.equals(this.fExpectedValue));
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        expressionInfo.markDefaultVariableAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof EqualsExpression)) {
            return false;
        }
        EqualsExpression equalsExpression = (EqualsExpression)object;
        return this.fExpectedValue.equals(equalsExpression.fExpectedValue);
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fExpectedValue.hashCode();
    }
}

