/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DecoratingLabelProvider
extends LabelProvider
implements ILabelProvider,
IViewerLabelProvider,
IColorProvider,
IFontProvider {
    private ILabelProvider provider;
    private ILabelDecorator decorator;
    private ListenerList listeners = new ListenerList();

    public DecoratingLabelProvider(ILabelProvider iLabelProvider, ILabelDecorator iLabelDecorator) {
        Assert.isNotNull(iLabelProvider);
        this.provider = iLabelProvider;
        this.decorator = iLabelDecorator;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        super.addListener(iLabelProviderListener);
        this.provider.addListener(iLabelProviderListener);
        if (this.decorator != null) {
            this.decorator.addListener(iLabelProviderListener);
        }
        this.listeners.add(iLabelProviderListener);
    }

    public void dispose() {
        this.provider.dispose();
        if (this.decorator != null) {
            this.decorator.dispose();
        }
    }

    public Image getImage(Object object) {
        Image image;
        Image image2 = this.provider.getImage(object);
        if (this.decorator != null && (image = this.decorator.decorateImage(image2, object)) != null) {
            return image;
        }
        return image2;
    }

    public ILabelDecorator getLabelDecorator() {
        return this.decorator;
    }

    public ILabelProvider getLabelProvider() {
        return this.provider;
    }

    public String getText(Object object) {
        String string;
        String string2 = this.provider.getText(object);
        if (this.decorator != null && (string = this.decorator.decorateText(string2, object)) != null) {
            return string;
        }
        return string2;
    }

    public boolean isLabelProperty(Object object, String string) {
        if (this.provider.isLabelProperty(object, string)) {
            return true;
        }
        return this.decorator != null && this.decorator.isLabelProperty(object, string);
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        super.removeListener(iLabelProviderListener);
        this.provider.removeListener(iLabelProviderListener);
        if (this.decorator != null) {
            this.decorator.removeListener(iLabelProviderListener);
        }
        this.listeners.remove(iLabelProviderListener);
    }

    public void setLabelDecorator(ILabelDecorator iLabelDecorator) {
        ILabelDecorator iLabelDecorator2 = this.decorator;
        if (iLabelDecorator2 != iLabelDecorator) {
            int n;
            Object[] objectArray = this.listeners.getListeners();
            if (iLabelDecorator2 != null) {
                n = 0;
                while (n < objectArray.length) {
                    iLabelDecorator2.removeListener((ILabelProviderListener)objectArray[n]);
                    ++n;
                }
            }
            this.decorator = iLabelDecorator;
            if (iLabelDecorator != null) {
                n = 0;
                while (n < objectArray.length) {
                    iLabelDecorator.addListener((ILabelProviderListener)objectArray[n]);
                    ++n;
                }
            }
            this.fireLabelProviderChanged(new LabelProviderChangedEvent(this));
        }
    }

    public void updateLabel(ViewerLabel viewerLabel, Object object) {
        IDelayedLabelDecorator iDelayedLabelDecorator;
        ILabelDecorator iLabelDecorator = this.getLabelDecorator();
        String string = viewerLabel.getText();
        boolean bl = true;
        if (iLabelDecorator instanceof IDelayedLabelDecorator && !(iDelayedLabelDecorator = (IDelayedLabelDecorator)iLabelDecorator).prepareDecoration(object, string)) {
            bl = false;
        }
        if (bl || string == null || viewerLabel.getText().length() == 0) {
            viewerLabel.setText(this.getText(object));
        }
        iDelayedLabelDecorator = viewerLabel.getImage();
        if (bl || iDelayedLabelDecorator == null) {
            viewerLabel.setImage(this.getImage(object));
        }
        if (bl) {
            this.updateForDecorationReady(viewerLabel, object);
        }
    }

    protected void updateForDecorationReady(ViewerLabel viewerLabel, Object object) {
        if (this.decorator instanceof IColorDecorator) {
            IColorDecorator iColorDecorator = (IColorDecorator)((Object)this.decorator);
            viewerLabel.setBackground(iColorDecorator.decorateBackground(object));
            viewerLabel.setForeground(iColorDecorator.decorateForeground(object));
        }
        if (this.decorator instanceof IFontDecorator) {
            viewerLabel.setFont(((IFontDecorator)((Object)this.decorator)).decorateFont(object));
        }
    }

    public Color getBackground(Object object) {
        if (this.provider instanceof IColorProvider) {
            return ((IColorProvider)((Object)this.provider)).getBackground(object);
        }
        return null;
    }

    public Font getFont(Object object) {
        if (this.provider instanceof IFontProvider) {
            return ((IFontProvider)((Object)this.provider)).getFont(object);
        }
        return null;
    }

    public Color getForeground(Object object) {
        if (this.provider instanceof IColorProvider) {
            return ((IColorProvider)((Object)this.provider)).getForeground(object);
        }
        return null;
    }
}

