/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.core.runtime.IProgressMonitor;

public class UpdateMonitor
implements IProgressMonitor {
    private boolean isCanceldNow = false;
    private boolean allDone = false;
    private String name;
    private String taskName;
    private String subTaskName;
    private int totalWork;
    double doneWork = 0.0;
    private boolean enableDebug = false;

    public void beginTask(String string, int n) {
        this.name = string;
        this.totalWork = n;
        this.doneWork = 0.0;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Task begins.(name=\"" + string + "\", total work=" + n + ")");
        }
    }

    public void done() {
        this.allDone = true;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Done!");
        }
    }

    public void internalWorked(double d) {
        this.doneWork += d;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Progress now is " + this.doneWork + " / " + this.totalWork);
        }
    }

    public boolean isCanceled() {
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Cancel status(" + this.isCanceldNow + ") is checked.");
        }
        return this.isCanceldNow;
    }

    public void setCanceled(boolean bl) {
        this.isCanceldNow = bl;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Cancel value is set as " + this.isCanceldNow);
        }
    }

    public void setTaskName(String string) {
        this.taskName = string;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Task Name: " + string);
        }
    }

    public void subTask(String string) {
        this.subTaskName = string;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Sub Task : (" + string + ")");
        }
    }

    public void worked(int n) {
        this.doneWork += (double)n;
        if (this.enableDebug) {
            System.out.println("[UpdateMonitor] Progress now is " + this.doneWork + " / " + this.totalWork);
        }
    }

    public boolean isDone() {
        return this.allDone;
    }

    public String getName() {
        return this.name;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getSubTaskName() {
        return this.subTaskName;
    }

    public int getTotalWorksCount() {
        return this.totalWork;
    }

    public double getDoneWorksCount() {
        return this.doneWork;
    }

    public void setDebug(boolean bl) {
        this.enableDebug = bl;
    }
}

