/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences.legacy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.internal.preferences.exchange.IProductPreferencesService;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ProductPreferencesService
implements IProductPreferencesService {
    private static final IPath NL_DIR = new Path("$nl$");
    public static final String PRODUCT_KEY = "preferenceCustomization";
    private static final String LEGACY_PRODUCT_CUSTOMIZATION_FILENAME = "plugin_customization.ini";
    private static final String PROPERTIES_FILE_EXTENSION = "properties";
    private boolean initialized = false;
    private String customizationValue = null;
    private Bundle customizationBundle = null;
    private String productID = null;

    private void initValues() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        IProduct iProduct = Platform.getProduct();
        if (iProduct == null) {
            if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                InternalPlatform.message("Product not available to set product default preference overrides.");
            }
            return;
        }
        this.productID = iProduct.getId();
        if (this.productID == null) {
            if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                InternalPlatform.message("Product ID not available to apply product-level preference defaults.");
            }
            return;
        }
        this.customizationBundle = iProduct.getDefiningBundle();
        if (this.customizationBundle == null) {
            if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                InternalPlatform.message("Bundle not available to apply product-level preference defaults for product id: " + this.productID);
            }
            return;
        }
        this.customizationValue = iProduct.getProperty(PRODUCT_KEY);
        if (this.customizationValue == null) {
            if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                InternalPlatform.message("Product : " + this.productID + " does not define preference customization file. Using legacy file: plugin_customization.ini");
            }
            this.customizationValue = LEGACY_PRODUCT_CUSTOMIZATION_FILENAME;
        }
    }

    public Properties getProductCustomization() {
        this.initValues();
        URL uRL = null;
        if (this.customizationValue != null) {
            try {
                uRL = new URL(this.customizationValue);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = FileLocator.find((Bundle)this.customizationBundle, (IPath)new Path(this.customizationValue), null);
            }
        }
        if (uRL == null && InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
            InternalPlatform.message("Product preference customization file: " + this.customizationValue + " not found for bundle: " + this.productID);
        }
        return this.loadProperties(uRL);
    }

    public Properties getProductTranslation() {
        this.initValues();
        URL uRL = null;
        if (this.customizationValue != null) {
            uRL = FileLocator.find((Bundle)this.customizationBundle, (IPath)NL_DIR.append(this.customizationValue).removeFileExtension().addFileExtension(PROPERTIES_FILE_EXTENSION), null);
        }
        if (uRL == null && InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
            InternalPlatform.message("No preference translations found for product/file: " + this.customizationBundle.getSymbolicName() + '/' + this.customizationValue);
        }
        return this.loadProperties(uRL);
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties(URL var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 88->91)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

