/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class SubMonitor
implements IProgressMonitorWithBlocking {
    private static final int MINIMUM_RESOLUTION = 1000;
    private int totalParent;
    private int usedForParent = 0;
    private double usedForChildren = 0.0;
    private int totalForChildren;
    private IProgressMonitor lastSubMonitor = null;
    private final RootInfo root;
    private final int flags;
    public static final int SUPPRESS_SUBTASK = 1;
    public static final int SUPPRESS_BEGINTASK = 2;
    public static final int SUPPRESS_SETTASKNAME = 4;
    public static final int SUPPRESS_ALL_LABELS = 7;
    public static final int SUPPRESS_NONE = 0;

    private SubMonitor(RootInfo rootInfo, int n, int n2, int n3) {
        this.root = rootInfo;
        this.totalParent = n > 0 ? n : 0;
        this.totalForChildren = n2;
        this.flags = n3;
    }

    public static SubMonitor convert(IProgressMonitor iProgressMonitor) {
        return SubMonitor.convert(iProgressMonitor, "", 0);
    }

    public static SubMonitor convert(IProgressMonitor iProgressMonitor, int n) {
        return SubMonitor.convert(iProgressMonitor, "", n);
    }

    public static SubMonitor convert(IProgressMonitor iProgressMonitor, String string, int n) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (iProgressMonitor instanceof SubMonitor) {
            iProgressMonitor.beginTask(string, n);
            return (SubMonitor)iProgressMonitor;
        }
        iProgressMonitor.beginTask(string, 1000);
        return new SubMonitor(new RootInfo(iProgressMonitor), 1000, n, 0);
    }

    public SubMonitor setWorkRemaining(int n) {
        n = Math.max(0, n);
        if (this.totalForChildren > 0 && this.totalParent > this.usedForParent) {
            double d = (double)this.totalParent * (1.0 - this.usedForChildren / (double)this.totalForChildren);
            this.usedForChildren = (double)n * (1.0 - d / (double)(this.totalParent - this.usedForParent));
        } else {
            this.usedForChildren = 0.0;
        }
        this.totalParent -= this.usedForParent;
        this.usedForParent = 0;
        this.totalForChildren = n;
        return this;
    }

    private int consume(double d) {
        if (this.totalParent == 0 || this.totalForChildren == 0) {
            return 0;
        }
        this.usedForChildren += d;
        if (this.usedForChildren > (double)this.totalForChildren) {
            this.usedForChildren = this.totalForChildren;
        } else if (this.usedForChildren < 0.0) {
            this.usedForChildren = 0.0;
        }
        int n = (int)((double)this.totalParent * this.usedForChildren / (double)this.totalForChildren);
        int n2 = n - this.usedForParent;
        this.usedForParent = n;
        return n2;
    }

    public boolean isCanceled() {
        return this.root.isCanceled();
    }

    public void setTaskName(String string) {
        if ((this.flags & 4) == 0) {
            this.root.setTaskName(string);
        }
    }

    public void beginTask(String string, int n) {
        if ((this.flags & 2) == 0 && string != null) {
            this.root.setTaskName(string);
        }
        this.setWorkRemaining(n);
    }

    public void done() {
        this.cleanupActiveChild();
        int n = this.totalParent - this.usedForParent;
        if (n > 0) {
            this.root.worked(n);
        }
        this.totalParent = 0;
        this.usedForParent = 0;
        this.totalForChildren = 0;
        this.usedForChildren = 0.0;
    }

    public void internalWorked(double d) {
        this.cleanupActiveChild();
        int n = this.consume(d > 0.0 ? d : 0.0);
        if (n != 0) {
            this.root.worked(n);
        }
    }

    public void subTask(String string) {
        if ((this.flags & 1) == 0) {
            this.root.subTask(string);
        }
    }

    public void worked(int n) {
        this.internalWorked(n);
    }

    public void setCanceled(boolean bl) {
        this.root.setCanceled(bl);
    }

    public SubMonitor newChild(int n) {
        return this.newChild(n, 2);
    }

    public SubMonitor newChild(int n, int n2) {
        double d = n > 0 ? (double)n : 0.0;
        d = Math.min(d, (double)this.totalForChildren - this.usedForChildren);
        this.cleanupActiveChild();
        int n3 = 0;
        if ((this.flags & 4) != 0) {
            n3 |= 6;
        }
        if ((this.flags & 1) != 0) {
            n3 |= 1;
        }
        SubMonitor subMonitor = new SubMonitor(this.root, this.consume(d), 0, n3 |= n2);
        this.lastSubMonitor = subMonitor;
        return subMonitor;
    }

    private void cleanupActiveChild() {
        if (this.lastSubMonitor == null) {
            return;
        }
        IProgressMonitor iProgressMonitor = this.lastSubMonitor;
        this.lastSubMonitor = null;
        iProgressMonitor.done();
    }

    public void clearBlocked() {
        this.root.clearBlocked();
    }

    public void setBlocked(IStatus iStatus) {
        this.root.setBlocked(iStatus);
    }

    protected static boolean eq(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    private static final class RootInfo {
        private final IProgressMonitor root;
        private String taskName = null;
        private String subTask = null;

        public RootInfo(IProgressMonitor iProgressMonitor) {
            this.root = iProgressMonitor;
        }

        public boolean isCanceled() {
            return this.root.isCanceled();
        }

        public void setCanceled(boolean bl) {
            this.root.setCanceled(bl);
        }

        public void setTaskName(String string) {
            if (SubMonitor.eq(string, this.taskName)) {
                return;
            }
            this.taskName = string;
            this.root.setTaskName(string);
        }

        public void subTask(String string) {
            if (SubMonitor.eq(this.subTask, string)) {
                return;
            }
            this.subTask = string;
            this.root.subTask(string);
        }

        public void worked(int n) {
            this.root.worked(n);
        }

        public void clearBlocked() {
            if (this.root instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)this.root).clearBlocked();
            }
        }

        public void setBlocked(IStatus iStatus) {
            if (this.root instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)this.root).setBlocked(iStatus);
            }
        }
    }
}

