/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class CachedManifest
extends Dictionary {
    private Dictionary manifest = null;
    private EclipseStorageHook storageHook;

    public CachedManifest(EclipseStorageHook eclipseStorageHook) {
        this.storageHook = eclipseStorageHook;
    }

    public Dictionary getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = this.storageHook.createCachedManifest(true);
            }
            catch (BundleException bundleException) {
                String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CACHEDMANIFEST_UNEXPECTED_EXCEPTION, this.storageHook.getBaseData().getLocation());
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, bundleException, null);
                this.storageHook.getAdaptor().getFrameworkLog().log(frameworkLogEntry);
                return null;
            }
        }
        return this.manifest;
    }

    public int size() {
        return this.getManifest().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration elements() {
        return this.getManifest().elements();
    }

    public Enumeration keys() {
        return this.getManifest().keys();
    }

    public Object get(Object object) {
        String[] stringArray;
        Object object2;
        if (this.manifest != null) {
            return this.manifest.get(object);
        }
        String string = (String)object;
        if ("Bundle-Version".equalsIgnoreCase(string)) {
            Version version = this.storageHook.getBaseData().getVersion();
            return version == null ? null : version.toString();
        }
        if ("Plugin-Class".equalsIgnoreCase(string)) {
            return this.storageHook.getPluginClass();
        }
        if ("Bundle-SymbolicName".equalsIgnoreCase(string)) {
            if ((this.storageHook.getBaseData().getType() & 8) == 0) {
                return this.storageHook.getBaseData().getSymbolicName();
            }
            return String.valueOf(this.storageHook.getBaseData().getSymbolicName()) + ';' + "singleton" + ":=true";
        }
        if ("Eclipse-BuddyPolicy".equalsIgnoreCase(string)) {
            return this.storageHook.getBuddyList();
        }
        if ("Eclipse-RegisterBuddy".equalsIgnoreCase(string)) {
            return this.storageHook.getRegisteredBuddyList();
        }
        if ("Bundle-Activator".equalsIgnoreCase(string)) {
            return this.storageHook.getBaseData().getActivator();
        }
        if ("Bundle-ActivationPolicy".equals(string)) {
            int n;
            if (!this.storageHook.isAutoStartable()) {
                return null;
            }
            object2 = this.storageHook.getLazyStartExcludes();
            stringArray = this.storageHook.getLazyStartIncludes();
            if (object2 == null && stringArray == null) {
                return "lazy";
            }
            StringBuffer stringBuffer = new StringBuffer("lazy");
            if (object2 != null) {
                stringBuffer.append(';').append("exclude").append(":=\"");
                n = 0;
                while (n < ((Object)object2).length) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append((String)object2[n]);
                    ++n;
                }
                stringBuffer.append("\"");
            }
            if (stringArray != null) {
                stringBuffer.append(';').append("include").append(":=\"");
                n = 0;
                while (n < stringArray.length) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(stringArray[n]);
                    ++n;
                }
                stringBuffer.append("\"");
            }
        }
        if ("Eclipse-LazyStart".equals(string) || "Eclipse-AutoStart".equals(string)) {
            if (!this.storageHook.isAutoStartable()) {
                return null;
            }
            if (this.storageHook.getLazyStartExcludes() == null) {
                return ((Object)Boolean.TRUE).toString();
            }
            object2 = new StringBuffer(this.storageHook.isLazyStart() ? ((Object)Boolean.TRUE).toString() : ((Object)Boolean.FALSE).toString());
            ((StringBuffer)object2).append(";").append("exceptions").append("=\"");
            stringArray = this.storageHook.getLazyStartExcludes();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    ((StringBuffer)object2).append(",");
                }
                ((StringBuffer)object2).append(stringArray[n]);
                ++n;
            }
            ((StringBuffer)object2).append("\"");
            return object2.toString();
        }
        if ("Bundle-ManifestVersion".equals(string)) {
            return this.storageHook.getBundleManifestVersion() == 0 ? null : Integer.toString(this.storageHook.getBundleManifestVersion());
        }
        object2 = this.getManifest();
        return object2 == null ? null : ((Dictionary)object2).get(object);
    }

    public Object remove(Object object) {
        return this.getManifest().remove(object);
    }

    public Object put(Object object, Object object2) {
        return this.getManifest().put(object, object2);
    }
}

