/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class StatusLine
extends Composite
implements IProgressMonitor {
    public static final int GAP = 3;
    public static final int DELAY_PROGRESS = 500;
    protected boolean fProgressIsVisible = false;
    protected boolean fCancelButtonIsVisible = false;
    protected boolean fCancelEnabled = false;
    protected String fTaskName;
    protected boolean fIsCanceled;
    protected long fStartTime;
    protected String fMessageText;
    protected Image fMessageImage;
    protected String fErrorText;
    protected Image fErrorImage;
    protected Label fMessageLabel;
    protected Composite fProgressBarComposite;
    protected static ImageDescriptor fgStopImage;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.action.StatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fgStopImage = ImageDescriptor.createFromFile(clazz, "images/stop.gif");
        JFaceResources.getImageRegistry().put("org.eclipse.jface.parts.StatusLine.stopImage", fgStopImage);
    }

    public StatusLine(Composite composite, int n) {
        super(composite, n);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                StatusLine.this.handleDispose();
            }
        });
        this.setLayout(new StatusLineLayout());
        this.fMessageLabel = new Label((Composite)this, 0);
        this.fProgressIsVisible = false;
        this.fCancelEnabled = false;
        this.fProgressBarComposite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fProgressBarComposite.setLayout((Layout)gridLayout);
    }

    public void beginTask(String string, int n) {
        long l;
        this.fStartTime = l = System.currentTimeMillis();
        final boolean bl = n == -1 || n == 0;
        new Runnable(){

            public void run() {
                StatusLine.this.startTask(l, bl);
            }
        };
        this.fTaskName = string == null ? "" : string;
        this.setMessage(this.fTaskName);
    }

    public void done() {
        this.fStartTime = 0L;
        this.setMessage(null);
        this.hideProgress();
    }

    public IProgressMonitor getProgressMonitor() {
        return this;
    }

    protected void handleDispose() {
    }

    protected void hideProgress() {
        if (this.fProgressIsVisible && !this.isDisposed()) {
            this.fProgressIsVisible = false;
            this.fCancelEnabled = false;
            this.fCancelButtonIsVisible = false;
            if (this.fProgressBarComposite != null && !this.fProgressBarComposite.isDisposed()) {
                this.fProgressBarComposite.setVisible(false);
            }
            this.layout();
        }
    }

    public void internalWorked(double d) {
        if (!this.fProgressIsVisible && System.currentTimeMillis() - this.fStartTime > 500L) {
            this.showProgress();
        }
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public boolean isCancelEnabled() {
        return this.fCancelEnabled;
    }

    public void setCanceled(boolean bl) {
        this.fIsCanceled = bl;
    }

    public void setCancelEnabled(boolean bl) {
        this.fCancelEnabled = bl;
        if (this.fProgressIsVisible && !this.fCancelButtonIsVisible && bl) {
            this.showButton();
            this.layout();
        }
    }

    public void setErrorMessage(String string) {
        this.setErrorMessage(null, string);
    }

    public void setErrorMessage(Image image, String string) {
        this.fErrorText = this.trim(string);
        this.fErrorImage = image;
        this.updateMessageLabel();
    }

    public void setFont(Font font) {
        super.setFont(font);
        Control[] controlArray = this.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setFont(font);
            ++n;
        }
    }

    public void setMessage(String string) {
        this.setMessage(null, string);
    }

    public void setMessage(Image image, String string) {
        this.fMessageText = this.trim(string);
        this.fMessageImage = image;
        this.updateMessageLabel();
    }

    public void setTaskName(String string) {
        this.fTaskName = string;
    }

    protected void showButton() {
    }

    protected void showProgress() {
        if (!this.fProgressIsVisible && !this.isDisposed()) {
            this.fProgressIsVisible = true;
            if (this.fCancelEnabled) {
                this.showButton();
            }
            if (this.fProgressBarComposite != null && !this.fProgressBarComposite.isDisposed()) {
                this.fProgressBarComposite.setVisible(true);
            }
            this.layout();
        }
    }

    void startTask(long l, boolean bl) {
        if (!this.fProgressIsVisible && this.fStartTime == l) {
            this.showProgress();
        }
    }

    public void subTask(String string) {
        String string2 = this.fTaskName.length() == 0 ? string : JFaceResources.format("Set_SubTask", new Object[]{this.fTaskName, string});
        this.setMessage(string2);
    }

    String trim(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(13);
        int n2 = string.indexOf(10);
        if (n == -1 && n2 == -1) {
            return string;
        }
        int n3 = n == -1 ? n2 : (n2 == -1 ? n : Math.min(n, n2));
        return string.substring(0, n3);
    }

    protected void updateMessageLabel() {
        if (this.fMessageLabel != null && !this.fMessageLabel.isDisposed()) {
            Display display = this.fMessageLabel.getDisplay();
            if (this.fErrorText != null && this.fErrorText.length() > 0 || this.fErrorImage != null) {
                this.fMessageLabel.setForeground(JFaceColors.getErrorText(display));
                this.fMessageLabel.setText(this.fErrorText);
                this.fMessageLabel.setImage(this.fErrorImage);
            } else {
                this.fMessageLabel.setForeground(display.getSystemColor(21));
                this.fMessageLabel.setText(this.fMessageText == null ? "" : this.fMessageText);
                this.fMessageLabel.setImage(this.fMessageImage);
            }
        }
    }

    public void worked(int n) {
        this.internalWorked(n);
    }

    public class StatusLineLayout
    extends Layout {
        private final StatusLineLayoutData DEFAULT_DATA = new StatusLineLayoutData();

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Control[] controlArray = composite.getChildren();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < controlArray.length) {
                StatusLineLayoutData statusLineLayoutData;
                boolean bl2 = true;
                Control control = controlArray[n6];
                if (control == StatusLine.this.fProgressBarComposite && !StatusLine.this.fProgressIsVisible) {
                    bl2 = false;
                }
                if ((statusLineLayoutData = (StatusLineLayoutData)control.getLayoutData()) == null) {
                    statusLineLayoutData = this.DEFAULT_DATA;
                }
                Point point = control.computeSize(statusLineLayoutData.widthHint, statusLineLayoutData.heightHint, bl);
                if (bl2) {
                    n3 += point.x;
                    ++n5;
                }
                n4 = Math.max(n4, point.y);
                ++n6;
            }
            if (n5 > 0) {
                n3 += (n5 - 1) * 3;
            }
            if (n3 <= 0) {
                n3 = n4 * 4;
            }
            return new Point(n3, n4);
        }

        public void layout(Composite composite, boolean bl) {
            int n;
            if (composite == null) {
                return;
            }
            StatusLine.this.fMessageLabel.moveAbove(null);
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n2 = controlArray.length;
            int[] nArray = new int[n2];
            int n3 = rectangle.height;
            int n4 = -3;
            int n5 = 0;
            while (n5 < n2) {
                Control control = controlArray[n5];
                if (control != StatusLine.this.fProgressBarComposite || StatusLine.this.fProgressIsVisible) {
                    StatusLineLayoutData statusLineLayoutData = (StatusLineLayoutData)control.getLayoutData();
                    if (statusLineLayoutData == null) {
                        statusLineLayoutData = this.DEFAULT_DATA;
                    }
                    nArray[n5] = n = control.computeSize((int)statusLineLayoutData.widthHint, (int)n3, (boolean)bl).x;
                    n4 += n + 3;
                }
                ++n5;
            }
            n5 = rectangle.width - n4;
            nArray[0] = nArray[0] + n5;
            int n6 = rectangle.width / 3;
            if (nArray[0] < n6) {
                n5 = nArray[0] - n6;
                nArray[0] = n6;
            } else {
                n5 = 0;
            }
            int n7 = n2 - 1;
            while (n7 >= 0 && n5 < 0) {
                n = Math.min(nArray[n7], -n5);
                int n8 = n7--;
                nArray[n8] = nArray[n8] - n;
                n5 += n + 3;
            }
            n7 = rectangle.x;
            n = rectangle.y;
            int n9 = 0;
            while (n9 < n2) {
                Control control = controlArray[n9];
                if (control == StatusLine.this.fProgressBarComposite && !StatusLine.this.fProgressIsVisible) {
                    control.setBounds(n7 + rectangle.width, n, nArray[n9], n3);
                } else {
                    control.setBounds(n7, n, nArray[n9], n3);
                    if (nArray[n9] > 0) {
                        n7 += nArray[n9] + 3;
                    }
                }
                ++n9;
            }
        }
    }
}

