/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartSashContainer;

class LayoutPartSash
extends LayoutPart {
    private Composite sash;
    private boolean enabled = false;
    private PartSashContainer rootContainer;
    private int style;
    private LayoutPartSash preLimit;
    private LayoutPartSash postLimit;
    SelectionListener selectionListener;
    private int left = 300;
    private int right = 300;
    private boolean isVisible;

    LayoutPartSash(PartSashContainer rootContainer, int style) {
        super(null);
        this.style = style;
        this.rootContainer = rootContainer;
    }

    public void createControl(Composite parent) {
        if (this.isVisible) {
            this.doCreateControl();
        }
    }

    private void doCreateControl() {
        if (this.sash == null) {
            this.sash = new Composite(this.rootContainer.getParent(), this.style | 0x10000);
            this.sash.setEnabled(this.enabled);
        }
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible) {
            return;
        }
        if (visible) {
            this.doCreateControl();
        } else {
            this.dispose();
        }
        super.setVisible(visible);
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void dispose() {
        if (this.sash != null) {
            this.sash.dispose();
        }
        this.sash = null;
    }

    public Rectangle getBounds() {
        if (this.sash == null) {
            return super.getBounds();
        }
        return this.sash.getBounds();
    }

    public Control getControl() {
        return this.sash;
    }

    public String getID() {
        return null;
    }

    LayoutPartSash getPostLimit() {
        return this.postLimit;
    }

    LayoutPartSash getPreLimit() {
        return this.preLimit;
    }

    int getLeft() {
        return this.left;
    }

    int getRight() {
        return this.right;
    }

    boolean isHorizontal() {
        return (this.style & 0x100) == 256;
    }

    boolean isVertical() {
        return (this.style & 0x200) == 512;
    }

    void setPostLimit(LayoutPartSash newPostLimit) {
        this.postLimit = newPostLimit;
    }

    void setPreLimit(LayoutPartSash newPreLimit) {
        this.preLimit = newPreLimit;
    }

    void setRatio(float newRatio) {
        int total = this.left + this.right;
        int newLeft = (int)((float)total * newRatio);
        this.setSizes(newLeft, total - newLeft);
    }

    void setSizes(int left, int right) {
        if (left < 0 || right < 0) {
            return;
        }
        if (left == this.left && right == this.right) {
            return;
        }
        this.left = left;
        this.right = right;
    }

    public void setEnabled(boolean resizable) {
        this.enabled = resizable;
        if (this.sash != null) {
            this.sash.setEnabled(this.enabled);
        }
    }
}

