/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.misc.Assert;

public class WorkbenchPreferenceDialog
extends PreferenceDialog {
    private static WorkbenchPreferenceDialog instance = null;
    private String rootNodeToDisplayId;

    public static final WorkbenchPreferenceDialog createDialogOn(Shell shell, String preferencePageId) {
        WorkbenchPreferenceDialog dialog;
        if (instance == null) {
            IWorkbench workbench;
            IWorkbenchWindow workbenchWindow;
            Shell parentShell = shell;
            if (parentShell == null && (workbenchWindow = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null) {
                parentShell = workbenchWindow.getShell();
            }
            WorkbenchPreferenceManager preferenceManager = (WorkbenchPreferenceManager)PlatformUI.getWorkbench().getPreferenceManager();
            dialog = new WorkbenchPreferenceDialog(parentShell, preferenceManager);
            dialog.setRootNodeToDisplay(preferencePageId);
        } else {
            dialog = instance;
        }
        return dialog;
    }

    public WorkbenchPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
        Assert.isTrue(instance == null, "There cannot be two preference dialogs at once in the workbench.");
        instance = this;
    }

    protected Control createContents(PreferenceDialog parent) {
        Composite parentDialog = null;
        Iterator iterator = this.preferenceManager.getRootElements().iterator();
        while (iterator.hasNext()) {
            PreferenceNode next = (PreferenceNode)iterator.next();
            if (this.rootNodeToDisplayId != null && !next.getId().equals(this.rootNodeToDisplayId)) continue;
            parentDialog = this.createSubPages((IPreferenceNode)next);
        }
        return parentDialog;
    }

    public void close() {
        instance = null;
        super.close();
    }

    public void setRootNodeToDisplay(String nodeId) {
        this.rootNodeToDisplayId = nodeId;
    }
}

