/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBaseEntry;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDayViewScreen;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarEditDayViewListener;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarEditEntryDialog;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CalendarEditDayView
implements SelectionListener {
    CalendarShowCase calendarShowCase;
    private CalendarDayViewScreen calendarDayViewScreen;
    Shell background;
    Shell dayShell;
    private Vector entriesoftheday;
    private CalendarDataBase calendardatabase;
    private List editDayList;
    Date displayedDate;
    CalendarEditDayViewListener editdaylistener;
    private Command commandEditEntry;
    private Command commandNewEntry;
    private Command commandGoToDate;
    private Command commandExit;
    private Command commandBack;
    private Command commandEDVChangeView;

    public CalendarEditDayView(CalendarShowCase calendarShowCase, CalendarDataBase calendardatabase) {
        this.calendarShowCase = calendarShowCase;
        this.background = calendarShowCase.getComposite().getShell();
        this.calendardatabase = calendardatabase;
        this.calendarDayViewScreen = calendarShowCase.getDayViewScreen();
        this.entriesoftheday = new Vector();
        this.displayedDate = new Date();
        Rectangle bgdBnds = this.background.getBounds();
        Rectangle bgdArea = this.background.getClientArea();
        boolean landscape = bgdArea.width > 240 && bgdArea.width > bgdArea.height;
        int style = 262176;
        if (landscape) {
            style |= 0x800;
        }
        this.dayShell = new Shell(this.background, style);
        this.dayShell.setText(Messages.getString("CalendarEditDayView.0"));
        if (landscape) {
            int x = bgdBnds.x + bgdBnds.width / 2 + 5;
            int y = bgdBnds.y + 5;
            int w = bgdBnds.width / 2 - 15;
            int h = bgdBnds.height - 5;
            this.dayShell.setBounds(x, y, w, h);
        } else {
            this.dayShell.setBounds(bgdBnds.x, bgdBnds.y, bgdBnds.width, bgdBnds.height);
        }
        this.commandGoToDate = new Command((Control)this.dayShell, 1, 1);
        this.commandGoToDate.setText(Messages.getString("CalendarEditDayView.1"));
        this.commandGoToDate.addSelectionListener((SelectionListener)this);
        if (landscape) {
            this.commandExit = new Command((Control)this.dayShell, 7, 0);
            this.commandExit.setText(Messages.getString("CalendarEditDayView.2"));
            this.commandExit.setLongLabel(Messages.getString("CalendarEditDayView.3"));
            this.commandExit.addSelectionListener((SelectionListener)this);
        } else {
            this.commandBack = new Command((Control)this.dayShell, 7, 0);
            this.commandBack.setText(Messages.getString("CalendarEditDayView.4"));
            this.commandBack.addSelectionListener((SelectionListener)this);
        }
        this.commandEDVChangeView = new Command((Control)this.dayShell, 1, 1);
        this.commandEDVChangeView.setText(Messages.getString("CalendarEditDayView.5"));
        this.commandEDVChangeView.addSelectionListener((SelectionListener)this);
        this.editDayList = new List((Composite)this.dayShell, 2048);
        this.editDayList.setLocation(0, 0);
        this.editDayList.setSize(this.dayShell.getClientArea().width, this.dayShell.getClientArea().height);
        this.editDayList.addSelectionListener((SelectionListener)this);
        this.populateDayList();
        this.editDayList.addTraverseListener((TraverseListener)calendarShowCase);
        this.dayShell.open();
    }

    public void dispose() {
        if (this.commandEditEntry != null) {
            this.commandEditEntry.dispose();
        }
        if (this.commandNewEntry != null) {
            this.commandNewEntry.dispose();
        }
        if (this.commandGoToDate != null) {
            this.commandGoToDate.dispose();
        }
        if (this.commandExit != null) {
            this.commandExit.dispose();
        }
        if (this.commandBack != null) {
            this.commandBack.dispose();
        }
        if (this.commandEDVChangeView != null) {
            this.commandEDVChangeView.dispose();
        }
        this.dayShell.dispose();
    }

    public void redraw() {
        this.dayShell.redraw();
    }

    public void setEditDayListener(CalendarEditDayViewListener listener) {
        this.editdaylistener = listener;
    }

    public Date getDate() {
        return this.displayedDate;
    }

    public void setDate(Date newdate) {
        this.displayedDate = (Date)newdate.clone();
        this.populateDayList();
    }

    private void setTitle(Date date) {
        String newTitle = new String();
        Locale locale = Locale.getDefault();
        DateFormat dateFormat = DateFormat.getDateInstance(0, locale);
        newTitle = String.valueOf(newTitle) + dateFormat.format(date);
        this.dayShell.setText(newTitle);
    }

    public void activate() {
        this.dayShell.forceActive();
        this.editDayList.setFocus();
        this.setEditDayListCommands();
    }

    private void populateDayList() {
        Vector newentries = this.calendardatabase.getEntriesOfTheDay(this.displayedDate);
        if (newentries.size() != 0 || this.entriesoftheday.size() != 0) {
            this.editDayList.removeAll();
            this.entriesoftheday.removeAllElements();
            this.entriesoftheday = this.calendardatabase.getEntriesOfTheDay(this.displayedDate);
            int i = 0;
            while (i < this.entriesoftheday.size()) {
                this.editDayList.add(((CalendarDataBaseEntry)this.entriesoftheday.get(i)).toString());
                ++i;
            }
            this.editDayList.add(" ");
            this.editDayList.redraw();
            this.editDayList.select(0);
        }
        this.setTitle(this.displayedDate);
    }

    private void setEditDayListCommands() {
        if (this.editDayList.getSelectionIndex() != this.editDayList.getItemCount() - 1) {
            if (this.commandEditEntry == null) {
                if (this.commandNewEntry != null) {
                    this.commandNewEntry.removeSelectionListener((SelectionListener)this);
                    this.commandNewEntry.dispose();
                    this.commandNewEntry = null;
                }
                this.commandEditEntry = new Command((Control)this.editDayList, 1, 5);
                this.commandEditEntry.setText(Messages.getString("CalendarEditDayView.7"));
                this.commandEditEntry.addSelectionListener((SelectionListener)this);
                this.commandEditEntry.setDefaultCommand();
            }
        } else if (this.commandNewEntry == null) {
            if (this.commandEditEntry != null) {
                this.commandEditEntry.removeSelectionListener((SelectionListener)this);
                this.commandEditEntry.dispose();
                this.commandEditEntry = null;
            }
            this.commandNewEntry = new Command((Control)this.editDayList, 1, 5);
            this.commandNewEntry.setText(Messages.getString("CalendarEditDayView.8"));
            this.commandNewEntry.setLongLabel(Messages.getString("CalendarEditDayView.9"));
            this.commandNewEntry.addSelectionListener((SelectionListener)this);
            this.commandNewEntry.setDefaultCommand();
        }
    }

    private void createNewEntry() {
        CalendarDataBaseEntry newentry = new CalendarDataBaseEntry((Date)this.displayedDate.clone(), this.displayedDate, Messages.getString("CalendarEditDayView.10"), Messages.getString("CalendarEditDayView.11"), null);
        CalendarEditEntryDialog dialogEditEntry = new CalendarEditEntryDialog(this.background.getShell());
        boolean result = dialogEditEntry.open(newentry, true);
        if (result) {
            this.calendardatabase.addEntry(newentry);
            this.setDate(this.displayedDate);
            this.setEditDayListCommands();
            this.editdaylistener.EntriesUpdated();
        }
    }

    private void editEntry() {
        CalendarDataBaseEntry editentry = (CalendarDataBaseEntry)this.entriesoftheday.get(this.editDayList.getSelectionIndex());
        CalendarEditEntryDialog dialogEditEntry = new CalendarEditEntryDialog(this.background.getShell());
        boolean result = dialogEditEntry.open(editentry, false);
        if (!result) {
            this.calendardatabase.removeEntry(editentry);
            this.setDate(this.displayedDate);
            this.setEditDayListCommands();
            this.editdaylistener.EntriesUpdated();
        } else {
            this.setDate(this.displayedDate);
            this.setEditDayListCommands();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.commandNewEntry) {
            this.createNewEntry();
            this.editDayList.setFocus();
        } else if (e.widget == this.commandEditEntry) {
            this.editEntry();
            this.editDayList.setFocus();
        } else if (e.widget == this.editDayList) {
            this.setEditDayListCommands();
        } else if (e.widget == this.commandBack) {
            this.calendarShowCase.activateMonthView();
        } else if (e.widget == this.commandExit) {
            this.calendarShowCase.quit();
        } else if (e.widget == this.commandGoToDate) {
            this.calendarShowCase.goToDate(this.calendarShowCase.getComposite().getShell());
            this.setEditDayListCommands();
        } else if (e.widget == this.commandEDVChangeView) {
            this.calendarDayViewScreen.activate(this.dayShell, this.displayedDate);
            if (this.calendarDayViewScreen.quitWanted()) {
                this.calendarShowCase.quit();
            } else {
                this.setDate(this.calendarDayViewScreen.getDisplayedDate());
                this.setEditDayListCommands();
                this.editdaylistener.notifyDateChanged(this.displayedDate);
                this.editdaylistener.EntriesUpdated();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.editDayList) {
            if (this.commandNewEntry != null) {
                this.createNewEntry();
                this.editDayList.setFocus();
            } else if (this.commandEditEntry != null) {
                this.editEntry();
                this.editDayList.setFocus();
            }
        }
    }

    public boolean isSwitcher(Widget w) {
        return w == this.editDayList;
    }
}

