/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarMonthWidgetListener;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CalendarMonthWidget
extends Canvas
implements PaintListener,
KeyListener,
FocusListener,
DisposeListener,
MouseListener {
    Date selecteddate;
    Composite parent;
    String[] firstRow = new String[]{Messages.getString("CalendarMonthWidget.week"), Messages.getString("CalendarMonthWidget.sunday"), Messages.getString("CalendarMonthWidget.monday"), Messages.getString("CalendarMonthWidget.tuesday"), Messages.getString("CalendarMonthWidget.wednesday"), Messages.getString("CalendarMonthWidget.thursday"), Messages.getString("CalendarMonthWidget.friday"), Messages.getString("CalendarMonthWidget.saturday")};
    Image backbufferImage;
    Image pictureOfTheMonth;
    Image pictureWeekSelected;
    Image pictureWeekSelected_nonFocusing;
    Image pictureDayOfWeekSelected;
    Image pictureDayOfWeekSelected_nonFocusing;
    Image pictureDayOfMonthSelected;
    Image pictureDayOfMonthSelected_nonFocusing;
    Color foregroundColor;
    GC backbufferGC;
    GC pictureOfTheMonthGC;
    Rectangle area;
    int cellwidth;
    int cellheight;
    CalendarMonthWidgetListener listener;
    static int NONE = -1;
    static int PICTUREWEEKSELECTED = 0;
    static int PICTUREWEEKSELECTED_NONFOCUSING = 1;
    static int PICTUREDAYOFWEEKSELECTED = 2;
    static int PICTUREDAYOFWEEKSELECTED_NONFOCUSING = 3;
    static int PICTUREDAYOFMONTHSELECTED = 4;
    static int PICTUREDAYOFMONTHSELECTED_NONFOCUSING = 5;
    CalendarDataBase calendardatabase;

    CalendarMonthWidget(Composite parent, CalendarDataBase calendardatabase) {
        super(parent, 262144);
        this.calendardatabase = calendardatabase;
        this.selecteddate = new Date();
        this.foregroundColor = new Color((Device)this.getDisplay(), 80, 180, 80);
        this.parent = parent;
        this.addPaintListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.computeArea();
        this.buildDoubleBufferingGC();
        this.redrawAllMonth();
        this.setSelectedDate(this.selecteddate);
        this.addFocusListener(this);
        parent.addDisposeListener((DisposeListener)this);
    }

    public void addCalendarMonthWidgetListener(CalendarMonthWidgetListener l) {
        this.listener = l;
    }

    public void paintControl(PaintEvent e) {
        e.gc.drawImage(this.backbufferImage, 0, 0);
    }

    public Date getSelecteddate() {
        return this.selecteddate;
    }

    private void drawCell(String text, int posx, int posy, GC gc, Rectangle area, int style, boolean meetingthisday) {
        Point te = gc.textExtent(text);
        Point delta = new Point((this.cellwidth - te.x) / 2, (this.cellheight - te.y) / 2);
        if (style == PICTUREWEEKSELECTED) {
            if (this.isFocusControl()) {
                gc.drawImage(this.pictureWeekSelected, area.x + posx * this.cellwidth, area.y + posy * this.cellheight);
            } else {
                gc.drawImage(this.pictureWeekSelected_nonFocusing, area.x + posx * this.cellwidth, area.y + posy * this.cellheight);
            }
        } else if (style == PICTUREDAYOFWEEKSELECTED) {
            if (this.isFocusControl()) {
                gc.drawImage(this.pictureDayOfWeekSelected, area.x + posx * this.cellwidth, area.y + posy * this.cellheight);
            } else {
                gc.drawImage(this.pictureDayOfWeekSelected_nonFocusing, area.x + posx * this.cellwidth, area.y + posy * this.cellheight);
            }
        } else if (style == PICTUREDAYOFMONTHSELECTED) {
            if (this.isFocusControl()) {
                gc.drawImage(this.pictureDayOfMonthSelected, area.x + posx * this.cellwidth, area.y + posy * this.cellheight);
            } else {
                gc.drawImage(this.pictureDayOfMonthSelected_nonFocusing, area.x + posx * this.cellwidth, area.y + posy * this.cellheight);
            }
        }
        if (meetingthisday) {
            gc.setForeground(this.foregroundColor);
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(27));
        }
        gc.drawText(text, area.x + posx * this.cellwidth + delta.x, area.y + posy * this.cellheight + delta.y, 1);
    }

    private void drawCellBackground(GC gc, int style) {
        if (style == PICTUREWEEKSELECTED || style == PICTUREDAYOFWEEKSELECTED || style == PICTUREDAYOFMONTHSELECTED) {
            gc.setBackground(this.getDisplay().getSystemColor(26));
        } else if (style == PICTUREWEEKSELECTED_NONFOCUSING || style == PICTUREDAYOFWEEKSELECTED_NONFOCUSING || style == PICTUREDAYOFMONTHSELECTED_NONFOCUSING) {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        Rectangle cellArea = gc.getClipping();
        gc.fillRectangle(cellArea);
        Point topleft = new Point(0, 0);
        Point bottomright = new Point(cellArea.width - 1, cellArea.height - 1);
        gc.setLineStyle(1);
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawLine(bottomright.x, topleft.y, bottomright.x, bottomright.y);
        gc.drawLine(topleft.x, bottomright.y, bottomright.x, bottomright.y);
        gc.setForeground(this.getDisplay().getSystemColor(19));
        gc.drawLine(topleft.x, topleft.y, topleft.x, topleft.y + this.cellheight - 2);
        gc.drawLine(topleft.x, topleft.y, topleft.x + this.cellwidth - 2, topleft.y);
        if (style == PICTUREDAYOFMONTHSELECTED || style == PICTUREDAYOFMONTHSELECTED_NONFOCUSING) {
            gc.setLineStyle(1);
            gc.setForeground(this.getDisplay().getSystemColor(23));
            gc.drawRectangle(topleft.x, topleft.y, bottomright.x - 1, bottomright.y - 1);
        }
    }

    public void setSelectedDate(Date date) {
        GregorianCalendar g = new GregorianCalendar();
        g.setFirstDayOfWeek(1);
        g.setTime(date);
        int selectedMonth = g.get(2);
        int selectedYear = g.get(1);
        g.setTime(this.selecteddate);
        int currentMonth = g.get(2);
        int currentYear = g.get(1);
        this.selecteddate = date;
        if (currentYear != selectedYear || currentMonth != selectedMonth) {
            this.redrawAllMonth();
        }
        this.backbufferGC.drawImage(this.pictureOfTheMonth, 0, 0);
        this.drawDaySelection(this.selecteddate);
        if (this.listener != null) {
            this.listener.newDateSelected(date);
        }
        this.redraw();
    }

    public void keyPressed(KeyEvent e) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(1);
        c.setTime(this.selecteddate);
        if (e.keyCode == 0x1000004) {
            c.add(6, 1);
            Date date = c.getTime();
            this.setSelectedDate(date);
        } else if (e.keyCode == 0x1000003) {
            c.add(6, -1);
            Date date = c.getTime();
            this.setSelectedDate(date);
        } else if (e.keyCode == 0x1000002) {
            c.add(4, 1);
            Date date = c.getTime();
            this.setSelectedDate(date);
        } else if (e.keyCode == 0x1000001) {
            c.add(4, -1);
            Date date = c.getTime();
            this.setSelectedDate(date);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        int cellX = e.x / this.cellwidth;
        int cellY = e.y / this.cellheight;
        GregorianCalendar g = new GregorianCalendar();
        g.setFirstDayOfWeek(1);
        g.setTime(this.selecteddate);
        int i = 1;
        while (i <= g.getActualMaximum(5)) {
            g.setTime(this.selecteddate);
            g.set(5, i);
            if (cellX == g.get(7) && cellY == g.get(4)) {
                this.setSelectedDate(g.getTime());
                break;
            }
            ++i;
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    private void buildDoubleBufferingGC() {
        if (this.backbufferImage != null) {
            this.backbufferImage.dispose();
        }
        if (this.backbufferGC != null) {
            this.backbufferGC.dispose();
        }
        this.backbufferImage = new Image((Device)this.parent.getDisplay(), this.parent.getClientArea());
        this.backbufferGC = new GC((Drawable)this.backbufferImage);
        this.pictureOfTheMonth = new Image((Device)this.parent.getDisplay(), this.parent.getClientArea());
        this.pictureOfTheMonthGC = new GC((Drawable)this.pictureOfTheMonth);
        this.pictureWeekSelected = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        GC gc = new GC((Drawable)this.pictureWeekSelected);
        this.drawCellBackground(gc, PICTUREWEEKSELECTED);
        gc.dispose();
        this.pictureWeekSelected_nonFocusing = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gc = new GC((Drawable)this.pictureWeekSelected_nonFocusing);
        this.drawCellBackground(gc, PICTUREWEEKSELECTED_NONFOCUSING);
        gc.dispose();
        this.pictureDayOfWeekSelected = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gc = new GC((Drawable)this.pictureDayOfWeekSelected);
        this.drawCellBackground(gc, PICTUREDAYOFWEEKSELECTED);
        gc.dispose();
        this.pictureDayOfWeekSelected_nonFocusing = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gc = new GC((Drawable)this.pictureDayOfWeekSelected_nonFocusing);
        this.drawCellBackground(gc, PICTUREDAYOFWEEKSELECTED_NONFOCUSING);
        gc.dispose();
        this.pictureDayOfMonthSelected = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gc = new GC((Drawable)this.pictureDayOfMonthSelected);
        this.drawCellBackground(gc, PICTUREDAYOFMONTHSELECTED);
        gc.dispose();
        this.pictureDayOfMonthSelected_nonFocusing = new Image((Device)this.parent.getDisplay(), this.cellwidth, this.cellheight);
        gc = new GC((Drawable)this.pictureDayOfMonthSelected_nonFocusing);
        this.drawCellBackground(gc, PICTUREDAYOFMONTHSELECTED_NONFOCUSING);
        gc.dispose();
    }

    private void drawDaySelection(Date date) {
        GregorianCalendar selectedDate = new GregorianCalendar();
        selectedDate.setFirstDayOfWeek(1);
        selectedDate.setTime(date);
        GregorianCalendar g = new GregorianCalendar();
        g.setFirstDayOfWeek(1);
        g.setTime(date);
        g.setTime(date);
        Integer integer = new Integer(g.get(3));
        int weekofmonth = g.get(4);
        this.drawCell(integer.toString(), 0, weekofmonth, this.backbufferGC, this.area, PICTUREWEEKSELECTED, false);
        int dayofweek = g.get(7);
        this.drawCell(this.firstRow[dayofweek], dayofweek, 0, this.backbufferGC, this.area, PICTUREDAYOFWEEKSELECTED, false);
        this.drawCell(new Integer(g.get(5)).toString(), dayofweek, weekofmonth, this.backbufferGC, this.area, PICTUREDAYOFMONTHSELECTED, this.calendardatabase.meetingThisDay(this.selecteddate));
    }

    public void redrawAllMonth() {
        this.pictureOfTheMonthGC.setBackground(this.getDisplay().getSystemColor(22));
        this.pictureOfTheMonthGC.setForeground(this.getDisplay().getSystemColor(22));
        this.pictureOfTheMonthGC.fillRectangle(this.area);
        if (this.parent.isFocusControl()) {
            this.pictureOfTheMonthGC.setLineWidth(2);
        } else {
            this.pictureOfTheMonthGC.setLineWidth(1);
        }
        this.pictureOfTheMonthGC.setForeground(this.getDisplay().getSystemColor(21));
        this.pictureOfTheMonthGC.setLineWidth(1);
        int i = 1;
        while (i < 7) {
            this.pictureOfTheMonthGC.drawLine(this.area.x + this.cellwidth, this.area.y + i * this.cellheight, this.area.x + this.area.width, this.area.y + i * this.cellheight);
            ++i;
        }
        this.pictureOfTheMonthGC.drawLine(this.area.x + this.cellwidth, this.area.y + this.cellheight, this.area.x + this.cellwidth, this.area.y + this.area.height);
        i = 0;
        while (i < 8) {
            this.drawCell(this.firstRow[i], i, 0, this.pictureOfTheMonthGC, this.area, NONE, false);
            ++i;
        }
        GregorianCalendar selectedDate = new GregorianCalendar();
        selectedDate.setFirstDayOfWeek(1);
        selectedDate.setTime(this.selecteddate);
        GregorianCalendar g = new GregorianCalendar();
        g.setFirstDayOfWeek(1);
        g.setTime(this.selecteddate);
        int i2 = 1;
        while (i2 <= g.getActualMaximum(4)) {
            g.setTime(this.selecteddate);
            g.set(4, i2);
            Integer integer = new Integer(g.get(3));
            this.drawCell(integer.toString(), 0, i2, this.pictureOfTheMonthGC, this.area, NONE, false);
            ++i2;
        }
        g.setTime(this.selecteddate);
        i2 = 1;
        while (i2 <= g.getActualMaximum(5)) {
            g.setTime(this.selecteddate);
            g.set(5, i2);
            int celltodrawx = g.get(7);
            int celltodrawy = g.get(4);
            Integer integer = new Integer(i2);
            this.drawCell(integer.toString(), celltodrawx, celltodrawy, this.pictureOfTheMonthGC, this.area, NONE, this.calendardatabase.meetingThisDay(g.getTime()));
            ++i2;
        }
        this.drawDaySelection(this.selecteddate);
    }

    private void computeArea() {
        this.area = this.parent.getClientArea();
        this.area.width -= this.area.width % 8;
        this.area.height -= this.area.height % 7;
        this.cellwidth = this.area.width / 8;
        this.cellheight = this.area.height / 7;
        this.area.width = this.cellwidth * 8;
        this.area.height = this.cellheight * 7;
    }

    public void focusGained(FocusEvent e) {
        this.drawDaySelection(this.selecteddate);
    }

    public void focusLost(FocusEvent e) {
        this.drawDaySelection(this.selecteddate);
    }

    void releaseRessource() {
    }

    public void widgetDisposed(DisposeEvent arg0) {
        if (this.backbufferImage != null) {
            this.backbufferImage.dispose();
        }
        if (this.pictureOfTheMonth != null) {
            this.pictureOfTheMonth.dispose();
        }
        if (this.pictureWeekSelected != null) {
            this.pictureWeekSelected.dispose();
        }
        if (this.pictureWeekSelected_nonFocusing != null) {
            this.pictureWeekSelected_nonFocusing.dispose();
        }
        if (this.pictureDayOfWeekSelected != null) {
            this.pictureDayOfWeekSelected.dispose();
        }
        if (this.pictureDayOfWeekSelected_nonFocusing != null) {
            this.pictureDayOfWeekSelected_nonFocusing.dispose();
        }
        if (this.pictureDayOfMonthSelected != null) {
            this.pictureDayOfMonthSelected.dispose();
        }
        if (this.pictureDayOfMonthSelected_nonFocusing != null) {
            this.pictureDayOfMonthSelected_nonFocusing.dispose();
        }
        if (this.backbufferGC != null) {
            this.backbufferGC.dispose();
        }
        if (this.pictureOfTheMonthGC != null) {
            this.pictureOfTheMonthGC.dispose();
        }
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
    }
}

