/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ProxyImageDescriptor;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;
import org.eclipse.ui.internal.util.BundleUtility;

public class WorkbenchImages {
    private static Map descriptors;
    private static ImageRegistry imageRegistry;
    private static ReferenceCounter imageCache;
    public static final String ICONS_PATH = "$nl$/icons/full/";
    private static final String PATH_EVIEW = "$nl$/icons/full/eview16/";

    public static ReferenceCounter getImageCache() {
        if (imageCache == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return imageCache;
    }

    private static final void declareImage(String string, String string2, boolean bl) {
        ProxyImageDescriptor proxyImageDescriptor = new ProxyImageDescriptor(string, string2, bl);
        WorkbenchImages.declareImage(string, proxyImageDescriptor, bl);
    }

    private static final void declareImages() {
        WorkbenchImages.declareImage("IMG_ETOOL_NEW_PAGE", "$nl$/icons/full/eview16/new_persp.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_DEF_PERSPECTIVE", "$nl$/icons/full/eview16/default_persp.gif", false);
        WorkbenchImages.declareImage("IMG_VIEW_DEFAULTVIEW_MISC", "$nl$/icons/full/eview16/defaultview_misc.gif", false);
        WorkbenchImages.declareImage("IMG_DEF_VIEW", "$nl$/icons/full/eview16/defaultview_misc.gif", true);
    }

    public static void declareImage(String string, ImageDescriptor imageDescriptor, boolean bl) {
        if (Policy.DEBUG_DECLARED_IMAGES) {
            Image image = imageDescriptor.createImage(false);
            if (image == null) {
                WorkbenchPlugin.log("Image not found in WorkbenchImages.declaredImage().  symbolicName=" + string + " descriptor=" + imageDescriptor, new Exception("stack dump"));
            } else {
                image.dispose();
            }
        }
        WorkbenchImages.getDescriptors().put(string, imageDescriptor);
        if (bl) {
            WorkbenchImages.getImageRegistry().put(string, imageDescriptor);
        }
    }

    private static Map getDescriptors() {
        if (descriptors == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return descriptors;
    }

    public static Image getImage(String string) {
        return WorkbenchImages.getImageRegistry().get(string);
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return (ImageDescriptor)WorkbenchImages.getDescriptors().get(string);
    }

    public static ImageDescriptor getImageDescriptorFromProgram(String string, int n) {
        Assert.isNotNull(string);
        String string2 = String.valueOf(string) + "*" + n;
        ImageDescriptor imageDescriptor = WorkbenchImages.getImageDescriptor(string2);
        if (imageDescriptor == null) {
            imageDescriptor = new ProgramImageDescriptor(string, n);
            WorkbenchImages.getDescriptors().put(string2, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    private static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        descriptors = new HashMap();
        imageCache = new ReferenceCounter();
        WorkbenchImages.declareImages();
    }

    public static void dispose() {
        if (imageRegistry != null) {
            imageRegistry.dispose();
            imageRegistry = null;
            descriptors = null;
            imageCache = null;
        }
    }

    public static ImageDescriptor getWorkbenchImageDescriptor(String string) {
        return ImageDescriptor.createFromURL((URL)BundleUtility.find("org.eclipse.ui", ICONS_PATH + string));
    }
}

