/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.standalone.CmdLineArgs;
import org.eclipse.update.standalone.ScriptedCommand;

public class StandaloneUpdateApplication
implements IPlatformRunnable {
    public static final Integer EXIT_ERROR = new Integer(1);
    private static boolean loggedException = false;

    public Object run(Object object) throws Exception {
        System.out.println("---- Here is StandaloneUpdateApplication run()...");
        if (object == null) {
            return EXIT_ERROR;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            CmdLineArgs cmdLineArgs = new CmdLineArgs(stringArray);
            ScriptedCommand scriptedCommand = cmdLineArgs.getCommand();
            if (scriptedCommand == null) {
                System.out.println(NLS.bind((String)Messages.Standalone_cmdFailed, (Object[])new String[]{Platform.getLogFileLocation().toOSString()}));
                return EXIT_ERROR;
            }
            loggedException = false;
            boolean bl = scriptedCommand.run();
            if (bl) {
                if (loggedException) {
                    System.out.println(NLS.bind((String)Messages.Standalone_cmdCompleteWithErrors, (Object[])new String[]{Platform.getLogFileLocation().toOSString()}));
                } else {
                    System.out.println(Messages.Standalone_cmdOK);
                }
                return IPlatformRunnable.EXIT_OK;
            }
            if (loggedException) {
                System.out.println(NLS.bind((String)Messages.Standalone_cmdFailed, (Object[])new String[]{Platform.getLogFileLocation().toOSString()}));
            } else {
                System.out.println(Messages.Standalone_cmdFailedNoLog);
            }
            return EXIT_ERROR;
        }
        return EXIT_ERROR;
    }

    public static void exceptionLogged() {
        loggedException = true;
    }
}

