/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.HashtableOfInt;
import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.internal.registry.KeyedHashSet;
import org.eclipse.core.internal.registry.RegistryIndexElement;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;

public class TableWriter {
    private static final byte fileError = 0;
    File mainDataFile;
    File extraDataFile;
    File tableFile;
    File contributionsFile;
    File contributorsFile;
    File namespacesFile;
    File orphansFile;
    DataOutputStream mainOutput;
    DataOutputStream extraOutput;
    FileOutputStream mainFileOutput = null;
    FileOutputStream extraFileOutput = null;
    private HashtableOfInt offsets;
    private ExtensionRegistry registry;
    private RegistryObjectManager objectManager;

    void setMainDataFile(File file) {
        this.mainDataFile = file;
    }

    void setExtraDataFile(File file) {
        this.extraDataFile = file;
    }

    void setTableFile(File file) {
        this.tableFile = file;
    }

    void setContributionsFile(File file) {
        this.contributionsFile = file;
    }

    void setContributorsFile(File file) {
        this.contributorsFile = file;
    }

    void setNamespacesFile(File file) {
        this.namespacesFile = file;
    }

    void setOrphansFile(File file) {
        this.orphansFile = file;
    }

    public TableWriter(ExtensionRegistry extensionRegistry) {
        this.registry = extensionRegistry;
    }

    private int getExtraDataPosition() {
        return this.extraOutput.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveCache(RegistryObjectManager registryObjectManager, long l) {
        this.objectManager = registryObjectManager;
        try {
            block7: {
                if (!this.openFiles()) {
                } else {
                    try {
                        this.saveExtensionRegistry(l);
                        break block7;
                    }
                    catch (IOException iOException) {
                        this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheWriteProblems, (Throwable)iOException));
                    }
                }
                Object var5_3 = null;
                this.closeFiles();
                return false;
            }
            Object var5_5 = null;
            this.closeFiles();
            return true;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.closeFiles();
            throw throwable;
        }
    }

    private boolean openFiles() {
        try {
            this.mainFileOutput = new FileOutputStream(this.mainDataFile);
            this.mainOutput = new DataOutputStream(new BufferedOutputStream(this.mainFileOutput));
            this.extraFileOutput = new FileOutputStream(this.extraDataFile);
            this.extraOutput = new DataOutputStream(new BufferedOutputStream(this.extraFileOutput));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.mainFileOutput != null) {
                try {
                    this.mainFileOutput.close();
                }
                catch (IOException iOException) {}
            }
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_unableToCreateCache, (Throwable)fileNotFoundException));
            return false;
        }
        return true;
    }

    private void closeFiles() {
        try {
            if (this.mainOutput != null) {
                this.mainOutput.flush();
                if (this.mainFileOutput.getFD().valid()) {
                    this.mainFileOutput.getFD().sync();
                }
                this.mainOutput.close();
            }
        }
        catch (IOException iOException) {
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheWriteProblems, (Throwable)iOException));
            iOException.printStackTrace();
        }
        try {
            if (this.extraOutput != null) {
                this.extraOutput.flush();
                if (this.extraFileOutput.getFD().valid()) {
                    this.extraFileOutput.getFD().sync();
                }
                this.extraOutput.close();
            }
        }
        catch (IOException iOException) {
            this.log(new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.meta_registryCacheWriteProblems, (Throwable)iOException));
            iOException.printStackTrace();
        }
    }

    private void saveExtensionRegistry(long l) throws IOException {
        ExtensionPointHandle[] extensionPointHandleArray = this.objectManager.getExtensionPointsHandles();
        this.offsets = new HashtableOfInt(this.objectManager.getNextId());
        int n = 0;
        while (n < extensionPointHandleArray.length) {
            this.saveExtensionPoint(extensionPointHandleArray[n]);
            ++n;
        }
        this.saveOrphans();
        this.saveContributions(this.objectManager.getContributions());
        this.saveContributors(this.objectManager.getContributors());
        this.saveNamespaces(this.objectManager.getNamespacesIndex());
        this.closeFiles();
        this.saveTables(l);
    }

    private void saveContributions(KeyedHashSet[] keyedHashSetArray) throws IOException {
        Contribution contribution;
        FileOutputStream fileOutputStream = new FileOutputStream(this.contributionsFile);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        KeyedElement[] keyedElementArray = keyedHashSetArray[0].elements();
        KeyedElement[] keyedElementArray2 = keyedHashSetArray[1].elements();
        int n = 0;
        int n2 = 0;
        while (n2 < keyedElementArray.length) {
            if (((Contribution)keyedElementArray[n2]).shouldPersist()) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < keyedElementArray2.length) {
            if (((Contribution)keyedElementArray2[n2]).shouldPersist()) {
                ++n;
            }
            ++n2;
        }
        dataOutputStream.writeInt(n);
        n2 = 0;
        while (n2 < keyedElementArray.length) {
            contribution = (Contribution)keyedElementArray[n2];
            if (contribution.shouldPersist()) {
                this.writeStringOrNull(contribution.getContributorId(), dataOutputStream);
                this.saveArray(this.filterContributionChildren(contribution), dataOutputStream);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < keyedElementArray2.length) {
            contribution = (Contribution)keyedElementArray2[n2];
            if (contribution.shouldPersist()) {
                this.writeStringOrNull(contribution.getContributorId(), dataOutputStream);
                this.saveArray(this.filterContributionChildren(contribution), dataOutputStream);
            }
            ++n2;
        }
        dataOutputStream.flush();
        fileOutputStream.getFD().sync();
        dataOutputStream.close();
    }

    private int[] filterContributionChildren(Contribution contribution) {
        int[] nArray = this.filter(contribution.getExtensionPoints());
        int[] nArray2 = this.filter(contribution.getExtensions());
        int[] nArray3 = new int[2 + nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 2, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, 2 + nArray.length, nArray2.length);
        nArray3[0] = nArray.length;
        nArray3[1] = nArray2.length;
        return nArray3;
    }

    private void saveNamespaces(KeyedHashSet keyedHashSet) throws IOException {
        RegistryIndexElement registryIndexElement;
        FileOutputStream fileOutputStream = new FileOutputStream(this.namespacesFile);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        KeyedElement[] keyedElementArray = keyedHashSet.elements();
        KeyedElement[] keyedElementArray2 = new KeyedElement[keyedElementArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < keyedElementArray.length) {
            registryIndexElement = (RegistryIndexElement)keyedElementArray[n2];
            int[] nArray = this.filter(registryIndexElement.getExtensionPoints());
            int[] nArray2 = this.filter(registryIndexElement.getExtensions());
            if (nArray.length != 0 || nArray2.length != 0) {
                RegistryIndexElement registryIndexElement2 = new RegistryIndexElement((String)registryIndexElement.getKey(), nArray, nArray2);
                keyedElementArray2[n] = registryIndexElement2;
                ++n;
            }
            ++n2;
        }
        dataOutputStream.writeInt(n);
        n2 = 0;
        while (n2 < n) {
            registryIndexElement = (RegistryIndexElement)keyedElementArray2[n2];
            this.writeStringOrNull((String)registryIndexElement.getKey(), dataOutputStream);
            this.saveArray(registryIndexElement.getExtensionPoints(), dataOutputStream);
            this.saveArray(registryIndexElement.getExtensions(), dataOutputStream);
            ++n2;
        }
        dataOutputStream.flush();
        fileOutputStream.getFD().sync();
        dataOutputStream.close();
    }

    private void saveContributors(HashMap hashMap) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.contributorsFile);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        Collection collection = hashMap.values();
        dataOutputStream.writeInt(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RegistryContributor registryContributor = (RegistryContributor)iterator.next();
            this.writeStringOrNull(registryContributor.getActualId(), dataOutputStream);
            this.writeStringOrNull(registryContributor.getActualName(), dataOutputStream);
            this.writeStringOrNull(registryContributor.getId(), dataOutputStream);
            this.writeStringOrNull(registryContributor.getName(), dataOutputStream);
        }
        dataOutputStream.flush();
        fileOutputStream.getFD().sync();
        dataOutputStream.close();
    }

    private void saveTables(long l) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.tableFile);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        this.writeCacheHeader(dataOutputStream, l);
        dataOutputStream.writeInt(this.objectManager.getNextId());
        this.offsets.save(dataOutputStream);
        this.objectManager.getExtensionPoints().save(dataOutputStream, this.objectManager);
        dataOutputStream.flush();
        fileOutputStream.getFD().sync();
        dataOutputStream.close();
    }

    private void writeCacheHeader(DataOutputStream dataOutputStream, long l) throws IOException {
        dataOutputStream.writeInt(5);
        dataOutputStream.writeLong(this.registry.computeState());
        dataOutputStream.writeLong(l);
        dataOutputStream.writeLong(this.mainDataFile.length());
        dataOutputStream.writeLong(this.extraDataFile.length());
        dataOutputStream.writeLong(this.contributionsFile.length());
        dataOutputStream.writeLong(this.contributorsFile.length());
        dataOutputStream.writeLong(this.namespacesFile.length());
        dataOutputStream.writeLong(this.orphansFile.length());
        dataOutputStream.writeUTF(RegistryProperties.getProperty("osgi.os", ""));
        dataOutputStream.writeUTF(RegistryProperties.getProperty("osgi.ws", ""));
        dataOutputStream.writeUTF(RegistryProperties.getProperty("osgi.nl", ""));
    }

    private void saveArray(int[] nArray, DataOutputStream dataOutputStream) throws IOException {
        if (nArray == null) {
            dataOutputStream.writeInt(0);
            return;
        }
        dataOutputStream.writeInt(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            dataOutputStream.writeInt(nArray[n]);
            ++n;
        }
    }

    private void saveExtensionPoint(ExtensionPointHandle extensionPointHandle) throws IOException {
        if (!extensionPointHandle.shouldPersist()) {
            return;
        }
        this.offsets.put(extensionPointHandle.getId(), this.mainOutput.size());
        this.mainOutput.writeInt(extensionPointHandle.getId());
        this.saveArray(this.filter(extensionPointHandle.getObject().getRawChildren()), this.mainOutput);
        this.mainOutput.writeInt(this.getExtraDataPosition());
        this.saveExtensionPointData(extensionPointHandle);
        this.saveExtensions(extensionPointHandle.getExtensions(), this.mainOutput);
    }

    private void saveExtension(ExtensionHandle extensionHandle, DataOutputStream dataOutputStream) throws IOException {
        if (!extensionHandle.shouldPersist()) {
            return;
        }
        this.offsets.put(extensionHandle.getId(), dataOutputStream.size());
        dataOutputStream.writeInt(extensionHandle.getId());
        this.writeStringOrNull(extensionHandle.getSimpleIdentifier(), dataOutputStream);
        this.writeStringOrNull(extensionHandle.getNamespaceIdentifier(), dataOutputStream);
        this.saveArray(this.filter(extensionHandle.getObject().getRawChildren()), dataOutputStream);
        dataOutputStream.writeInt(this.getExtraDataPosition());
        this.saveExtensionData(extensionHandle);
    }

    private void writeStringArray(String[] stringArray, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(stringArray == null ? 0 : stringArray.length);
        int n = 0;
        while (n < (stringArray == null ? 0 : stringArray.length)) {
            this.writeStringOrNull(stringArray[n], dataOutputStream);
            ++n;
        }
    }

    private void saveConfigurationElement(ConfigurationElementHandle configurationElementHandle, DataOutputStream dataOutputStream, DataOutputStream dataOutputStream2, int n) throws IOException {
        if (!configurationElementHandle.shouldPersist()) {
            return;
        }
        DataOutputStream dataOutputStream3 = dataOutputStream;
        if (n > 2) {
            dataOutputStream3 = dataOutputStream2;
        }
        this.offsets.put(configurationElementHandle.getId(), dataOutputStream3.size());
        dataOutputStream3.writeInt(configurationElementHandle.getId());
        ConfigurationElement configurationElement = (ConfigurationElement)configurationElementHandle.getObject();
        this.writeStringOrNull(configurationElement.getContributorId(), dataOutputStream3);
        this.writeStringOrNull(configurationElement.getName(), dataOutputStream3);
        dataOutputStream3.writeInt(configurationElement.parentId);
        dataOutputStream3.writeByte(configurationElement.parentType);
        dataOutputStream3.writeInt(n > 1 ? dataOutputStream2.size() : -1);
        this.writeStringArray(configurationElement.getPropertiesAndValue(), dataOutputStream3);
        this.saveArray(this.filter(configurationElement.getRawChildren()), dataOutputStream3);
        ConfigurationElementHandle[] configurationElementHandleArray = (ConfigurationElementHandle[])configurationElementHandle.getChildren();
        int n2 = 0;
        while (n2 < configurationElementHandleArray.length) {
            this.saveConfigurationElement(configurationElementHandleArray[n2], dataOutputStream, dataOutputStream2, n + 1);
            ++n2;
        }
    }

    private void saveExtensions(IExtension[] iExtensionArray, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        while (n < iExtensionArray.length) {
            this.saveExtension((ExtensionHandle)iExtensionArray[n], dataOutputStream);
            ++n;
        }
        n = 0;
        while (n < iExtensionArray.length) {
            if (((ExtensionHandle)iExtensionArray[n]).shouldPersist()) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                boolean[] blArray = new boolean[iConfigurationElementArray.length];
                int n3 = 0;
                while (n3 < iConfigurationElementArray.length) {
                    if (((ConfigurationElementHandle)iConfigurationElementArray[n3]).shouldPersist()) {
                        blArray[n3] = true;
                        ++n2;
                    } else {
                        blArray[n3] = false;
                    }
                    ++n3;
                }
                dataOutputStream.writeInt(n2);
                n3 = 0;
                while (n3 < iConfigurationElementArray.length) {
                    if (blArray[n3]) {
                        this.saveConfigurationElement((ConfigurationElementHandle)iConfigurationElementArray[n3], dataOutputStream, this.extraOutput, 1);
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    private void saveExtensionPointData(ExtensionPointHandle extensionPointHandle) throws IOException {
        this.writeStringOrNull(extensionPointHandle.getLabel(), this.extraOutput);
        this.writeStringOrNull(extensionPointHandle.getSchemaReference(), this.extraOutput);
        this.writeStringOrNull(extensionPointHandle.getUniqueIdentifier(), this.extraOutput);
        this.writeStringOrNull(extensionPointHandle.getNamespaceIdentifier(), this.extraOutput);
        this.writeStringOrNull(((ExtensionPoint)extensionPointHandle.getObject()).getContributorId(), this.extraOutput);
    }

    private void saveExtensionData(ExtensionHandle extensionHandle) throws IOException {
        this.writeStringOrNull(extensionHandle.getLabel(), this.extraOutput);
        this.writeStringOrNull(extensionHandle.getExtensionPointUniqueIdentifier(), this.extraOutput);
        this.writeStringOrNull(extensionHandle.getContributorId(), this.extraOutput);
    }

    private void writeStringOrNull(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string);
        }
    }

    private void saveOrphans() throws IOException {
        Map.Entry entry;
        Object object;
        Map.Entry entry2;
        Map map = this.objectManager.getOrphanExtensions();
        HashMap hashMap = new HashMap();
        Object object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            entry2 = object2.next();
            object = this.filter((int[])entry2.getValue());
            if (((int[])object).length == 0) continue;
            hashMap.put(entry2.getKey(), (int[])object);
        }
        object2 = new FileOutputStream(this.orphansFile);
        entry2 = new DataOutputStream(new BufferedOutputStream((OutputStream)object2));
        ((DataOutputStream)((Object)entry2)).writeInt(hashMap.size());
        object = hashMap.entrySet();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            ((DataOutputStream)((Object)entry2)).writeUTF((String)entry.getKey());
            this.saveArray((int[])entry.getValue(), (DataOutputStream)((Object)entry2));
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            this.mainOutput.writeInt(((int[])entry.getValue()).length);
            this.saveExtensions((IExtension[])this.objectManager.getHandles((int[])entry.getValue(), (byte)2), this.mainOutput);
        }
        ((DataOutputStream)((Object)entry2)).flush();
        ((FileOutputStream)object2).getFD().sync();
        ((FilterOutputStream)((Object)entry2)).close();
    }

    private void log(Status status) {
        this.registry.log((IStatus)status);
    }

    private int[] filter(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (this.objectManager.shouldPersist(nArray[n2])) {
                blArray[n2] = true;
                ++n;
            } else {
                blArray[n2] = false;
            }
            ++n2;
        }
        int[] nArray2 = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (blArray[n4]) {
                nArray2[n3] = nArray[n4];
                ++n3;
            }
            ++n4;
        }
        return nArray2;
    }
}

