/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.jface.util.Assert;

public class ListenerList {
    private int capacity;
    private int size;
    private Object[] listeners = null;
    private static final Object[] EmptyArray = new Object[0];

    public ListenerList() {
        this(1);
    }

    public ListenerList(int n) {
        Assert.isTrue(n >= 1);
        this.capacity = n;
    }

    public void add(Object object) {
        Assert.isNotNull(object);
        if (this.size == 0) {
            this.listeners = new Object[this.capacity];
        } else {
            int n = 0;
            while (n < this.size) {
                if (this.listeners[n] == object) {
                    return;
                }
                ++n;
            }
            if (this.size == this.listeners.length) {
                this.listeners = new Object[this.size * 2 + 1];
                System.arraycopy(this.listeners, 0, this.listeners, 0, this.size);
            }
        }
        this.listeners[this.size] = object;
        ++this.size;
    }

    public void clear() {
        this.size = 0;
        this.listeners = null;
    }

    public Object[] getListeners() {
        if (this.size == 0) {
            return EmptyArray;
        }
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.listeners, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(Object object) {
        Assert.isNotNull(object);
        int n = 0;
        while (n < this.size) {
            if (this.listeners[n] == object) {
                if (this.size == 1) {
                    this.listeners = null;
                    this.size = 0;
                } else {
                    System.arraycopy(this.listeners, n + 1, this.listeners, n, --this.size - n);
                    this.listeners[this.size] = null;
                }
                return;
            }
            ++n;
        }
    }

    public int size() {
        return this.size;
    }
}

