/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ShellPool {
    private int flags;
    private Shell parentShell;
    private LinkedList availableShells = new LinkedList();
    private static final String CLOSE_LISTENER = "close listener";
    private boolean isDisposed = false;
    private Listener closeListener = new Listener(){

        public void handleEvent(Event event) {
            if (ShellPool.this.isDisposed) {
                return;
            }
            if (event.doit) {
                Shell shell = (Shell)event.widget;
                ShellListener shellListener = (ShellListener)shell.getData(ShellPool.CLOSE_LISTENER);
                shell.removeShellListener(shellListener);
                shell.removeListener(21, (Listener)this);
                Control[] controlArray = shell.getChildren();
                int n = 0;
                while (n < controlArray.length) {
                    Control control = controlArray[n];
                    control.dispose();
                    ++n;
                }
                ShellPool.this.availableShells.add(shell);
                shell.setVisible(false);
            }
            event.doit = false;
        }
    };

    public ShellPool(Shell shell, int n) {
        this.parentShell = shell;
        this.flags = n;
    }

    public Shell allocateShell(ShellListener shellListener) {
        Shell shell = !this.availableShells.isEmpty() ? (Shell)this.availableShells.removeFirst() : new Shell(this.parentShell, this.flags);
        shell.addShellListener(shellListener);
        shell.setData(CLOSE_LISTENER, (Object)shellListener);
        shell.addListener(21, this.closeListener);
        return shell;
    }

    public void dispose() {
        Iterator iterator = this.availableShells.iterator();
        while (iterator.hasNext()) {
            Shell shell = (Shell)iterator.next();
            shell.dispose();
        }
        this.availableShells.clear();
        this.isDisposed = true;
    }
}

