/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.internal.EarlyStartupRunnable;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.ExtensionEventHandler;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.UILockListener;
import org.eclipse.ui.internal.UISynchronizer;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.internal.WorkbenchConfigurer;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.commands.WorkbenchCommandSupport;
import org.eclipse.ui.internal.handlers.HandlerService;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.views.IViewRegistry;

public final class Workbench
implements IWorkbench {
    private static final String[] VERSION_STRING = new String[]{"0.046", "2.0"};
    private static final String DEFAULT_WORKBENCH_STATE_FILENAME = "workbench.xml";
    private static Workbench instance;
    private Display display;
    private WorkbenchWindow activatedWindow;
    private boolean runEventLoop = true;
    private boolean isStarting = true;
    private boolean isClosing = false;
    private int returnCode = 2;
    private ListenerList windowListeners = new ListenerList();
    private WorkbenchAdvisor advisor;
    private WorkbenchConfigurer workbenchConfigurer;
    private ExtensionEventHandler extensionEventHandler;
    private int largeUpdates = 0;
    final Map services = new HashMap();
    private boolean openShellEnabled = !Boolean.getBoolean("container.ercp.hidefirstapp");
    private WorkbenchCommandSupport workbenchCommandSupport;
    private CommandManager commandManager;
    private ContextManager contextManager;
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }

        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
            Workbench.this.updateActiveWorkbenchWindowMenuManager(true);
        }
    };
    private IExtensionTracker tracker;
    private IRegistryChangeListener startupRegistryListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
            IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "startup");
            if (iExtensionDeltaArray.length == 0) {
                return;
            }
            String string = Workbench.this.getPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            Runnable runnable = new Runnable(this, iExtensionDeltaArray, string){
                final /* synthetic */ 2 this$1;
                private final /* synthetic */ IExtensionDelta[] val$deltas;
                private final /* synthetic */ String val$disabledPlugins;
                {
                    this.this$1 = var1_1;
                    this.val$deltas = iExtensionDeltaArray;
                    this.val$disabledPlugins = string;
                }

                public void run() {
                    int n = 0;
                    while (n < this.val$deltas.length) {
                        IExtension iExtension = this.val$deltas[n].getExtension();
                        if (this.val$deltas[n].getKind() != 2 && this.val$disabledPlugins.indexOf(iExtension.getNamespace()) == -1) {
                            Platform.run((ISafeRunnable)new EarlyStartupRunnable(iExtension));
                        }
                        ++n;
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    };
    private static IExceptionHandler exceptionHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        exceptionHandler = new DefaultExceptionHandler();
    }

    private Workbench(Display display, WorkbenchAdvisor workbenchAdvisor) {
        if (instance != null && instance.isRunning()) {
            throw new IllegalStateException(WorkbenchMessages.Workbench_CreatingWorkbenchTwice);
        }
        Assert.isNotNull(display);
        Assert.isNotNull(workbenchAdvisor);
        this.advisor = workbenchAdvisor;
        this.display = display;
        instance = this;
        this.extensionEventHandler = new ExtensionEventHandler(this);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
    }

    public static final Workbench getInstance() {
        return instance;
    }

    public static final int createAndRunWorkbench(Display display, WorkbenchAdvisor workbenchAdvisor) {
        Workbench workbench = new Workbench(display, workbenchAdvisor);
        int n = workbench.runUI();
        return n;
    }

    public static Display createDisplay() {
        String string = "eWorkbench";
        if (string != null) {
            Display.setAppName((String)string);
        }
        Display display = new Display();
        display.setWarnings(false);
        return display;
    }

    public void addWindowListener(IWindowListener iWindowListener) {
        this.windowListeners.add((Object)iWindowListener);
    }

    public void removeWindowListener(IWindowListener iWindowListener) {
        this.windowListeners.remove((Object)iWindowListener);
    }

    protected void fireWindowOpened(final IWorkbenchWindow iWorkbenchWindow) {
        Object[] objectArray = this.windowListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWindowListener iWindowListener = (IWindowListener)objectArray[n];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWindowListener.windowOpened(iWorkbenchWindow);
                }
            });
            ++n;
        }
    }

    protected void fireWindowClosed(final IWorkbenchWindow iWorkbenchWindow) {
        if (this.activatedWindow == iWorkbenchWindow) {
            this.activatedWindow = null;
        }
        Object[] objectArray = this.windowListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWindowListener iWindowListener = (IWindowListener)objectArray[n];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWindowListener.windowClosed(iWorkbenchWindow);
                }
            });
            ++n;
        }
    }

    protected void fireWindowActivated(final IWorkbenchWindow iWorkbenchWindow) {
        Object[] objectArray = this.windowListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWindowListener iWindowListener = (IWindowListener)objectArray[n];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWindowListener.windowActivated(iWorkbenchWindow);
                }
            });
            ++n;
        }
    }

    protected void fireWindowDeactivated(final IWorkbenchWindow iWorkbenchWindow) {
        Object[] objectArray = this.windowListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IWindowListener iWindowListener = (IWindowListener)objectArray[n];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iWindowListener.windowDeactivated(iWorkbenchWindow);
                }
            });
            ++n;
        }
    }

    private boolean busyClose(final boolean bl) {
        this.isClosing = this.advisor.preShutdown();
        if (!bl && !this.isClosing) {
            return false;
        }
        if (this.getWorkbenchConfigurer().getSaveAndRestore()) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    XMLMemento xMLMemento = Workbench.this.recordWorkbenchState();
                    Workbench.this.saveMementoToFile(xMLMemento);
                }

                public void handleException(Throwable throwable) {
                    String string = throwable.getMessage() == null ? WorkbenchMessages.ErrorClosingNoArg : NLS.bind((String)WorkbenchMessages.ErrorClosingOneArg, (Object)throwable.getMessage());
                    if (!ShowMessage.openQuestion(null, WorkbenchMessages.Error, string)) {
                        Workbench.this.isClosing = false;
                    }
                }
            });
        }
        if (!bl && !this.isClosing) {
            return false;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorClosing){

            public void run() {
                if (Workbench.this.isClosing || bl) {
                    IWorkbenchWindow[] iWorkbenchWindowArray = Workbench.this.getWorkbenchWindows();
                    int n = 0;
                    while (n < iWorkbenchWindowArray.length) {
                        IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                        Workbench.this.isClosing = iWorkbenchWindow.close();
                        if (!Workbench.this.isClosing) break;
                        ++n;
                    }
                }
            }
        });
        if (!bl && !this.isClosing) {
            return false;
        }
        this.shutdown();
        this.runEventLoop = false;
        return true;
    }

    public boolean saveAllEditors(boolean bl) {
        return true;
    }

    private IWorkbenchWindow busyOpenWorkbenchWindow(String string, IAdaptable iAdaptable) throws WorkbenchException {
        WorkbenchWindow workbenchWindow = this.newWorkbenchWindow();
        workbenchWindow.create();
        if (string != null) {
            workbenchWindow.busyOpenPage(string, iAdaptable);
        }
        workbenchWindow.open();
        return workbenchWindow;
    }

    public boolean close() {
        Integer n = (Integer)System.getProperties().get("eworkbench.returnCode");
        if (n != null) {
            return this.close(n, true);
        }
        return this.close(0, false);
    }

    boolean close(int n, boolean bl) {
        this.returnCode = n;
        boolean[] blArray = new boolean[]{this.busyClose(bl)};
        return blArray[0];
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        Object object;
        if (Display.getCurrent() == null) {
            return null;
        }
        Shell shell = this.display.getActiveShell();
        while (shell != null && !shell.isDisposed()) {
            object = shell.getData();
            if (object instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)object;
            }
            shell = shell.getParent();
        }
        object = this.getActivatedWindow();
        if (object != null) {
            return object;
        }
        Shell[] shellArray = this.display.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Object object2 = shellArray[n].getData();
            if (object2 instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)object2;
            }
            ++n;
        }
        return null;
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        return WorkbenchPlugin.getDefault().getPerspectiveRegistry();
    }

    public PreferenceManager getPreferenceManager() {
        return WorkbenchPlugin.getDefault().getPreferenceManager();
    }

    public IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public ISharedImages getSharedImages() {
        return WorkbenchPlugin.getDefault().getSharedImages();
    }

    private File getWorkbenchStateFile() {
        IPath iPath = WorkbenchPlugin.getDefault().getDataLocation();
        if (iPath == null) {
            return null;
        }
        iPath = iPath.append(DEFAULT_WORKBENCH_STATE_FILENAME);
        return iPath.toFile();
    }

    public int getWorkbenchWindowCount() {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        return iWorkbenchWindowArray != null ? iWorkbenchWindowArray.length : 0;
    }

    public IWorkbenchWindow[] getWorkbenchWindows() {
        if (Display.getCurrent() == null) {
            return null;
        }
        Shell[] shellArray = Display.getCurrent().getShells();
        ArrayList<Object> arrayList = new ArrayList<Object>(shellArray.length);
        int n = 0;
        while (n < shellArray.length) {
            if (shellArray[n].getData() instanceof WorkbenchWindow) {
                arrayList.add(shellArray[n].getData());
            }
            ++n;
        }
        return arrayList.toArray(new IWorkbenchWindow[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean init(Display display) {
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.DEBUG = true;
            ModalContext.setDebugMode((boolean)true);
        }
        this.commandManager = new CommandManager();
        CommandService commandService = new CommandService(this.commandManager);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.services.put(clazz, commandService);
        HandlerService handlerService = new HandlerService(this.commandManager);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.services.put(clazz2, handlerService);
        commandService.readRegistry();
        this.addWindowListener(this.windowListener);
        this.initializeImages();
        this.initializeFonts();
        this.initializeColors();
        this.initializeApplicationColors();
        this.advisor.internalBasicInitialize(this.getWorkbenchConfigurer());
        this.getPreferenceStore().getBoolean("COLOR_ICONS");
        this.initializeSingleClickOption();
        boolean bl = true;
        String[] stringArray = Platform.getCommandLineArgs();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-allowDeadlock")) {
                bl = false;
            }
            ++n;
        }
        if (bl) {
            UILockListener uILockListener = new UILockListener(display);
            Platform.getJobManager().setLockListener((LockListener)uILockListener);
            display.setSynchronizer((Synchronizer)new UISynchronizer(display, uILockListener));
        }
        try {
            UIStats.start(4, "Workbench");
            this.advisor.preStartup();
            if (!this.advisor.openWindows()) {
                Object var6_8 = null;
                UIStats.end(4, this, "Workbench");
                return false;
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            UIStats.end(4, this, "Workbench");
            throw throwable;
        }
        UIStats.end(4, this, "Workbench");
        this.forceOpenPerspective();
        this.isStarting = false;
        return true;
    }

    private void initializeApplicationColors() {
    }

    private void initializeSingleClickOption() {
        int n;
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("OPEN_ON_SINGLE_CLICK");
        boolean bl2 = iPreferenceStore.getBoolean("SELECT_ON_HOVER");
        boolean bl3 = iPreferenceStore.getBoolean("OPEN_AFTER_DELAY");
        int n2 = n = bl ? 1 : 0;
        if (bl) {
            if (bl2) {
                n |= 2;
            }
            if (bl3) {
                n |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)n);
    }

    private void initializeFonts() {
    }

    private void initializeImages() {
    }

    private void uninitializeImages() {
        WorkbenchImages.dispose();
    }

    private void initializeColors() {
        WorkbenchColors.startup();
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    boolean isStarting() {
        return this.isStarting;
    }

    private WorkbenchWindow newWorkbenchWindow() {
        return new WorkbenchWindow();
    }

    private void forceOpenPerspective() {
        String string = null;
        String[] stringArray = Platform.getCommandLineArgs();
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].equalsIgnoreCase("-perspective")) {
                string = stringArray[n + 1];
                break;
            }
            ++n;
        }
        if (string == null) {
            return;
        }
        IPerspectiveDescriptor iPerspectiveDescriptor = this.getPerspectiveRegistry().findPerspectiveWithId(string);
        if (iPerspectiveDescriptor == null) {
            return;
        }
        IWorkbenchWindow iWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = this.getWorkbenchWindowCount() == 0 ? null : this.getWorkbenchWindows()[0];
        }
        try {
            this.showPerspective(string, iWorkbenchWindow);
        }
        catch (WorkbenchException workbenchException) {
            String string2 = "Workbench exception showing specified command line perspective on startup.";
            WorkbenchPlugin.log(string2, (IStatus)new Status(4, "org.eclipse.ui", 0, string2, (Throwable)((Object)workbenchException)));
        }
    }

    void openFirstTimeWindow() {
        try {
            this.busyOpenWorkbenchWindow(this.getPerspectiveRegistry().getDefaultPerspective(), this.getDefaultPageInput());
        }
        catch (WorkbenchException workbenchException) {
            ShowMessage.printError(workbenchException.getMessage(), workbenchException.getStatus());
        }
    }

    IStatus restoreState() {
        if (!this.getWorkbenchConfigurer().getSaveAndRestore()) {
            String string = WorkbenchMessages.Workbench_restoreDisabled;
            return new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, string, null);
        }
        final File file = this.getWorkbenchStateFile();
        if (file == null || !file.exists()) {
            String string = WorkbenchMessages.Workbench_noStateToRestore;
            return new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, string, null);
        }
        final IStatus[] iStatusArray = new IStatus[]{new Status(0, WorkbenchPlugin.PI_WORKBENCH, 0, "", null)};
        Platform.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorReadingState){

            public void run() throws Exception {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                XMLMemento xMLMemento = XMLMemento.createReadRoot(bufferedReader);
                String string = xMLMemento.getString("version");
                boolean bl = false;
                int n = 0;
                while (n < VERSION_STRING.length) {
                    if (VERSION_STRING[n].equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    bufferedReader.close();
                    String string2 = WorkbenchMessages.Invalid_workbench_state_ve;
                    ShowMessage.openError(null, WorkbenchMessages.Restoring_Problems, string2);
                    file.delete();
                    iStatusArray[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, string2, null);
                    return;
                }
                if (VERSION_STRING[0].equals(string)) {
                    boolean bl2;
                    bufferedReader.close();
                    String string3 = WorkbenchMessages.Workbench_incompatibleSavedStateVersion;
                    boolean bl3 = bl2 = ShowMessage.openBox(null, WorkbenchMessages.Workbench_incompatibleUIState, string3, 296) == 32;
                    if (bl2) {
                        file.delete();
                        iStatusArray[0] = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 1, string3, null);
                    } else {
                        iStatusArray[0] = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 2, string3, null);
                    }
                    return;
                }
                IStatus iStatus = Workbench.this.restoreState(xMLMemento);
                bufferedReader.close();
                if (iStatus.getSeverity() == 4) {
                    ShowMessage.printError(WorkbenchMessages.Workbench_problemsRestoringMsg, iStatus);
                }
            }

            public void handleException(Throwable throwable) {
                super.handleException(throwable);
                String string = throwable.getMessage() == null ? "" : throwable.getMessage();
                iStatusArray[0] = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, string, throwable);
                file.delete();
            }
        });
        return iStatusArray[0];
    }

    public IWorkbenchWindow openWorkbenchWindow(IAdaptable iAdaptable) throws WorkbenchException {
        return this.openWorkbenchWindow(this.getPerspectiveRegistry().getDefaultPerspective(), iAdaptable);
    }

    public IWorkbenchWindow openWorkbenchWindow(String string, IAdaptable iAdaptable) throws WorkbenchException {
        Object[] objectArray = new Object[1];
        try {
            objectArray[0] = this.busyOpenWorkbenchWindow(string, iAdaptable);
        }
        catch (WorkbenchException workbenchException) {
            objectArray[0] = workbenchException;
        }
        if (objectArray[0] instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)objectArray[0];
        }
        if (objectArray[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)objectArray[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.Abnormal_Workbench_Conditi);
    }

    private XMLMemento recordWorkbenchState() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("workbench");
        IStatus iStatus = this.saveState(xMLMemento);
        if (iStatus.getSeverity() != 0) {
            ShowMessage.printError(WorkbenchMessages.Workbench_problemsSavingMsg, iStatus);
        }
        return xMLMemento;
    }

    public boolean restart() {
        return this.close(1, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus restoreState(IMemento iMemento) {
        IMemento[] iMementoArray;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsRestoring, null);
        try {
            UIStats.start(4, "MRUList");
            iMemento.getChild("mruList");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            UIStats.end(4, this, "MRUList");
            throw throwable;
        }
        {
            iMementoArray = null;
        }
        UIStats.end(4, this, "MRUList");
        iMementoArray = iMemento.getChildren("org.eclipse.jface.window");
        int n = 0;
        while (true) {
            block11: {
                Object var9_11;
                if (n >= iMementoArray.length) {
                    return multiStatus;
                }
                IMemento iMemento2 = iMementoArray[n];
                WorkbenchWindow workbenchWindow = this.newWorkbenchWindow();
                workbenchWindow.create();
                boolean bl = false;
                try {
                    multiStatus.merge(workbenchWindow.restoreState(iMemento2, null));
                    try {
                        workbenchWindow.fireWindowRestored();
                    }
                    catch (WorkbenchException workbenchException) {
                        multiStatus.add(workbenchException.getStatus());
                    }
                    workbenchWindow.open();
                    bl = true;
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    if (!bl) {
                        workbenchWindow.close();
                    }
                    throw throwable;
                }
                {
                    var9_11 = null;
                    if (bl) break block11;
                    workbenchWindow.close();
                }
            }
            ++n;
        }
    }

    public String[] getEarlyActivatedPlugins() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "startup");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        String[] stringArray = new String[iExtensionArray.length];
        int n = 0;
        while (n < iExtensionArray.length) {
            stringArray[n] = iExtensionArray[n].getNamespace();
            ++n;
        }
        return stringArray;
    }

    private void startPlugins() {
        Runnable runnable = new Runnable(){
            final String disabledPlugins;
            {
                this.disabledPlugins = Workbench.this.getPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            }

            public void run() {
                IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
                IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.ui", "startup");
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    if (this.disabledPlugins.indexOf(iExtension.getNamespace()) == -1) {
                        Platform.run((ISafeRunnable)new EarlyStartupRunnable(iExtension));
                    }
                    ++n;
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runUI() {
        UIStats.start(5, "Workbench");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                event.doit = Workbench.this.close();
            }
        };
        ExceptionHandler exceptionHandler = ExceptionHandler.getInstance();
        try {
            block8: {
                try {
                    this.display.addListener(21, listener);
                    Workbench.setExceptionHandler(exceptionHandler);
                    boolean bl = this.init(this.display);
                    this.openShellEnabled = true;
                    Platform.endSplash();
                    if (bl) {
                        this.advisor.postStartup();
                    }
                    if (bl && this.runEventLoop) {
                        this.startPlugins();
                        this.display.asyncExec(new Runnable(){

                            public void run() {
                                UIStats.end(5, this, "Workbench");
                            }
                        });
                        this.runEventLoop(exceptionHandler, this.display);
                    }
                }
                catch (Exception exception) {
                    if (!this.display.isDisposed()) {
                        exceptionHandler.handleException(exception);
                        break block8;
                    }
                    String string = "Exception in Workbench.runUI after display was disposed";
                    WorkbenchPlugin.log(string, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, string, (Throwable)exception));
                }
            }
            Object var5_8 = null;
            this.runEventLoop = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.runEventLoop = false;
            if (this.display.isDisposed()) throw throwable;
            this.display.removeListener(21, listener);
            throw throwable;
        }
        if (this.display.isDisposed()) return this.returnCode;
        this.display.removeListener(21, listener);
        return this.returnCode;
    }

    private void runEventLoop(IExceptionHandler iExceptionHandler, Display display) {
        this.runEventLoop = true;
        while (this.runEventLoop) {
            try {
                if (display.readAndDispatch()) continue;
                this.getAdvisor().eventLoopIdle(display);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                iExceptionHandler.handleException(throwable);
            }
        }
    }

    private IStatus saveState(IMemento iMemento) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsSaving, null);
        iMemento.putString("version", VERSION_STRING[1]);
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n];
            IMemento iMemento2 = iMemento.createChild("org.eclipse.jface.window");
            multiStatus.merge(workbenchWindow.saveState(iMemento2));
            ++n;
        }
        return multiStatus;
    }

    private boolean saveMementoToFile(XMLMemento xMLMemento) {
        File file = this.getWorkbenchStateFile();
        if (file == null) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            xMLMemento.save(outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            file.delete();
            ShowMessage.openError(null, WorkbenchMessages.SavingProblem, WorkbenchMessages.ProblemSavingState);
            return false;
        }
        return true;
    }

    public IWorkbenchPage showPerspective(String string, IWorkbenchWindow iWorkbenchWindow) throws WorkbenchException {
        Object object;
        Object object2;
        int n;
        Object[] objectArray;
        WorkbenchPage workbenchPage;
        Assert.isNotNull(string);
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        if (workbenchWindow != null && (workbenchPage = workbenchWindow.getActiveWorkbenchPage()) != null) {
            objectArray = workbenchPage.getOpenPerspectives();
            n = 0;
            while (n < objectArray.length) {
                object2 = objectArray[n];
                if (string.equals(object2.getId())) {
                    workbenchWindow.getShell().open();
                    workbenchPage.setPerspective((IPerspectiveDescriptor)object2);
                    return workbenchPage;
                }
                ++n;
            }
        }
        workbenchPage = this.getDefaultPageInput();
        objectArray = this.getWorkbenchWindows();
        n = 0;
        while (n < objectArray.length) {
            workbenchWindow = (WorkbenchWindow)objectArray[n];
            if (iWorkbenchWindow != workbenchWindow && (object2 = workbenchWindow.getActiveWorkbenchPage()) != null) {
                boolean bl = false;
                bl = workbenchPage == null ? ((WorkbenchPage)object2).getInput() == null : workbenchPage.equals(((WorkbenchPage)object2).getInput());
                if (bl && string.equals(((Perspective)(object = ((WorkbenchPage)object2).getActivePerspective())).getDesc().getId())) {
                    Shell shell = workbenchWindow.getShell();
                    shell.open();
                    if (shell.getMinimized()) {
                        shell.setMinimized(false);
                    }
                    return object2;
                }
            }
            ++n;
        }
        workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        if (workbenchWindow != null) {
            IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
            int n2 = iPreferenceStore.getInt("OPEN_PERSPECTIVE_MODE");
            IWorkbenchPage iWorkbenchPage = workbenchWindow.getActiveWorkbenchPage();
            object = null;
            if (iWorkbenchPage != null) {
                object = iWorkbenchPage.getPerspective();
            }
            if (2 == n2 && object != null) {
                IWorkbenchWindow iWorkbenchWindow2 = this.openWorkbenchWindow(string, (IAdaptable)workbenchPage);
                return iWorkbenchWindow2.getActivePage();
            }
            IPerspectiveDescriptor iPerspectiveDescriptor = this.getPerspectiveRegistry().findPerspectiveWithId(string);
            if (iPerspectiveDescriptor == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)string));
            }
            workbenchWindow.getShell().open();
            if (iWorkbenchPage == null) {
                iWorkbenchPage = workbenchWindow.openPage(string, (IAdaptable)workbenchPage);
            } else {
                iWorkbenchPage.setPerspective(iPerspectiveDescriptor);
            }
            return iWorkbenchPage;
        }
        throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)string));
    }

    public IWorkbenchPage showPerspective(String string, IWorkbenchWindow iWorkbenchWindow, IAdaptable iAdaptable) throws WorkbenchException {
        IPreferenceStore iPreferenceStore;
        int n;
        Object object;
        int n2;
        Object object2;
        int n3;
        IWorkbenchWindow[] iWorkbenchWindowArray;
        Assert.isNotNull(string);
        boolean bl = false;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        if (workbenchWindow != null && (iWorkbenchWindowArray = workbenchWindow.getActiveWorkbenchPage()) != null) {
            n3 = 0;
            n3 = iAdaptable == null ? (iWorkbenchWindowArray.getInput() == null ? 1 : 0) : (int)(iAdaptable.equals(iWorkbenchWindowArray.getInput()) ? 1 : 0);
            if (n3 != 0) {
                bl = true;
                object2 = iWorkbenchWindowArray.getOpenPerspectives();
                n2 = 0;
                while (n2 < ((IPerspectiveDescriptor[])object2).length) {
                    object = object2[n2];
                    if (string.equals(object.getId())) {
                        workbenchWindow.getShell().open();
                        iWorkbenchWindowArray.setPerspective((IPerspectiveDescriptor)object);
                        return iWorkbenchWindowArray;
                    }
                    ++n2;
                }
            }
        }
        iWorkbenchWindowArray = this.getWorkbenchWindows();
        n3 = 0;
        while (n3 < iWorkbenchWindowArray.length) {
            workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n3];
            if (iWorkbenchWindow != workbenchWindow && (object2 = workbenchWindow.getActiveWorkbenchPage()) != null) {
                n2 = 0;
                n2 = iAdaptable == null ? (((WorkbenchPage)object2).getInput() == null ? 1 : 0) : (int)(iAdaptable.equals(((WorkbenchPage)object2).getInput()) ? 1 : 0);
                if (n2 != 0 && string.equals(((Perspective)(object = ((WorkbenchPage)object2).getActivePerspective())).getDesc().getId())) {
                    workbenchWindow.getShell().open();
                    return object2;
                }
            }
            ++n3;
        }
        workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
        if (bl && workbenchWindow != null && 2 != (n = (iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore()).getInt("OPEN_PERSPECTIVE_MODE"))) {
            IWorkbenchPage iWorkbenchPage = workbenchWindow.getActiveWorkbenchPage();
            object = this.getPerspectiveRegistry().findPerspectiveWithId(string);
            if (object == null) {
                throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)string));
            }
            workbenchWindow.getShell().open();
            if (iWorkbenchPage == null) {
                iWorkbenchPage = workbenchWindow.openPage(string, iAdaptable);
            } else {
                iWorkbenchPage.setPerspective((IPerspectiveDescriptor)object);
            }
            return iWorkbenchPage;
        }
        if (workbenchWindow != null) {
            IWorkbenchPage iWorkbenchPage = workbenchWindow.getActiveWorkbenchPage();
            IPerspectiveDescriptor iPerspectiveDescriptor = null;
            if (iWorkbenchPage != null) {
                iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
            }
            if (iPerspectiveDescriptor == null) {
                IPerspectiveDescriptor iPerspectiveDescriptor2 = this.getPerspectiveRegistry().findPerspectiveWithId(string);
                if (iPerspectiveDescriptor2 == null) {
                    throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)string));
                }
                workbenchWindow.getShell().open();
                if (iWorkbenchPage == null) {
                    iWorkbenchPage = workbenchWindow.openPage(string, iAdaptable);
                } else {
                    iWorkbenchPage.setPerspective(iPerspectiveDescriptor2);
                }
                return iWorkbenchPage;
            }
        }
        IWorkbenchWindow iWorkbenchWindow2 = this.openWorkbenchWindow(string, iAdaptable);
        return iWorkbenchWindow2.getActivePage();
    }

    private void shutdown() {
        this.advisor.postShutdown();
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.startupRegistryListener);
        WorkbenchColors.shutdown();
        this.uninitializeImages();
        if (WorkbenchPlugin.getDefault() != null) {
            WorkbenchPlugin.getDefault().reset();
        }
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private WorkbenchWindow getActivatedWindow() {
        Shell shell;
        if (this.activatedWindow != null && (shell = this.activatedWindow.getShell()) != null && !shell.isDisposed()) {
            return this.activatedWindow;
        }
        return null;
    }

    void setActivatedWindow(WorkbenchWindow workbenchWindow) {
        this.activatedWindow = workbenchWindow;
    }

    WorkbenchConfigurer getWorkbenchConfigurer() {
        if (this.workbenchConfigurer == null) {
            this.workbenchConfigurer = new WorkbenchConfigurer();
        }
        return this.workbenchConfigurer;
    }

    WorkbenchAdvisor getAdvisor() {
        return this.advisor;
    }

    public Display getDisplay() {
        return this.display;
    }

    public String getDefaultPerspectiveId() {
        return this.getAdvisor().getInitialWindowPerspectiveId();
    }

    public IAdaptable getDefaultPageInput() {
        return this.getAdvisor().getDefaultPageInput();
    }

    public String getMainPreferencePageId() {
        String string = this.getAdvisor().getMainPreferencePageId();
        return string;
    }

    public IElementFactory getElementFactory(String string) {
        Assert.isNotNull(string);
        return WorkbenchPlugin.getDefault().getElementFactory(string);
    }

    public IWorkbenchCommandSupport getCommandSupport() {
        return this.workbenchCommandSupport;
    }

    private void updateActiveWorkbenchWindowMenuManager(boolean bl) {
        WorkbenchWindow workbenchWindow;
        IWorkbenchWindow iWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (iWorkbenchWindow instanceof WorkbenchWindow && (workbenchWindow = (WorkbenchWindow)iWorkbenchWindow).isClosing()) {
            return;
        }
    }

    public boolean isRunning() {
        return this.runEventLoop;
    }

    public String getPresentationId() {
        String string = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
        if (string == null || string.equals("")) {
            string = "org.eclipse.ui.presentations.default";
        }
        return string;
    }

    public final void largeUpdateStart() {
        if (this.largeUpdates++ == 0) {
            IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
            int n = 0;
            while (n < iWorkbenchWindowArray.length) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                if (iWorkbenchWindow instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)iWorkbenchWindow).largeUpdateStart();
                }
                ++n;
            }
        }
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
            int n = 0;
            while (n < iWorkbenchWindowArray.length) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                if (iWorkbenchWindow instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)iWorkbenchWindow).largeUpdateEnd();
                }
                ++n;
            }
        }
    }

    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getDisplay());
        }
        return this.tracker;
    }

    private void addStartupRegistryListener() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        iExtensionRegistry.addRegistryChangeListener(this.startupRegistryListener);
    }

    public IViewRegistry getViewRegistry() {
        return WorkbenchPlugin.getDefault().getViewRegistry();
    }

    public final Object getAdapter(Class clazz) {
        return this.services.get(clazz);
    }

    public static void setExceptionHandler(IExceptionHandler iExceptionHandler) {
        if (exceptionHandler instanceof DefaultExceptionHandler) {
            exceptionHandler = iExceptionHandler;
        }
    }

    boolean isOpenShellEnabled() {
        return this.openShellEnabled;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public static interface IExceptionHandler {
        public void handleException(Throwable var1);
    }

    private static class DefaultExceptionHandler
    implements IExceptionHandler {
        private DefaultExceptionHandler() {
        }

        public void handleException(Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throwable.printStackTrace();
        }
    }
}

