/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime.auth;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Random;

public class Cipher {
    public static final int DECRYPT_MODE = -1;
    public static final int ENCRYPT_MODE = 1;
    private static final int RANDOM_SIZE = 16;
    private int mode = 0;
    private byte[] password = null;
    private byte[] byteStream;
    private int byteStreamOffset;
    private MessageDigest digest;
    private Random random;
    private final byte[] toDigest;

    public Cipher(int n, String string) {
        this.mode = n;
        try {
            this.password = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.password = string.getBytes();
        }
        this.toDigest = new byte[this.password.length + 16];
    }

    public byte[] cipher(byte[] byArray) throws Exception {
        return this.transform(byArray, 0, byArray.length, this.mode);
    }

    public byte[] cipher(byte[] byArray, int n, int n2) throws Exception {
        return this.transform(byArray, n, n2, this.mode);
    }

    public byte cipher(byte by) throws Exception {
        byte[] byArray = new byte[]{by};
        return this.cipher(byArray)[0];
    }

    private byte[] generateBytes() throws Exception {
        if (this.digest == null) {
            this.digest = MessageDigest.getInstance("SHA");
            long l = 0L;
            int n = 0;
            while (n < this.password.length) {
                l = l * 37L + (long)this.password[n];
                ++n;
            }
            this.random = new Random(l);
        }
        this.random.nextBytes(this.toDigest);
        System.arraycopy(this.password, 0, this.toDigest, 0, this.password.length);
        return this.digest.digest(this.toDigest);
    }

    private byte[] nextRandom(int n) throws Exception {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            if (this.byteStream == null || this.byteStreamOffset >= this.byteStream.length) {
                this.byteStream = this.generateBytes();
                this.byteStreamOffset = 0;
            }
            byArray[n2++] = this.byteStream[this.byteStreamOffset++];
        }
        return byArray;
    }

    private byte[] transform(byte[] byArray, int n, int n2, int n3) throws Exception {
        byte[] byArray2 = this.nextRandom(n2);
        int n4 = 0;
        while (n4 < n2) {
            byArray2[n4] = (byte)(byArray[n4 + n] + n3 * byArray2[n4]);
            ++n4;
        }
        return byArray2;
    }
}

