/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class Path
implements IPath,
Cloneable {
    private static final int HAS_LEADING = 1;
    private static final int IS_UNC = 2;
    private static final int HAS_TRAILING = 4;
    private static final int ALL_SEPARATORS = 7;
    private static final String EMPTY_STRING = "";
    private static final String[] NO_SEGMENTS = new String[0];
    public static final Path EMPTY = new Path("");
    private static final int HASH_MASK = -5;
    private static final String ROOT_STRING = "/";
    public static final Path ROOT = new Path("/");
    private static final boolean WINDOWS = File.separatorChar == '\\';
    private String device = null;
    private String[] segments;
    private int separators;

    public static IPath fromOSString(String string) {
        return new Path(string);
    }

    public static IPath fromPortableString(String string) {
        int n = string.indexOf(58) + 1;
        if (n <= 0) {
            return new Path().initialize(null, string);
        }
        String string2 = null;
        int n2 = string.length();
        if (n == n2 || string.charAt(n) != ':') {
            string2 = string.substring(0, n);
            string = string.substring(n, n2);
        }
        if (string.indexOf(58) == -1) {
            return new Path().initialize(string2, string);
        }
        char[] cArray = string.toCharArray();
        int n3 = 0;
        int n4 = 0;
        int n5 = cArray.length;
        while (n3 < n5) {
            if (cArray[n3] == ':' && ++n3 >= n5) break;
            cArray[n4++] = cArray[n3++];
        }
        return new Path().initialize(string2, new String(cArray, 0, n4));
    }

    private Path() {
    }

    public Path(String string) {
        int n;
        String string2 = null;
        if (WINDOWS && (n = (string = string.indexOf(92) == -1 ? string : string.replace('\\', '/')).indexOf(58)) != -1) {
            int n2 = string.charAt(0) == '/' ? 1 : 0;
            string2 = string.substring(n2, n + 1);
            string = string.substring(n + 1, string.length());
        }
        this.initialize(string2, string);
    }

    public Path(String string, String string2) {
        if (WINDOWS) {
            string2 = string2.indexOf(92) == -1 ? string2 : string2.replace('\\', '/');
        }
        this.initialize(string, string2);
    }

    private Path(String string, String[] stringArray, int n) {
        this.segments = stringArray;
        this.device = string;
        this.separators = this.computeHashCode() << 3 | n & 7;
    }

    public IPath addFileExtension(String string) {
        if (this.isRoot() || this.isEmpty() || this.hasTrailingSeparator()) {
            return this;
        }
        int n = this.segments.length;
        String[] stringArray = new String[n];
        System.arraycopy(this.segments, 0, stringArray, 0, n - 1);
        stringArray[n - 1] = String.valueOf(this.segments[n - 1]) + '.' + string;
        return new Path(this.device, stringArray, this.separators);
    }

    public IPath addTrailingSeparator() {
        if (this.hasTrailingSeparator() || this.isRoot()) {
            return this;
        }
        if (this.isEmpty()) {
            return new Path(this.device, this.segments, 1);
        }
        return new Path(this.device, this.segments, this.separators | 4);
    }

    public IPath append(IPath iPath) {
        if (iPath == null || iPath.segmentCount() == 0) {
            return this;
        }
        if (this.isEmpty()) {
            return iPath.setDevice(this.device).makeRelative().makeUNC(this.isUNC());
        }
        if (this.isRoot()) {
            return iPath.setDevice(this.device).makeAbsolute().makeUNC(this.isUNC());
        }
        int n = this.segments.length;
        int n2 = iPath.segmentCount();
        String[] stringArray = new String[n + n2];
        System.arraycopy(this.segments, 0, stringArray, 0, n);
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n + n3] = iPath.segment(n3);
            ++n3;
        }
        Path path = new Path(this.device, stringArray, this.separators & 3 | (iPath.hasTrailingSeparator() ? 4 : 0));
        String string = stringArray[n];
        if (string.equals("..") || string.equals(".")) {
            path.canonicalize();
        }
        return path;
    }

    public IPath append(String string) {
        if (string.indexOf(47) == -1 && string.indexOf("\\") == -1 && string.indexOf(58) == -1) {
            int n = string.length();
            if (n < 3) {
                if (n == 0 || ".".equals(string)) {
                    return this;
                }
                if ("..".equals(string)) {
                    return this.removeLastSegments(1);
                }
            }
            int n2 = this.segments.length;
            String[] stringArray = new String[n2 + 1];
            System.arraycopy(this.segments, 0, stringArray, 0, n2);
            stringArray[n2] = string;
            return new Path(this.device, stringArray, this.separators & 0xFFFFFFFB);
        }
        return this.append(new Path(string));
    }

    private boolean canonicalize() {
        int n = 0;
        int n2 = this.segments.length;
        while (n < n2) {
            String string = this.segments[n];
            if (string.charAt(0) == '.' && (string.equals("..") || string.equals("."))) {
                this.collapseParentReferences();
                if (this.segments.length == 0) {
                    this.separators &= 3;
                }
                this.separators = this.separators & 7 | this.computeHashCode() << 3;
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void collapseParentReferences() {
        int n = this.segments.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = this.segments[n3];
            if (string.equals("..")) {
                if (n2 == 0) {
                    if (!this.isAbsolute()) {
                        stringArray[n2++] = string;
                    }
                } else if ("..".equals(stringArray[n2 - 1])) {
                    stringArray[n2++] = "..";
                } else {
                    --n2;
                }
            } else if (!string.equals(".") || n == 1) {
                stringArray[n2++] = string;
            }
            ++n3;
        }
        if (n2 == n) {
            return;
        }
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        this.segments = stringArray2;
    }

    private String collapseSlashes(String string) {
        int n = string.length();
        if (n < 3) {
            return string;
        }
        if (string.indexOf("//", 1) == -1) {
            return string;
        }
        char[] cArray = new char[string.length()];
        int n2 = 0;
        boolean bl = false;
        char[] cArray2 = string.toCharArray();
        int n3 = 0;
        while (n3 < cArray2.length) {
            char c = cArray2[n3];
            if (c == '/') {
                if (bl) {
                    if (this.device == null && n3 == 1) {
                        cArray[n2] = c;
                        ++n2;
                    }
                } else {
                    bl = true;
                    cArray[n2] = c;
                    ++n2;
                }
            } else {
                bl = false;
                cArray[n2] = c;
                ++n2;
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    private int computeHashCode() {
        int n = this.device == null ? 17 : this.device.hashCode();
        int n2 = this.segments.length;
        int n3 = 0;
        while (n3 < n2) {
            n = n * 37 + this.segments[n3].hashCode();
            ++n3;
        }
        return n;
    }

    private int computeLength() {
        int n;
        int n2 = 0;
        if (this.device != null) {
            n2 += this.device.length();
        }
        if ((this.separators & 1) != 0) {
            ++n2;
        }
        if ((this.separators & 2) != 0) {
            ++n2;
        }
        if ((n = this.segments.length) > 0) {
            int n3 = 0;
            while (n3 < n) {
                n2 += this.segments[n3].length();
                ++n3;
            }
            n2 += n - 1;
        }
        if ((this.separators & 4) != 0) {
            ++n2;
        }
        return n2;
    }

    private int computeSegmentCount(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0 || n2 == 1 && string.charAt(0) == '/') {
            return 0;
        }
        int n3 = 1;
        int n4 = -1;
        while ((n = string.indexOf(47, n4 + 1)) != -1) {
            if (n != n4 + 1 && n != n2) {
                ++n3;
            }
            n4 = n;
        }
        if (string.charAt(n2 - 1) == '/') {
            --n3;
        }
        return n3;
    }

    private String[] computeSegments(String string) {
        int n;
        int n2 = this.computeSegmentCount(string);
        if (n2 == 0) {
            return NO_SEGMENTS;
        }
        String[] stringArray = new String[n2];
        int n3 = string.length();
        int n4 = n = string.charAt(0) == '/' ? 1 : 0;
        if (n == 1 && n3 > 1 && string.charAt(1) == '/') {
            n = 2;
        }
        int n5 = string.charAt(n3 - 1) != '/' ? n3 - 1 : n3 - 2;
        int n6 = n;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = n6;
            int n9 = string.indexOf(47, n6);
            stringArray[n7] = n9 == -1 ? string.substring(n8, n5 + 1) : string.substring(n8, n9);
            n6 = n9 + 1;
            ++n7;
        }
        return stringArray;
    }

    private void encodeSegment(String string, StringBuffer stringBuffer) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            stringBuffer.append(c);
            if (c == ':') {
                stringBuffer.append(':');
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object var1_1) {
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof Path)) {
            return false;
        }
        var2_2 = (Path)var1_1;
        if ((this.separators & -5) != (var2_2.separators & -5)) {
            return false;
        }
        var4_4 = this.segments.length;
        var3_3 = var2_2.segments;
        if (var4_4 == var3_3.length) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.segments[var4_4].equals(var3_3[var4_4])) continue;
            return false;
lbl14:
            // 2 sources

            ** while (--var4_4 >= 0)
        }
lbl15:
        // 1 sources

        return this.device == var2_2.device || this.device != null && this.device.equals(var2_2.device) != false;
    }

    public String getDevice() {
        return this.device;
    }

    public String getFileExtension() {
        if (this.hasTrailingSeparator()) {
            return null;
        }
        String string = this.lastSegment();
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public int hashCode() {
        return this.separators & 0xFFFFFFFB;
    }

    public boolean hasTrailingSeparator() {
        return (this.separators & 4) != 0;
    }

    private IPath initialize(String string, String string2) {
        Assert.isNotNull(string2);
        this.device = string;
        string2 = this.collapseSlashes(string2);
        int n = string2.length();
        if (n < 2) {
            this.separators = n == 1 && string2.charAt(0) == '/' ? 1 : 0;
        } else {
            boolean bl = string2.charAt(0) == '/';
            boolean bl2 = bl && string2.charAt(1) == '/';
            boolean bl3 = (!bl2 || n != 2) && string2.charAt(n - 1) == '/';
            int n2 = this.separators = bl ? 1 : 0;
            if (bl2) {
                this.separators |= 2;
            }
            if (bl3) {
                this.separators |= 4;
            }
        }
        this.segments = this.computeSegments(string2);
        if (!this.canonicalize()) {
            this.separators = this.separators & 7 | this.computeHashCode() << 3;
        }
        return this;
    }

    public boolean isAbsolute() {
        return (this.separators & 1) != 0;
    }

    public boolean isEmpty() {
        return this.segments.length == 0 && (this.separators & 7) != 1;
    }

    public boolean isPrefixOf(IPath iPath) {
        if (this.device == null ? iPath.getDevice() != null : !this.device.equalsIgnoreCase(iPath.getDevice())) {
            return false;
        }
        if (this.isEmpty() || this.isRoot() && iPath.isAbsolute()) {
            return true;
        }
        int n = this.segments.length;
        if (n > iPath.segmentCount()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.segments[n2].equals(iPath.segment(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isRoot() {
        return this == ROOT || this.segments.length == 0 && (this.separators & 7) == 1;
    }

    public boolean isUNC() {
        if (this.device != null) {
            return false;
        }
        return (this.separators & 2) != 0;
    }

    public boolean isValidPath(String string) {
        Path path = new Path(string);
        int n = 0;
        int n2 = path.segmentCount();
        while (n < n2) {
            if (!this.isValidSegment(path.segment(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isValidSegment(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '/') {
                return false;
            }
            if (WINDOWS && (c == '\\' || c == ':')) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String lastSegment() {
        int n = this.segments.length;
        return n == 0 ? null : this.segments[n - 1];
    }

    public IPath makeAbsolute() {
        String string;
        if (this.isAbsolute()) {
            return this;
        }
        Path path = new Path(this.device, this.segments, this.separators | 1);
        if (path.segmentCount() > 0 && ((string = path.segment(0)).equals("..") || string.equals("."))) {
            path.canonicalize();
        }
        return path;
    }

    public IPath makeRelative() {
        if (!this.isAbsolute()) {
            return this;
        }
        return new Path(this.device, this.segments, this.separators & 4);
    }

    public IPath makeUNC(boolean bl) {
        if (!(bl ^ this.isUNC())) {
            return this;
        }
        int n = this.separators;
        n = bl ? (n |= 3) : (n &= 5);
        return new Path(bl ? null : this.device, this.segments, n);
    }

    public int matchingFirstSegments(IPath iPath) {
        Assert.isNotNull(iPath);
        int n = iPath.segmentCount();
        int n2 = Math.min(this.segments.length, n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (!this.segments[n4].equals(iPath.segment(n4))) {
                return n3;
            }
            ++n3;
            ++n4;
        }
        return n3;
    }

    public IPath removeFileExtension() {
        String string = this.getFileExtension();
        if (string == null || string.equals(EMPTY_STRING)) {
            return this;
        }
        String string2 = this.lastSegment();
        int n = string2.lastIndexOf(string) - 1;
        return this.removeLastSegments(1).append(string2.substring(0, n));
    }

    public IPath removeFirstSegments(int n) {
        if (n == 0) {
            return this;
        }
        if (n >= this.segments.length) {
            return new Path(this.device, NO_SEGMENTS, 0);
        }
        Assert.isLegal(n > 0);
        int n2 = this.segments.length - n;
        String[] stringArray = new String[n2];
        System.arraycopy(this.segments, n, stringArray, 0, n2);
        return new Path(this.device, stringArray, this.separators & 4);
    }

    public IPath removeLastSegments(int n) {
        if (n == 0) {
            return this;
        }
        if (n >= this.segments.length) {
            return new Path(this.device, NO_SEGMENTS, this.separators & 3);
        }
        Assert.isLegal(n > 0);
        int n2 = this.segments.length - n;
        String[] stringArray = new String[n2];
        System.arraycopy(this.segments, 0, stringArray, 0, n2);
        return new Path(this.device, stringArray, this.separators);
    }

    public IPath removeTrailingSeparator() {
        if (!this.hasTrailingSeparator()) {
            return this;
        }
        return new Path(this.device, this.segments, this.separators & 3);
    }

    public String segment(int n) {
        if (n >= this.segments.length) {
            return null;
        }
        return this.segments[n];
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public String[] segments() {
        String[] stringArray = new String[this.segments.length];
        System.arraycopy(this.segments, 0, stringArray, 0, this.segments.length);
        return stringArray;
    }

    public IPath setDevice(String string) {
        if (string != null) {
            Assert.isTrue(string.indexOf(58) == string.length() - 1, "Last character should be the device separator");
        }
        if (string == this.device || string != null && string.equals(this.device)) {
            return this;
        }
        return new Path(string, this.segments, this.separators);
    }

    public File toFile() {
        return new File(this.toOSString());
    }

    public String toOSString() {
        int n;
        int n2 = this.computeLength();
        if (n2 <= 0) {
            return EMPTY_STRING;
        }
        char c = File.separatorChar;
        char[] cArray = new char[n2];
        int n3 = 0;
        if (this.device != null) {
            n = this.device.length();
            this.device.getChars(0, n, cArray, n3);
            n3 += n;
        }
        if ((this.separators & 1) != 0) {
            cArray[n3++] = c;
        }
        if ((this.separators & 2) != 0) {
            cArray[n3++] = c;
        }
        if ((n = this.segments.length - 1) >= 0) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.segments[n4].length();
                this.segments[n4].getChars(0, n5, cArray, n3);
                n3 += n5;
                cArray[n3++] = c;
                ++n4;
            }
            n4 = this.segments[n].length();
            this.segments[n].getChars(0, n4, cArray, n3);
            n3 += n4;
        }
        if ((this.separators & 4) != 0) {
            cArray[n3++] = c;
        }
        return new String(cArray);
    }

    public String toPortableString() {
        int n = this.computeLength();
        if (n <= 0) {
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        if (this.device != null) {
            stringBuffer.append(this.device);
        }
        if ((this.separators & 1) != 0) {
            stringBuffer.append('/');
        }
        if ((this.separators & 2) != 0) {
            stringBuffer.append('/');
        }
        int n2 = this.segments.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.segments[n3].indexOf(58) >= 0) {
                this.encodeSegment(this.segments[n3], stringBuffer);
            } else {
                stringBuffer.append(this.segments[n3]);
            }
            if (n3 < n2 - 1 || (this.separators & 4) != 0) {
                stringBuffer.append('/');
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        int n;
        int n2 = this.computeLength();
        if (n2 <= 0) {
            return EMPTY_STRING;
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        if (this.device != null) {
            n = this.device.length();
            this.device.getChars(0, n, cArray, n3);
            n3 += n;
        }
        if ((this.separators & 1) != 0) {
            cArray[n3++] = 47;
        }
        if ((this.separators & 2) != 0) {
            cArray[n3++] = 47;
        }
        if ((n = this.segments.length - 1) >= 0) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.segments[n4].length();
                this.segments[n4].getChars(0, n5, cArray, n3);
                n3 += n5;
                cArray[n3++] = 47;
                ++n4;
            }
            n4 = this.segments[n].length();
            this.segments[n].getChars(0, n4, cArray, n3);
            n3 += n4;
        }
        if ((this.separators & 4) != 0) {
            cArray[n3++] = 47;
        }
        return new String(cArray);
    }

    public IPath uptoSegment(int n) {
        if (n == 0) {
            return new Path(this.device, NO_SEGMENTS, this.separators & 3);
        }
        if (n >= this.segments.length) {
            return this;
        }
        Assert.isTrue(n > 0, "Invalid parameter to Path.uptoSegment");
        String[] stringArray = new String[n];
        System.arraycopy(this.segments, 0, stringArray, 0, n);
        return new Path(this.device, stringArray, this.separators);
    }
}

