/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PerformanceStatsProcessor
extends Job {
    private static final PerformanceStatsProcessor instance = new PerformanceStatsProcessor();
    private static final long SCHEDULE_DELAY = 2000L;
    private final ArrayList changes = new ArrayList();
    private final HashMap failures = new HashMap();
    private final ListenerList listeners = new ListenerList();
    private PlatformLogWriter log;
    static /* synthetic */ Class class$0;

    public static void addListener(PerformanceStats.PerformanceListener performanceListener) {
        PerformanceStatsProcessor.instance.listeners.add((Object)performanceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changed(PerformanceStats performanceStats) {
        PerformanceStatsProcessor performanceStatsProcessor = instance;
        synchronized (performanceStatsProcessor) {
            PerformanceStatsProcessor.instance.changes.add(performanceStats);
        }
        instance.schedule(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failed(PerformanceStats performanceStats, String string, long l) {
        PerformanceStatsProcessor performanceStatsProcessor = instance;
        synchronized (performanceStatsProcessor) {
            PerformanceStatsProcessor.instance.failures.put(performanceStats, new Long(l));
        }
        instance.schedule(2000L);
        instance.logFailure(performanceStats, string, l);
    }

    public static void printStats(PrintWriter printWriter) {
        PerformanceStats performanceStats;
        long l = 0L;
        int n = 0;
        PerformanceStats[] performanceStatsArray = PerformanceStats.getAllStats();
        int n2 = 0;
        while (n2 < performanceStatsArray.length) {
            performanceStats = performanceStatsArray[n2];
            l += performanceStats.getRunningTime();
            n += performanceStats.getRunCount();
            ++n2;
        }
        printWriter.println("---------------------------------------------------------------");
        n2 = 0;
        while (n2 < performanceStatsArray.length) {
            long l2;
            performanceStats = performanceStatsArray[n2];
            printWriter.print("Event: ");
            printWriter.print(performanceStats.getEvent());
            printWriter.print(" Blame: ");
            printWriter.print(performanceStats.getBlameString());
            if (performanceStats.getContext() != null) {
                printWriter.print(" Context: ");
                printWriter.print(performanceStats.getContext());
            }
            printWriter.println();
            int n3 = performanceStats.getRunCount();
            if (n3 > 0) {
                printWriter.print("Run count: ");
                printWriter.print(Integer.toString(n3));
                printWriter.print(" (");
                printWriter.print(Integer.toString((int)((double)n3 * 100.0 / (double)n)));
                printWriter.println(" % of total)");
            }
            if ((l2 = performanceStats.getRunningTime()) > 0L) {
                printWriter.print("Duration (ms): ");
                printWriter.print(Long.toString(l2));
                printWriter.print(" (");
                printWriter.print(Integer.toString((int)((double)l2 * 100.0 / (double)l)));
                printWriter.println(" % of total)");
            }
            printWriter.println("");
            ++n2;
        }
    }

    public static void removeListener(PerformanceStats.PerformanceListener performanceListener) {
        PerformanceStatsProcessor.instance.listeners.remove((Object)performanceListener);
    }

    private PerformanceStatsProcessor() {
        super("Performance Stats");
        this.setSystem(true);
        this.setPriority(50);
        BundleContext bundleContext = PlatformActivator.getContext();
        String string = "(performance=" + Boolean.TRUE.toString() + ')';
        FrameworkLog frameworkLog = null;
        try {
            ServiceReference[] serviceReferenceArray;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((serviceReferenceArray = bundleContext.getServiceReferences(clazz.getName(), string)) != null && serviceReferenceArray.length > 0) {
                frameworkLog = (FrameworkLog)bundleContext.getService(serviceReferenceArray[0]);
                IPath iPath = Platform.getLogFileLocation();
                iPath = iPath.removeLastSegments(1).append("performance.log");
                frameworkLog.setFile(iPath.toFile(), false);
            }
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.core.runtime", 1, "Error loading performance log", (Throwable)exception);
            InternalPlatform.getDefault().log((IStatus)status);
        }
        if (frameworkLog == null) {
            frameworkLog = InternalPlatform.getDefault().getFrameworkLog();
        }
        this.log = new PlatformLogWriter(frameworkLog);
    }

    private void logFailure(PerformanceStats performanceStats, String string, long l) {
        if (this.log == null) {
            return;
        }
        if (string == null) {
            string = "org.eclipse.core.runtime";
        }
        String string2 = "Performance failure: " + performanceStats.getEvent() + " blame: " + performanceStats.getBlameString() + " context: " + performanceStats.getContext() + " duration: " + l;
        this.log.logging((IStatus)new Status(2, string, 1, string2, (Throwable)new RuntimeException()), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        Object[] objectArray = this;
        synchronized (this) {
            PerformanceStats[] performanceStatsArray = this.changes.toArray(new PerformanceStats[this.changes.size()]);
            this.changes.clear();
            PerformanceStats[] performanceStatsArray2 = this.failures.keySet().toArray(new PerformanceStats[this.failures.size()]);
            Long[] longArray = this.failures.values().toArray(new Long[this.failures.size()]);
            this.failures.clear();
            // ** MonitorExit[var5_2] (shouldn't be in output)
            objectArray = this.listeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                PerformanceStats.PerformanceListener performanceListener = (PerformanceStats.PerformanceListener)objectArray[n];
                if (performanceStatsArray.length > 0) {
                    performanceListener.eventsOccurred(performanceStatsArray);
                }
                int n2 = 0;
                while (n2 < performanceStatsArray2.length) {
                    performanceListener.eventFailed(performanceStatsArray2[n2], longArray[n2]);
                    ++n2;
                }
                ++n;
            }
            this.schedule(2000L);
            return Status.OK_STATUS;
        }
    }

    public boolean shouldRun() {
        return !this.changes.isEmpty() || !this.failures.isEmpty();
    }
}

