/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DialogUtils;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";

    public MessageBox(Shell parent) {
        this(parent, 34);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, style);
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        if (this.parent.isDisposed()) {
            return 24;
        }
        int nativeButtonStyle = 0;
        if ((this.style & 0x20) == 32) {
            nativeButtonStyle |= 0x800;
        }
        if ((this.style & 0x100) == 256) {
            nativeButtonStyle |= 0x1000;
        }
        if ((this.style & 0x40) == 64) {
            nativeButtonStyle |= 0x2000;
        }
        if ((this.style & 0x80) == 128) {
            nativeButtonStyle |= 0x4000;
        }
        if ((this.style & 0x400) == 1024) {
            nativeButtonStyle |= 0x8000;
        }
        if (nativeButtonStyle == 0) {
            nativeButtonStyle = 2048;
        }
        int nativeIconStyle = 0;
        if ((this.style & 1) == 1) {
            nativeIconStyle = 262144;
        }
        if ((this.style & 2) == 2) {
            nativeIconStyle = 524288;
        }
        if ((this.style & 4) == 4) {
            nativeIconStyle = 0x100000;
        }
        if ((this.style & 8) == 8) {
            nativeIconStyle = 0x200000;
        }
        if ((this.style & 0x10) == 16) {
            nativeIconStyle = 0x400000;
        }
        int modalityStyle = DialogUtils.getNativeModalityStyle(this);
        int result = OS.MessageBox_Open(this.parent.internal_handle, nativeButtonStyle | nativeIconStyle | modalityStyle, DialogUtils.getNativeTitle(this), this.message);
        switch (result) {
            case 2048: {
                return 32;
            }
            case 4096: {
                return 256;
            }
            case 8192: {
                return 64;
            }
            case 16384: {
                return 128;
            }
            case 32768: {
                return 1024;
            }
        }
        return 256;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

