/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ResourceRegistry;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorRegistry
extends ResourceRegistry {
    protected Display display;
    private List staleColors = new ArrayList();
    private Map stringToColor = new HashMap(7);
    private Map stringToRGB = new HashMap(7);
    protected Runnable displayRunnable = new Runnable(){

        public void run() {
            ColorRegistry.this.clearCaches();
        }
    };

    public ColorRegistry() {
        this(Display.getCurrent(), true);
    }

    public ColorRegistry(Display display) {
        this(display, true);
    }

    public ColorRegistry(Display display, boolean bl) {
        Assert.isNotNull(display);
        this.display = display;
        if (bl) {
            this.hookDisplayDispose();
        }
    }

    private Color createColor(RGB rGB) {
        return new Color((Device)this.display, rGB);
    }

    private void disposeColors(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ((Color)e).dispose();
        }
    }

    public Color get(String string) {
        Assert.isNotNull(string);
        Object v = this.stringToColor.get(string);
        if (v != null) {
            return (Color)v;
        }
        Color color = null;
        v = this.stringToRGB.get(string);
        if (v == null) {
            return null;
        }
        color = this.createColor((RGB)v);
        this.stringToColor.put(string, color);
        return color;
    }

    public Set getKeySet() {
        return Collections.unmodifiableSet(this.stringToRGB.keySet());
    }

    public RGB getRGB(String string) {
        Assert.isNotNull(string);
        return (RGB)this.stringToRGB.get(string);
    }

    public ColorDescriptor getColorDescriptor(String string) {
        return ColorDescriptor.createFrom(this.getRGB(string));
    }

    protected void clearCaches() {
        this.disposeColors(this.stringToColor.values().iterator());
        this.disposeColors(this.staleColors.iterator());
        this.stringToColor.clear();
        this.staleColors.clear();
    }

    public boolean hasValueFor(String string) {
        return this.stringToRGB.containsKey(string);
    }

    private void hookDisplayDispose() {
        this.display.disposeExec(this.displayRunnable);
    }

    public void put(String string, RGB rGB) {
        this.put(string, rGB, true);
    }

    private void put(String string, RGB rGB, boolean bl) {
        Assert.isNotNull(string);
        Assert.isNotNull(rGB);
        RGB rGB2 = (RGB)this.stringToRGB.get(string);
        if (rGB.equals((Object)rGB2)) {
            return;
        }
        Color color = (Color)this.stringToColor.remove(string);
        this.stringToRGB.put(string, rGB);
        if (bl) {
            this.fireMappingChanged(string, rGB2, rGB);
        }
        if (color != null) {
            this.staleColors.add(color);
        }
    }
}

