/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewLayoutRec;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class Perspective {
    private PerspectiveDescriptor descriptor;
    protected WorkbenchPage page;
    protected LayoutPart editorArea;
    private PartPlaceholder editorHolder;
    private ViewFactory viewFactory;
    private ArrayList visibleActionSets;
    private ArrayList alwaysOnActionSets;
    private ArrayList alwaysOffActionSets;
    private ArrayList newWizardShortcuts;
    private ArrayList showViewShortcuts;
    private ArrayList perspectiveShortcuts;
    private ArrayList fastViews;
    private Map mapIDtoViewLayoutRec;
    private boolean fixed;
    private ArrayList showInPartIds;
    private HashMap showInTimes = new HashMap();
    private IViewReference activeFastView;
    private IMemento memento;
    protected PerspectiveHelper presentation;
    private static final String VERSION_STRING = "0.016";
    private static final int FASTVIEW_HIDE_STEPS = 5;
    private IWorkbenchPartReference oldPartRef = null;
    private boolean shouldHideEditorsOnActivate = false;

    public Perspective(PerspectiveDescriptor desc, WorkbenchPage page) throws WorkbenchException {
        this(page);
        this.descriptor = desc;
        if (desc != null) {
            this.createPresentation(desc);
        }
    }

    protected Perspective(WorkbenchPage page) throws WorkbenchException {
        this.page = page;
        this.viewFactory = page.getViewFactory();
        this.visibleActionSets = new ArrayList(2);
        this.alwaysOnActionSets = new ArrayList(2);
        this.alwaysOffActionSets = new ArrayList(2);
        this.fastViews = new ArrayList(2);
        this.mapIDtoViewLayoutRec = new HashMap();
    }

    public void addFastView(IViewReference ref) {
        ViewPane pane = (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
        if (!this.isFastView(ref)) {
            if (this.presentation.hasPlaceholder(ref.getId(), ref.getSecondaryId()) || pane.getContainer() != null) {
                this.presentation.removePart(pane);
            }
            this.fastViews.add(ref);
            pane.setFast(true);
            Control ctrl = pane.getControl();
            if (ctrl != null) {
                ctrl.setEnabled(false);
            }
        }
    }

    public boolean bringToTop(IViewReference ref) {
        return this.presentation.bringPartToTop(this.getPane(ref));
    }

    public boolean containsView(IViewPart view) {
        IViewSite site = view.getViewSite();
        IViewReference ref = this.findView(site.getId(), site.getSecondaryId());
        if (ref == null) {
            return false;
        }
        return view == ref.getPart(false);
    }

    private void createInitialActionSets(List stringList) {
    }

    private void createPresentation(PerspectiveDescriptor persp) throws WorkbenchException {
        if (persp.hasCustomDefinition()) {
            this.loadCustomPersp(persp);
        } else {
            this.loadPredefinedPersp(persp);
        }
    }

    public void dispose() {
        if (this.presentation == null) {
            return;
        }
        this.presentation.deactivate();
        IViewReference[] refs = this.getViewReferences();
        int i = 0;
        int length = refs.length;
        while (i < length) {
            this.getViewFactory().releaseView(refs[i]);
            ++i;
        }
        this.mapIDtoViewLayoutRec.clear();
    }

    public IViewReference findView(String viewId) {
        return this.findView(viewId, null);
    }

    public IViewReference findView(String id, String secondaryId) {
        IViewReference[] refs = this.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IViewReference ref = refs[i];
            if (id.equals(ref.getId()) && (secondaryId == null ? ref.getSecondaryId() == null : secondaryId.equals(ref.getSecondaryId()))) {
                return ref;
            }
            ++i;
        }
        return null;
    }

    private Composite getClientComposite() {
        return this.page.getClientComposite();
    }

    public IPerspectiveDescriptor getDesc() {
        return this.descriptor;
    }

    Rectangle getFastViewBounds(IViewReference ref) {
        Rectangle bounds = this.page.getClientComposite().getBounds();
        float ratio = this.getFastViewWidthRatio(ref);
        bounds.width = (int)(ratio * (float)this.getClientComposite().getSize().x);
        return bounds;
    }

    public IViewReference[] getFastViews() {
        IViewReference[] array = new IViewReference[this.fastViews.size()];
        this.fastViews.toArray(array);
        return array;
    }

    public String[] getNewWizardShortcuts() {
        return this.newWizardShortcuts.toArray(new String[this.newWizardShortcuts.size()]);
    }

    private ViewPane getPane(IViewReference ref) {
        return (ViewPane)((WorkbenchPartReference)((Object)ref)).getPane();
    }

    public String[] getPerspectiveShortcuts() {
        return this.perspectiveShortcuts.toArray(new String[this.perspectiveShortcuts.size()]);
    }

    public PerspectiveHelper getPresentation() {
        return this.presentation;
    }

    private float getFastViewWidthRatio(IViewReference ref) {
        ViewLayoutRec rec = this.getViewLayoutRec(ref, true);
        if (rec.fastViewWidthRatio == -1.0f) {
            IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
            IViewDescriptor desc = reg.find(ref.getId());
            rec.fastViewWidthRatio = desc != null ? desc.getFastViewWidthRatio() : 0.3f;
        }
        return rec.fastViewWidthRatio;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPartIds;
    }

    public long getShowInTime(String partId) {
        Long t = (Long)this.showInTimes.get(partId);
        return t == null ? 0L : t;
    }

    public String[] getShowViewShortcuts() {
        return this.showViewShortcuts.toArray(new String[this.showViewShortcuts.size()]);
    }

    private ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public IViewReference[] getViewReferences() {
        if (this.presentation == null) {
            return new IViewReference[0];
        }
        ArrayList panes = new ArrayList(5);
        this.presentation.collectViewPanes(panes);
        IViewReference[] resultArray = new IViewReference[panes.size() + this.fastViews.size()];
        int nView = 0;
        int i = 0;
        while (i < this.fastViews.size()) {
            resultArray[nView] = (IViewReference)this.fastViews.get(i);
            ++nView;
            ++i;
        }
        i = 0;
        while (i < panes.size()) {
            ViewPane pane = (ViewPane)panes.get(i);
            resultArray[nView] = pane.getViewReference();
            ++nView;
            ++i;
        }
        return resultArray;
    }

    public void hideActionSet(String id) {
    }

    protected void hideEditorArea() {
        if (!this.isEditorAreaVisible()) {
            return;
        }
    }

    public boolean hideView(IViewReference ref) {
        ViewPane pane = this.getPane(ref);
        if (this.isFastView(ref)) {
            this.fastViews.remove(ref);
            if (pane != null) {
                pane.setFast(false);
            }
            if (pane != null) {
                pane.getControl().setEnabled(true);
            }
        } else {
            this.presentation.removePart(pane);
        }
        this.getViewFactory().releaseView(ref);
        return true;
    }

    protected boolean isEditorAreaVisible() {
        return this.editorHolder == null;
    }

    public boolean isFastView(IViewReference ref) {
        return this.fastViews.contains(ref);
    }

    private ViewLayoutRec getViewLayoutRec(IViewReference ref, boolean create) {
        return this.getViewLayoutRec(ViewFactory.getKey(ref), create);
    }

    private ViewLayoutRec getViewLayoutRec(String viewId, boolean create) {
        ViewLayoutRec rec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(viewId);
        if (rec == null && create) {
            rec = new ViewLayoutRec();
            this.mapIDtoViewLayoutRec.put(viewId, rec);
        }
        return rec;
    }

    public boolean isFixedLayout() {
        return this.fixed;
    }

    public boolean isStandaloneView(IViewReference ref) {
        ViewLayoutRec rec = this.getViewLayoutRec(ref, false);
        return rec != null && rec.isStandalone;
    }

    public boolean getShowTitleView(IViewReference ref) {
        ViewLayoutRec rec = this.getViewLayoutRec(ref, false);
        return rec != null && rec.showTitle;
    }

    private void loadCustomPersp(PerspectiveDescriptor persp) {
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        try {
            IMemento memento = perspRegistry.getCustomPersp(persp.getId());
            MultiStatus status = new MultiStatus("org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_unableToRestorePerspective, (Object)persp.getLabel()), null);
            status.merge(this.restoreState(memento));
            status.merge(this.restoreState());
            if (status.getSeverity() != 0) {
                this.unableToOpenPerspective(persp, (IStatus)status);
            }
        }
        catch (IOException iOException) {
            this.unableToOpenPerspective(persp, null);
        }
        catch (WorkbenchException e) {
            this.unableToOpenPerspective(persp, e.getStatus());
        }
    }

    private void unableToOpenPerspective(PerspectiveDescriptor persp, IStatus status) {
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        perspRegistry.deletePerspective(persp);
        persp.deleteCustomDefinition();
        String title = WorkbenchMessages.Perspective_problemRestoringTitle;
        String msg = WorkbenchMessages.Perspective_errorReadingState;
        if (status == null) {
            ShowMessage.openError(null, title, msg);
        } else {
            ShowMessage.printError(msg, status);
        }
    }

    private void loadPredefinedPersp(PerspectiveDescriptor persp) throws WorkbenchException {
        IPerspectiveFactory factory = null;
        try {
            factory = persp.createFactory();
        }
        catch (CoreException coreException) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Perspective_unableToLoad, (Object)persp.getId()));
        }
        if (factory == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.Perspective_unableToLoad, (Object)persp.getId()));
        }
        ViewSashContainer container = new ViewSashContainer(this.page);
        PageLayout layout = new PageLayout(container, this.getViewFactory(), this.editorArea, this.descriptor);
        layout.setFixed(this.descriptor.getFixed());
        factory.createInitialLayout(layout);
        this.mapIDtoViewLayoutRec.putAll(layout.getIDtoViewLayoutRecMap());
        this.createInitialActionSets(layout.getActionSets());
        this.alwaysOnActionSets.addAll(this.visibleActionSets);
        this.showViewShortcuts = layout.getShowViewShortcuts();
        this.perspectiveShortcuts = layout.getPerspectiveShortcuts();
        this.showInPartIds = layout.getShowInPartIds();
        this.fixed = layout.isFixed();
        this.presentation = new PerspectiveHelper(this.page, container, this);
        if (!layout.isEditorAreaVisible()) {
            this.hideEditorArea();
        }
    }

    protected void onActivate() {
        this.presentation.activate(this.getClientComposite());
    }

    protected void onDeactivate() {
        this.presentation.deactivate();
        this.setAllPinsVisible(false);
        int i = 0;
        while (i < this.fastViews.size()) {
            Control ctrl;
            ViewPane pane = this.getPane((IViewReference)this.fastViews.get(i));
            if (pane != null && (ctrl = pane.getControl()) != null) {
                ctrl.setEnabled(true);
            }
            ++i;
        }
    }

    public void partActivated(IWorkbenchPart activePart) {
    }

    public void performedShowIn(String partId) {
        this.showInTimes.put(partId, new Long(System.currentTimeMillis()));
    }

    public IStatus restoreState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringPerspective, null);
        this.descriptor = new PerspectiveDescriptor(null, null, null);
        result.add(this.descriptor.restoreState(memento));
        PerspectiveDescriptor desc = (PerspectiveDescriptor)WorkbenchPlugin.getDefault().getPerspectiveRegistry().findPerspectiveWithId(this.descriptor.getId());
        if (desc != null) {
            this.descriptor = desc;
        }
        this.memento = memento;
        IMemento[] views = memento.getChildren("view");
        result.merge(this.createReferences(views));
        memento = memento.getChild("fastViews");
        if (memento != null) {
            views = memento.getChildren("view");
            result.merge(this.createReferences(views));
        }
        return result;
    }

    private IStatus createReferences(IMemento[] views) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringViews, null);
        int x = 0;
        while (x < views.length) {
            IMemento childMem = views[x];
            String id = childMem.getString("id");
            String secondaryId = ViewFactory.extractSecondaryId(id);
            if (secondaryId != null) {
                id = ViewFactory.extractPrimaryId(id);
            }
            try {
                if (!"true".equals(childMem.getString("removed"))) {
                    this.viewFactory.createView(id, secondaryId);
                }
            }
            catch (PartInitException e) {
                childMem.putString("removed", "true");
                result.add(StatusUtil.newStatus(4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)((Object)e)));
            }
            ++x;
        }
        return result;
    }

    public IStatus restoreState() {
        String id;
        if (this.memento == null) {
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsRestoringPerspective, null);
        IMemento memento = this.memento;
        this.memento = null;
        IMemento boundsMem = memento.getChild("org.eclipse.jface.window");
        if (boundsMem != null) {
            Rectangle r = new Rectangle(0, 0, 0, 0);
            r.x = boundsMem.getInteger("x");
            r.y = boundsMem.getInteger("y");
            r.height = boundsMem.getInteger("height");
            r.width = boundsMem.getInteger("width");
            if (this.page.getWorkbenchWindow().getPages().length == 0) {
                this.page.getWorkbenchWindow().getShell().setBounds(r);
            }
        }
        ViewSashContainer mainLayout = new ViewSashContainer(this.page);
        PerspectiveHelper pres = new PerspectiveHelper(this.page, mainLayout, this);
        result.merge(pres.restoreState(memento.getChild("layout")));
        pres.replacePlaceholderWithPart(this.editorArea);
        IMemento[] views = memento.getChildren("view");
        int x = 0;
        while (x < views.length) {
            IViewReference viewRef;
            WorkbenchPartReference ref;
            IMemento childMem = views[x];
            String id2 = childMem.getString("id");
            String secondaryId = ViewFactory.extractSecondaryId(id2);
            if (secondaryId != null) {
                id2 = ViewFactory.extractPrimaryId(id2);
            }
            if ((ref = (WorkbenchPartReference)((Object)(viewRef = this.viewFactory.getView(id2, secondaryId)))) == null) {
                String key = ViewFactory.getKey(id2, secondaryId);
                result.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_couldNotFind, (Object)key), null));
            } else {
                this.page.addPart(ref);
                boolean willPartBeVisible = pres.willPartBeVisible(ref.getId(), secondaryId);
                if (willPartBeVisible) {
                    IStatus restoreStatus = this.viewFactory.restoreView(viewRef);
                    result.add(restoreStatus);
                    if (restoreStatus.getSeverity() == 0) {
                        IViewPart view = (IViewPart)ref.getPart(true);
                        if (view != null) {
                            ViewSite site = (ViewSite)view.getSite();
                            ViewPane pane = (ViewPane)site.getPane();
                            pres.replacePlaceholderWithPart(pane);
                        }
                    } else {
                        this.page.removePart(ref);
                    }
                } else {
                    pres.replacePlaceholderWithPart(ref.getPane());
                }
            }
            ++x;
        }
        IMemento fastViewsMem = memento.getChild("fastViews");
        if (fastViewsMem != null) {
            views = fastViewsMem.getChildren("view");
            int x2 = 0;
            while (x2 < views.length) {
                IViewReference viewRef;
                WorkbenchPartReference ref;
                IMemento childMem = views[x2];
                String viewID = childMem.getString("id");
                String secondaryId = ViewFactory.extractSecondaryId(viewID);
                if (secondaryId != null) {
                    viewID = ViewFactory.extractPrimaryId(viewID);
                }
                if ((ref = (WorkbenchPartReference)((Object)(viewRef = this.viewFactory.getView(viewID, secondaryId)))) == null) {
                    String key = ViewFactory.getKey(viewID, secondaryId);
                    WorkbenchPlugin.log("Could not create view: '" + key + "'.");
                    result.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.Perspective_couldNotFind, (Object)key), null));
                } else {
                    Float ratio = childMem.getFloat("ratio");
                    if (ratio == null) {
                        Integer viewWidth = childMem.getInteger("width");
                        ratio = viewWidth == null ? new Float(0.3f) : new Float((float)viewWidth.intValue() / (float)this.getClientComposite().getSize().x);
                    }
                    ViewLayoutRec rec = this.getViewLayoutRec(viewRef, true);
                    rec.fastViewWidthRatio = ratio.floatValue();
                    this.fastViews.add(ref);
                    this.page.addPart(ref);
                }
                ++x2;
            }
        }
        IMemento[] recMementos = memento.getChildren("viewLayoutRec");
        int i = 0;
        while (i < recMementos.length) {
            IMemento recMemento = recMementos[i];
            String compoundId = recMemento.getString("id");
            if (compoundId != null) {
                ViewLayoutRec rec = this.getViewLayoutRec(compoundId, true);
                if ("false".equals(recMemento.getString("closeable"))) {
                    rec.isCloseable = false;
                }
                if ("false".equals(recMemento.getString("moveable"))) {
                    rec.isMoveable = false;
                }
                if ("true".equals(recMemento.getString("standalone"))) {
                    rec.isStandalone = true;
                    rec.showTitle = !"false".equals(recMemento.getString("showTitle"));
                }
            }
            ++i;
        }
        HashSet<String> knownActionSetIds = new HashSet<String>();
        IMemento[] actions = memento.getChildren("actionSet");
        ArrayList<String> actionsArray = new ArrayList<String>(actions.length);
        int x3 = 0;
        while (x3 < actions.length) {
            String actionSetID = actions[x3].getString("id");
            actionsArray.add(actionSetID);
            knownActionSetIds.add(actionSetID);
            ++x3;
        }
        this.createInitialActionSets(actionsArray);
        actions = memento.getChildren("show_view_action");
        this.showViewShortcuts = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.showViewShortcuts.add(id);
            ++x3;
        }
        actions = memento.getChildren("show_in_time");
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            String timeStr = actions[x3].getString("time");
            if (id != null && timeStr != null) {
                try {
                    long time = Long.parseLong(timeStr);
                    this.showInTimes.put(id, new Long(time));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++x3;
        }
        this.showInPartIds = this.getShowInIdsFromRegistry();
        actions = memento.getChildren("new_wizard_action");
        this.newWizardShortcuts = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.newWizardShortcuts.add(id);
            ++x3;
        }
        actions = memento.getChildren("perspective_action");
        this.perspectiveShortcuts = new ArrayList(actions.length);
        x3 = 0;
        while (x3 < actions.length) {
            id = actions[x3].getString("id");
            this.perspectiveShortcuts.add(id);
            ++x3;
        }
        ArrayList extActionSets = this.getPerspectiveExtensionActionSets();
        int i2 = 0;
        while (i2 < extActionSets.size()) {
            String actionSetID = (String)extActionSets.get(i2);
            if (knownActionSetIds.contains(actionSetID)) {
                // empty if block
            }
            ++i2;
        }
        this.presentation = pres;
        Integer areaVisible = memento.getInteger("editorAreaVisible");
        this.shouldHideEditorsOnActivate = areaVisible != null && areaVisible == 0;
        Integer isFixed = memento.getInteger("fixed");
        this.fixed = isFixed != null && isFixed == 1;
        return result;
    }

    private ArrayList getPerspectiveExtensionActionSets() {
        PageLayout layout = new PageLayout();
        return layout.getActionSets();
    }

    private ArrayList getShowInIdsFromRegistry() {
        PageLayout layout = new PageLayout();
        return layout.getShowInPartIds();
    }

    public void saveDesc() {
        this.saveDescAs(this.descriptor);
    }

    public void saveDescAs(IPerspectiveDescriptor desc) {
        PerspectiveDescriptor realDesc = (PerspectiveDescriptor)desc;
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        XMLMemento memento = XMLMemento.createWriteRoot("perspective");
        IStatus status = this.saveState(memento, realDesc, false);
        if (status.getSeverity() == 4) {
            ShowMessage.printError(WorkbenchMessages.Perspective_problemSavingMessage, status);
            return;
        }
        try {
            perspRegistry.saveCustomPersp(realDesc, memento);
            this.descriptor = realDesc;
        }
        catch (IOException iOException) {
            perspRegistry.deletePerspective(realDesc);
            ShowMessage.openError(null, WorkbenchMessages.Perspective_problemSavingTitle, WorkbenchMessages.Perspective_problemSavingMessage);
        }
    }

    public IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsSavingPerspective, null);
        result.merge(this.saveState(memento, this.descriptor, true));
        return result;
    }

    private IStatus saveState(IMemento memento, PerspectiveDescriptor p, boolean saveInnerViewState) {
        IMemento childMem;
        IMemento viewMemento;
        IViewReference ref;
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Perspective_problemsSavingPerspective, null);
        if (this.memento != null) {
            memento.putMemento(this.memento);
            return result;
        }
        memento.putString("version", VERSION_STRING);
        result.add(p.saveState(memento));
        if (!saveInnerViewState) {
            Rectangle bounds = this.page.getWorkbenchWindow().getShell().getBounds();
            IMemento boundsMem = memento.createChild("org.eclipse.jface.window");
            boundsMem.putInteger("x", bounds.x);
            boundsMem.putInteger("y", bounds.y);
            boundsMem.putInteger("height", bounds.height);
            boundsMem.putInteger("width", bounds.width);
        }
        Iterator itr = this.showViewShortcuts.iterator();
        while (itr.hasNext()) {
            String str = (String)itr.next();
            IMemento child = memento.createChild("show_view_action");
            child.putString("id", str);
        }
        ArrayList viewPanes = new ArrayList(5);
        this.presentation.collectViewPanes(viewPanes);
        itr = viewPanes.iterator();
        int errors = 0;
        while (itr.hasNext()) {
            ViewPane pane = (ViewPane)itr.next();
            ref = pane.getViewReference();
            viewMemento = memento.createChild("view");
            viewMemento.putString("id", ViewFactory.getKey(ref));
        }
        if (this.fastViews.size() > 0) {
            childMem = memento.createChild("fastViews");
            itr = this.fastViews.iterator();
            while (itr.hasNext()) {
                ref = (IViewReference)itr.next();
                viewMemento = childMem.createChild("view");
                String id = ViewFactory.getKey(ref);
                viewMemento.putString("id", id);
                float ratio = this.getFastViewWidthRatio(ref);
                viewMemento.putFloat("ratio", ratio);
            }
        }
        Iterator i = this.mapIDtoViewLayoutRec.keySet().iterator();
        while (i.hasNext()) {
            String compoundId = (String)i.next();
            ViewLayoutRec rec = (ViewLayoutRec)this.mapIDtoViewLayoutRec.get(compoundId);
            if (rec == null || rec.isCloseable && rec.isMoveable && !rec.isStandalone) continue;
            IMemento layoutMemento = memento.createChild("viewLayoutRec");
            layoutMemento.putString("id", compoundId);
            if (!rec.isCloseable) {
                layoutMemento.putString("closeable", "false");
            }
            if (!rec.isMoveable) {
                layoutMemento.putString("moveable", "false");
            }
            if (!rec.isStandalone) continue;
            layoutMemento.putString("standalone", "true");
            layoutMemento.putString("showTitle", rec.showTitle ? "true" : "false");
        }
        if (errors > 0) {
            String message = WorkbenchMessages.Perspective_multipleErrors;
            if (errors == 1) {
                message = WorkbenchMessages.Perspective_oneError;
            }
            ShowMessage.openError(null, WorkbenchMessages.Error, message);
        }
        childMem = memento.createChild("layout");
        result.add(this.presentation.saveState(childMem));
        if (this.isEditorAreaVisible()) {
            memento.putInteger("editorAreaVisible", 1);
        } else {
            memento.putInteger("editorAreaVisible", 0);
        }
        if (this.fixed) {
            memento.putInteger("fixed", 1);
        } else {
            memento.putInteger("fixed", 0);
        }
        return result;
    }

    public IViewReference getActiveFastView() {
        return this.activeFastView;
    }

    private void setAllPinsVisible(boolean visible) {
        Iterator iter = this.fastViews.iterator();
        while (iter.hasNext()) {
            ViewPane pane = this.getPane((IViewReference)iter.next());
            if (pane == null) continue;
            pane.setFast(visible);
        }
    }

    public void setNewWizardActionIds(ArrayList newList) {
        this.newWizardShortcuts = newList;
    }

    public void setPerspectiveActionIds(ArrayList list) {
        this.perspectiveShortcuts = list;
    }

    public void setShowInPartIds(ArrayList list) {
        this.showInPartIds = list;
    }

    public void setShowViewActionIds(ArrayList list) {
        this.showViewShortcuts = list;
    }

    public void showActionSet(String id) {
    }

    protected void showEditorArea() {
        if (this.isEditorAreaVisible()) {
            return;
        }
        this.presentation.getLayout().replace(this.editorHolder, this.editorArea);
        this.editorHolder = null;
    }

    public IViewPart showView(String viewId, String secondaryId) throws PartInitException {
        ViewFactory factory = this.getViewFactory();
        IViewReference ref = factory.createView(viewId, secondaryId);
        IViewPart part = (IViewPart)ref.getPart(false);
        if (part == null) {
            IStatus status = factory.restoreView(ref);
            if (status.getSeverity() == 4) {
                if (status.getException() instanceof PartInitException) {
                    throw (PartInitException)((Object)status.getException());
                }
                throw new PartInitException(status);
            }
            part = (IViewPart)ref.getPart(false);
        }
        ViewSite site = (ViewSite)part.getSite();
        ViewPane pane = (ViewPane)site.getPane();
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        int openViewMode = store.getInt("OPEN_VIEW_MODE");
        if (this.presentation.hasPlaceholder(viewId, secondaryId)) {
            this.presentation.addPart(pane);
        } else if (openViewMode == 0) {
            this.presentation.addPart(pane);
        } else if (openViewMode == 2 && this.presentation.canDetach()) {
            this.presentation.addDetachedPart(pane);
        }
        return part;
    }

    public IWorkbenchPartReference getOldPartRef() {
        return this.oldPartRef;
    }

    public void setOldPartRef(IWorkbenchPartReference oldPartRef) {
        this.oldPartRef = oldPartRef;
    }

    void moveFastView(IViewReference draggedView, IViewReference destinationView) {
        if (draggedView == destinationView) {
            return;
        }
        int insertIdx = this.fastViews.indexOf(destinationView);
        this.fastViews.remove(draggedView);
        if (insertIdx < 0 || insertIdx >= this.fastViews.size()) {
            this.fastViews.add(draggedView);
        } else {
            this.fastViews.add(insertIdx, draggedView);
        }
    }

    public boolean isCloseable(IViewReference reference) {
        ViewLayoutRec rec = this.getViewLayoutRec(reference, false);
        if (rec != null) {
            return rec.isCloseable;
        }
        return true;
    }

    public boolean isMoveable(IViewReference reference) {
        ViewLayoutRec rec = this.getViewLayoutRec(reference, false);
        if (rec != null) {
            return rec.isMoveable;
        }
        return true;
    }

    public void describeLayout(StringBuffer buf) {
        IViewReference[] fastViews = this.getFastViews();
        if (fastViews.length != 0) {
            buf.append("fastviews (");
            int idx = 0;
            while (idx < fastViews.length) {
                IViewReference ref = fastViews[idx];
                if (idx > 0) {
                    buf.append(", ");
                }
                buf.append(ref.getPartName());
                ++idx;
            }
            buf.append("), ");
        }
        this.getPresentation().describeLayout(buf);
    }

    public void testInvariants() {
        this.getPresentation().getLayout().testInvariants();
    }
}

