/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.JobRoot;
import org.eclipse.update.internal.operations.UpdateUtils;

public abstract class OptionalFeatureOperation
extends FeatureOperation {
    IFeatureReference[] optionalFeatures;
    IFeature[] unconfiguredOptionalFeatures;

    public OptionalFeatureOperation(IConfiguredSite targetSite, IFeature feature) {
        super(targetSite, feature);
    }

    void preserveOptionalState() {
        if (this.unconfiguredOptionalFeatures == null) {
            return;
        }
        int i = 0;
        while (i < this.unconfiguredOptionalFeatures.length) {
            try {
                IFeature localFeature = UpdateUtils.getLocalFeature(this.targetSite, this.unconfiguredOptionalFeatures[i]);
                if (localFeature != null) {
                    this.targetSite.unconfigure(localFeature);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    void setOptionalFeatures() {
        try {
            if (this.optionalFeatures == null && UpdateUtils.hasOptionalFeatures(this.feature)) {
                JobRoot jobRoot = new JobRoot(this);
                IInstallConfiguration config = SiteManager.getLocalSite().getCurrentConfiguration();
                HashSet set = new HashSet();
                boolean update = this.oldFeature != null;
                boolean patch = UpdateUtils.isPatch(this.feature);
                FeatureHierarchyElement[] elements = jobRoot.getElements();
                int i = 0;
                while (i < elements.length) {
                    elements[i].addCheckedOptionalFeatures(update, patch, config, set);
                    ++i;
                }
                this.optionalFeatures = new IFeatureReference[set.size()];
                set.toArray(this.optionalFeatures);
                this.unconfiguredOptionalFeatures = jobRoot.getUnconfiguredOptionalFeatures(config, this.targetSite);
            }
        }
        catch (CoreException e) {
            UpdateUtils.logException(e);
        }
    }

    boolean isManagedOnly() {
        int policy = InstallConfiguration.getDefaultPolicy();
        return policy == 2;
    }
}

