/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.CategoryEvent;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.CommandManagerEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICategoryListener;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.ICommandManagerListener;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IExecutionListenerWithChecks;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterTypeListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterTypeEvent;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.HandleObjectManager;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ListenerList;

public final class CommandManager
extends HandleObjectManager
implements ICategoryListener,
ICommandListener,
IParameterTypeListener {
    public static final String AUTOGENERATED_CATEGORY_ID = "org.eclipse.core.commands.categories.autogenerated";
    static final char ESCAPE_CHAR = '%';
    static final char ID_VALUE_CHAR = '=';
    static final char PARAMETER_END_CHAR = ')';
    static final char PARAMETER_SEPARATOR_CHAR = ',';
    static final char PARAMETER_START_CHAR = '(';
    private final Map categoriesById = new HashMap();
    private final Set definedCategoryIds = new HashSet();
    private final Set definedParameterTypeIds = new HashSet();
    private IExecutionListenerWithChecks executionListener = null;
    private ListenerList executionListeners = null;
    private final Map helpContextIdsByHandler = new WeakHashMap();
    private final Map parameterTypesById = new HashMap();

    private static final String unescape(String string) throws SerializationException {
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < string.length()) {
            block8: {
                block9: {
                    char c;
                    block7: {
                        c = string.charAt(n);
                        if (c == '%') break block7;
                        if (stringBuffer != null) {
                            stringBuffer.append(c);
                        }
                        break block8;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.substring(0, n));
                    }
                    if (++n >= string.length()) break block9;
                    c = string.charAt(n);
                    switch (c) {
                        case '%': 
                        case '(': 
                        case ')': 
                        case ',': 
                        case '=': {
                            stringBuffer.append(c);
                            break block8;
                        }
                        default: {
                            throw new SerializationException("Invalid character '" + c + "' in escape sequence");
                        }
                    }
                }
                throw new SerializationException("Unexpected termination of escape sequence");
            }
            ++n;
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    public final void addCommandManagerListener(ICommandManagerListener iCommandManagerListener) {
        this.addListenerObject(iCommandManagerListener);
    }

    public final void addExecutionListener(IExecutionListener iExecutionListener) {
        if (iExecutionListener == null) {
            throw new NullPointerException("Cannot add a null execution listener");
        }
        if (this.executionListeners == null) {
            this.executionListeners = new ListenerList(1);
            this.executionListener = new ExecutionListener();
            Iterator iterator = this.handleObjectsById.values().iterator();
            while (iterator.hasNext()) {
                Command command = (Command)iterator.next();
                command.addExecutionListener(this.executionListener);
            }
        }
        this.executionListeners.add((Object)iExecutionListener);
    }

    public final void categoryChanged(CategoryEvent categoryEvent) {
        if (categoryEvent.isDefinedChanged()) {
            Category category = categoryEvent.getCategory();
            String string = category.getId();
            boolean bl = category.isDefined();
            if (bl) {
                this.definedCategoryIds.add(string);
            } else {
                this.definedCategoryIds.remove(string);
            }
            if (this.isListenerAttached()) {
                this.fireCommandManagerChanged(new CommandManagerEvent(this, null, false, false, string, bl, true));
            }
        }
    }

    public final void commandChanged(CommandEvent commandEvent) {
        if (commandEvent.isDefinedChanged()) {
            Command command = commandEvent.getCommand();
            String string = command.getId();
            boolean bl = command.isDefined();
            if (bl) {
                this.definedHandleObjects.add(command);
            } else {
                this.definedHandleObjects.remove(command);
            }
            if (this.isListenerAttached()) {
                this.fireCommandManagerChanged(new CommandManagerEvent(this, string, bl, true, null, false, false));
            }
        }
    }

    public final void defineUncategorizedCategory(String string, String string2) {
        Category category = this.getCategory(AUTOGENERATED_CATEGORY_ID);
        category.define(string, string2);
    }

    public final ParameterizedCommand deserialize(String string) throws NotDefinedException, SerializationException {
        String string2;
        String string3;
        int n = this.unescapedIndexOf(string, '(');
        if (n == -1) {
            string3 = string;
            string2 = null;
        } else {
            string3 = string.substring(0, n);
            if (string.charAt(string.length() - 1) != ')') {
                throw new SerializationException("Parentheses must be balanced in serialized ParameterizedCommand");
            }
            string2 = string.substring(n + 1, string.length() - 1);
        }
        String string4 = CommandManager.unescape(string3);
        Command command = this.getCommand(string4);
        IParameter[] iParameterArray = command.getParameters();
        Parameterization[] parameterizationArray = this.getParameterizations(string2, iParameterArray);
        return new ParameterizedCommand(command, parameterizationArray);
    }

    private final void fireCommandManagerChanged(CommandManagerEvent commandManagerEvent) {
        if (commandManagerEvent == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ICommandManagerListener iCommandManagerListener = (ICommandManagerListener)objectArray[n];
            iCommandManagerListener.commandManagerChanged(commandManagerEvent);
            ++n;
        }
    }

    public final Command[] getAllCommands() {
        return this.handleObjectsById.values().toArray(new Command[this.handleObjectsById.size()]);
    }

    public final Category getCategory(String string) {
        if (string == null) {
            return this.getCategory(AUTOGENERATED_CATEGORY_ID);
        }
        this.checkId(string);
        Category category = (Category)this.categoriesById.get(string);
        if (category == null) {
            category = new Category(string);
            this.categoriesById.put(string, category);
            category.addCategoryListener(this);
        }
        return category;
    }

    public final Command getCommand(String string) {
        this.checkId(string);
        Command command = (Command)this.handleObjectsById.get(string);
        if (command == null) {
            command = new Command(string);
            this.handleObjectsById.put(string, command);
            command.addCommandListener(this);
            if (this.executionListener != null) {
                command.addExecutionListener(this.executionListener);
            }
        }
        return command;
    }

    public final Category[] getDefinedCategories() {
        Category[] categoryArray = new Category[this.definedCategoryIds.size()];
        Iterator iterator = this.definedCategoryIds.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            categoryArray[n++] = this.getCategory(string);
        }
        return categoryArray;
    }

    public final Set getDefinedCategoryIds() {
        return Collections.unmodifiableSet(this.definedCategoryIds);
    }

    public final Set getDefinedCommandIds() {
        return this.getDefinedHandleObjectIds();
    }

    public final Command[] getDefinedCommands() {
        return this.definedHandleObjects.toArray(new Command[this.definedHandleObjects.size()]);
    }

    public final Set getDefinedParameterTypeIds() {
        return Collections.unmodifiableSet(this.definedParameterTypeIds);
    }

    public final ParameterType[] getDefinedParameterTypes() {
        ParameterType[] parameterTypeArray = new ParameterType[this.definedParameterTypeIds.size()];
        Iterator iterator = this.definedParameterTypeIds.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            parameterTypeArray[n++] = this.getParameterType(string);
        }
        return parameterTypeArray;
    }

    public final String getHelpContextId(Command command) throws NotDefinedException {
        String string;
        if (!command.isDefined()) {
            throw new NotDefinedException("The command is not defined. " + command.getId());
        }
        IHandler iHandler = command.getHandler();
        if (iHandler != null && (string = (String)this.helpContextIdsByHandler.get(iHandler)) != null) {
            return string;
        }
        return command.getHelpContextId();
    }

    private final Parameterization[] getParameterizations(String string, IParameter[] iParameterArray) throws SerializationException {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (iParameterArray == null || iParameterArray.length == 0) {
            return null;
        }
        ArrayList<Parameterization> arrayList = new ArrayList<Parameterization>();
        block0: do {
            String string2;
            String string3;
            String string4;
            if ((n = this.unescapedIndexOf(string, ',')) == -1) {
                string4 = string;
            } else {
                string4 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            int n2 = this.unescapedIndexOf(string4, '=');
            if (n2 == -1) {
                string3 = CommandManager.unescape(string4);
                string2 = null;
            } else {
                string3 = CommandManager.unescape(string4.substring(0, n2));
                string2 = CommandManager.unescape(string4.substring(n2 + 1));
            }
            int n3 = 0;
            while (n3 < iParameterArray.length) {
                IParameter iParameter = iParameterArray[n3];
                if (iParameter.getId().equals(string3)) {
                    arrayList.add(new Parameterization(iParameter, string2));
                    continue block0;
                }
                ++n3;
            }
        } while (n != -1);
        return arrayList.toArray(new Parameterization[arrayList.size()]);
    }

    public final ParameterType getParameterType(String string) {
        this.checkId(string);
        ParameterType parameterType = (ParameterType)this.parameterTypesById.get(string);
        if (parameterType == null) {
            parameterType = new ParameterType(string);
            this.parameterTypesById.put(string, parameterType);
            parameterType.addListener(this);
        }
        return parameterType;
    }

    public final void parameterTypeChanged(ParameterTypeEvent parameterTypeEvent) {
        if (parameterTypeEvent.isDefinedChanged()) {
            ParameterType parameterType = parameterTypeEvent.getParameterType();
            String string = parameterType.getId();
            boolean bl = parameterType.isDefined();
            if (bl) {
                this.definedParameterTypeIds.add(string);
            } else {
                this.definedParameterTypeIds.remove(string);
            }
            this.fireCommandManagerChanged(new CommandManagerEvent(this, string, bl, true));
        }
    }

    public final void removeCommandManagerListener(ICommandManagerListener iCommandManagerListener) {
        this.removeListenerObject(iCommandManagerListener);
    }

    public final void removeExecutionListener(IExecutionListener iExecutionListener) {
        if (iExecutionListener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        if (this.executionListeners == null) {
            return;
        }
        this.executionListeners.remove((Object)iExecutionListener);
        if (this.executionListeners.isEmpty()) {
            this.executionListeners = null;
            Iterator iterator = this.handleObjectsById.values().iterator();
            while (iterator.hasNext()) {
                Command command = (Command)iterator.next();
                command.removeExecutionListener(this.executionListener);
            }
            this.executionListener = null;
        }
    }

    public final void setHandlersByCommandId(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            this.getCommand((String)iterator.next());
        }
        Iterator iterator2 = this.handleObjectsById.values().iterator();
        while (iterator2.hasNext()) {
            Command command = (Command)iterator2.next();
            String string = command.getId();
            Object v = map.get(string);
            if (v instanceof IHandler) {
                command.setHandler((IHandler)v);
                continue;
            }
            command.setHandler(null);
        }
    }

    public final void setHelpContextId(IHandler iHandler, String string) {
        if (iHandler == null) {
            throw new NullPointerException("The handler cannot be null");
        }
        if (string == null) {
            this.helpContextIdsByHandler.remove(iHandler);
        } else {
            this.helpContextIdsByHandler.put(iHandler, string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final int unescapedIndexOf(String var1_1, char var2_2) {
        var3_3 = var1_1.indexOf(var2_2);
        if (var3_3 != 0) ** GOTO lbl7
        return var3_3;
lbl-1000:
        // 1 sources

        {
            if (var1_1.charAt(var3_3 - 1) != '%') {
                return var3_3;
            }
            var3_3 = var1_1.indexOf(var2_2, var3_3 + 1);
lbl7:
            // 2 sources

            ** while (var3_3 != -1)
        }
lbl8:
        // 1 sources

        return var3_3;
    }

    public void fireNotEnabled(String string, NotEnabledException notEnabledException) {
        if (this.executionListener != null) {
            this.executionListener.notEnabled(string, notEnabledException);
        }
    }

    public void fireNotDefined(String string, NotDefinedException notDefinedException) {
        if (this.executionListener != null) {
            this.executionListener.notDefined(string, notDefinedException);
        }
    }

    public void firePreExecute(String string, ExecutionEvent executionEvent) {
        if (this.executionListener != null) {
            this.executionListener.preExecute(string, executionEvent);
        }
    }

    public void firePostExecuteSuccess(String string, Object object) {
        if (this.executionListener != null) {
            this.executionListener.postExecuteSuccess(string, object);
        }
    }

    public void firePostExecuteFailure(String string, ExecutionException executionException) {
        if (this.executionListener != null) {
            this.executionListener.postExecuteFailure(string, executionException);
        }
    }

    private final class ExecutionListener
    implements IExecutionListenerWithChecks {
        private ExecutionListener() {
        }

        public void notDefined(String string, NotDefinedException notDefinedException) {
            if (CommandManager.this.executionListeners != null) {
                Object[] objectArray = CommandManager.this.executionListeners.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    if (object instanceof IExecutionListenerWithChecks) {
                        IExecutionListenerWithChecks iExecutionListenerWithChecks = (IExecutionListenerWithChecks)object;
                        iExecutionListenerWithChecks.notDefined(string, notDefinedException);
                    }
                    ++n;
                }
            }
        }

        public void notEnabled(String string, NotEnabledException notEnabledException) {
            if (CommandManager.this.executionListeners != null) {
                Object[] objectArray = CommandManager.this.executionListeners.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    if (object instanceof IExecutionListenerWithChecks) {
                        IExecutionListenerWithChecks iExecutionListenerWithChecks = (IExecutionListenerWithChecks)object;
                        iExecutionListenerWithChecks.notEnabled(string, notEnabledException);
                    }
                    ++n;
                }
            }
        }

        public final void notHandled(String string, NotHandledException notHandledException) {
            if (CommandManager.this.executionListeners != null) {
                Object[] objectArray = CommandManager.this.executionListeners.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    if (object instanceof IExecutionListener) {
                        IExecutionListener iExecutionListener = (IExecutionListener)object;
                        iExecutionListener.notHandled(string, notHandledException);
                    }
                    ++n;
                }
            }
        }

        public final void postExecuteFailure(String string, ExecutionException executionException) {
            if (CommandManager.this.executionListeners != null) {
                Object[] objectArray = CommandManager.this.executionListeners.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    if (object instanceof IExecutionListener) {
                        IExecutionListener iExecutionListener = (IExecutionListener)object;
                        iExecutionListener.postExecuteFailure(string, executionException);
                    }
                    ++n;
                }
            }
        }

        public final void postExecuteSuccess(String string, Object object) {
            if (CommandManager.this.executionListeners != null) {
                Object[] objectArray = CommandManager.this.executionListeners.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    Object object2 = objectArray[n];
                    if (object2 instanceof IExecutionListener) {
                        IExecutionListener iExecutionListener = (IExecutionListener)object2;
                        iExecutionListener.postExecuteSuccess(string, object);
                    }
                    ++n;
                }
            }
        }

        public final void preExecute(String string, ExecutionEvent executionEvent) {
            if (CommandManager.this.executionListeners != null) {
                Object[] objectArray = CommandManager.this.executionListeners.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    if (object instanceof IExecutionListener) {
                        IExecutionListener iExecutionListener = (IExecutionListener)object;
                        iExecutionListener.preExecute(string, executionEvent);
                    }
                    ++n;
                }
            }
        }
    }
}

