/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public abstract class AbstractOperation
implements IUndoableOperation {
    List contexts = new ArrayList();
    private String label = "";

    public AbstractOperation(String string) {
        Assert.isNotNull((Object)string);
        this.label = string;
    }

    public void addContext(IUndoContext iUndoContext) {
        if (!this.contexts.contains(iUndoContext)) {
            this.contexts.add(iUndoContext);
        }
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void dispose() {
    }

    public abstract IStatus execute(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public final IUndoContext[] getContexts() {
        return this.contexts.toArray(new IUndoContext[this.contexts.size()]);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public final boolean hasContext(IUndoContext iUndoContext) {
        Assert.isNotNull((Object)iUndoContext);
        int n = 0;
        while (n < this.contexts.size()) {
            IUndoContext iUndoContext2 = (IUndoContext)this.contexts.get(n);
            if (iUndoContext.matches(iUndoContext2) || iUndoContext2.matches(iUndoContext)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract IStatus redo(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public void removeContext(IUndoContext iUndoContext) {
        this.contexts.remove(iUndoContext);
    }

    public abstract IStatus undo(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLabel());
        stringBuffer.append("(");
        IUndoContext[] iUndoContextArray = this.getContexts();
        int n = 0;
        while (n < iUndoContextArray.length) {
            stringBuffer.append(iUndoContextArray[n].toString());
            if (n != iUndoContextArray.length - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

