/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;

public class ServiceUse {
    private final ServiceFactory factory;
    private final BundleContextImpl context;
    private final ServiceRegistrationImpl registration;
    private Object cachedService;
    private int useCount;

    protected ServiceUse(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl serviceRegistrationImpl) {
        this.context = bundleContextImpl;
        this.registration = serviceRegistrationImpl;
        this.useCount = 0;
        Object object = serviceRegistrationImpl.service;
        if (object instanceof ServiceFactory) {
            this.factory = (ServiceFactory)object;
            this.cachedService = null;
        } else {
            this.factory = null;
            this.cachedService = object;
        }
    }

    protected Object getService() {
        Object t;
        if (this.useCount > 0 || this.factory == null) {
            ++this.useCount;
            return this.cachedService;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getService[factory=" + this.registration.context.bundle + "](" + this.context.bundle + "," + this.registration + ")");
        }
        try {
            t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ServiceUse.this.factory.getService(((ServiceUse)ServiceUse.this).context.bundle, ServiceUse.this.registration);
                }
            });
        }
        catch (Throwable throwable) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".getService() exception: " + throwable.getMessage());
                Debug.printStackTrace(throwable);
            }
            this.context.framework.adaptor.handleRuntimeError(throwable);
            BundleException bundleException = new BundleException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "getService"), throwable);
            this.context.framework.publishFrameworkEvent(2, this.registration.context.bundle, bundleException);
            return null;
        }
        if (t == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".getService() returned null.");
            }
            BundleException bundleException = new BundleException(NLS.bind(Msg.SERVICE_OBJECT_NULL_EXCEPTION, this.factory.getClass().getName()));
            this.context.framework.publishFrameworkEvent(2, this.registration.context.bundle, bundleException);
            return null;
        }
        String[] stringArray = this.registration.clazzes;
        String string = BundleContextImpl.checkServiceClass(stringArray, t);
        if (string != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + string);
            }
            throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_FACTORY_NOT_INSTANCEOF_CLASS_EXCEPTION, this.factory.getClass().getName(), string));
        }
        this.cachedService = t;
        ++this.useCount;
        return t;
    }

    protected boolean ungetService() {
        if (this.useCount == 0) {
            return true;
        }
        --this.useCount;
        if (this.useCount > 0) {
            return false;
        }
        if (this.factory == null) {
            return true;
        }
        final Object object = this.cachedService;
        this.cachedService = null;
        if (Debug.DEBUG_SERVICES) {
            Debug.println("ungetService[factory=" + this.registration.context.bundle + "](" + this.context.bundle + "," + this.registration + ")");
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceUse.this.factory.ungetService(((ServiceUse)ServiceUse.this).context.bundle, ServiceUse.this.registration, object);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println(this.factory + ".ungetService() exception");
                Debug.printStackTrace(throwable);
            }
            BundleException bundleException = new BundleException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), throwable);
            this.context.framework.publishFrameworkEvent(2, this.registration.context.bundle, bundleException);
        }
        return true;
    }

    protected void releaseService() {
        if (this.useCount == 0 || this.factory == null) {
            return;
        }
        final Object object = this.cachedService;
        this.cachedService = null;
        this.useCount = 0;
        if (Debug.DEBUG_SERVICES) {
            Debug.println("releaseService[factory=" + this.registration.context.bundle + "](" + this.context.bundle + "," + this.registration + ")");
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceUse.this.factory.ungetService(((ServiceUse)ServiceUse.this).context.bundle, ServiceUse.this.registration, object);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".ungetService() exception");
                Debug.printStackTrace(throwable);
            }
            BundleException bundleException = new BundleException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), throwable);
            this.context.framework.publishFrameworkEvent(2, this.registration.context.bundle, bundleException);
        }
    }
}

