/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionInfoImpl
implements ConditionalPermissionInfo,
Serializable {
    private static final long serialVersionUID = 3258130245704825139L;
    PermissionInfo[] perms;
    ConditionInfo[] conds;
    private String name;
    private boolean deleted = false;
    private static final Class[] twoStringClassArray;
    private static final Class[] oneStringClassArray;
    private static final Class[] noArgClassArray;
    private static final Class[][] permClassArrayArgs;
    private static final Class[] condClassArray;
    private static ConditionalPermissionAdminImpl condAdmin;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        twoStringClassArray = classArray;
        Class[] classArray2 = new Class[1];
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz3;
        oneStringClassArray = classArray2;
        noArgClassArray = new Class[0];
        permClassArrayArgs = new Class[][]{noArgClassArray, oneStringClassArray, twoStringClassArray};
        Class[] classArray3 = new Class[2];
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("org.osgi.framework.Bundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[0] = clazz4;
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("org.osgi.service.condpermadmin.ConditionInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[1] = clazz5;
        condClassArray = classArray3;
    }

    boolean isDeleted() {
        return this.deleted;
    }

    public ConditionalPermissionInfoImpl(String encoded) {
        this.decode(encoded);
    }

    public ConditionalPermissionInfoImpl(String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        this.name = name;
        this.conds = conds;
        this.perms = perms;
    }

    /*
     * Unable to fully structure code
     */
    private void decode(String encoded) {
        start = encoded.indexOf(123);
        end = encoded.lastIndexOf(125);
        if (start < 0 || end < start) {
            throw new IllegalArgumentException(encoded);
        }
        if (start != 0) {
            this.name = encoded.substring(0, start);
        }
        chars = encoded.substring(start + 1, end).toCharArray();
        condList = new ArrayList<ConditionInfo>();
        permList = new ArrayList<PermissionInfo>();
        pos = 0;
        ** GOTO lbl37
        {
            ++pos;
            do {
                if (pos < chars.length && chars[pos] != '[' && chars[pos] != '(') continue block0;
                if (pos == chars.length) break block0;
                startPos = pos;
                endChar = chars[startPos] == '[' ? ']' : ')';
                while (chars[pos] != endChar) {
                    if (chars[pos] == '\"') {
                        ++pos;
                        while (chars[pos] != '\"') {
                            if (chars[pos] == '\\') {
                                ++pos;
                            }
                            ++pos;
                        }
                    }
                    ++pos;
                }
                endPos = pos;
                token = new String(chars, startPos, endPos - startPos + 1);
                if (endChar == ']') {
                    condList.add(new ConditionInfo(token));
                } else {
                    permList.add(new PermissionInfo(token));
                }
                ++pos;
lbl37:
                // 2 sources

            } while (pos < chars.length);
        }
        this.conds = condList.toArray(new ConditionInfo[condList.size()]);
        this.perms = permList.toArray(new PermissionInfo[permList.size()]);
    }

    public String getName() {
        return this.name;
    }

    public ConditionInfo[] getConditionInfos() {
        if (this.conds == null) {
            return null;
        }
        ConditionInfo[] results = new ConditionInfo[this.conds.length];
        System.arraycopy(this.conds, 0, results, 0, this.conds.length);
        return results;
    }

    int addPermissions(AbstractBundle bundle, PermissionCollection collection, Class permClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String permClassName = permClass.getName();
        Constructor constructor = null;
        int numArgs = -1;
        int i = permClassArrayArgs.length - 1;
        while (i >= 0) {
            try {
                constructor = permClass.getConstructor(permClassArrayArgs[i]);
                numArgs = i;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                --i;
            }
        }
        if (constructor == null) {
            throw new NoSuchMethodException(String.valueOf(permClass.getName()) + ".<init>()");
        }
        int count = 0;
        int i2 = 0;
        while (i2 < this.perms.length) {
            block10: {
                Object[] args;
                block11: {
                    File target;
                    File file;
                    if (!this.perms[i2].getType().equals(permClassName)) break block10;
                    ++count;
                    args = new String[numArgs];
                    if (numArgs > 0) {
                        args[0] = this.perms[i2].getName();
                    }
                    if (numArgs > 1) {
                        args[1] = this.perms[i2].getActions();
                    }
                    if (!this.perms[i2].getType().equals("java.io.FilePermission") || args[0].equals("<<ALL FILES>>") || (file = new File((String)args[0])).isAbsolute()) break block11;
                    if (bundle == null || (target = bundle.framework.getDataFile(bundle, (String)args[0])) == null) break block10;
                    args[0] = target.getPath();
                }
                collection.add((Permission)constructor.newInstance(args));
            }
            ++i2;
        }
        return count;
    }

    Condition[] getConditions(Bundle bundle) {
        Condition[] conditions = new Condition[this.conds.length];
        int i = 0;
        while (i < this.conds.length) {
            block11: {
                Class<?> clazz;
                try {
                    clazz = Class.forName(this.conds[i].getType());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                Constructor<?> constructor = null;
                Method method = null;
                try {
                    method = clazz.getMethod("getCondition", condClassArray);
                    if ((method.getModifiers() & 8) == 0) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method == null) {
                    try {
                        constructor = clazz.getConstructor(condClassArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        conditions[i] = Condition.FALSE;
                        break block11;
                    }
                }
                Object[] args = new Object[]{bundle, this.conds[i]};
                try {
                    conditions[i] = method != null ? (Condition)method.invoke(null, args) : (Condition)constructor.newInstance(args);
                }
                catch (Throwable throwable) {
                    conditions[i] = Condition.FALSE;
                }
            }
            ++i;
        }
        return conditions;
    }

    public PermissionInfo[] getPermissionInfos() {
        if (this.perms == null) {
            return null;
        }
        PermissionInfo[] results = new PermissionInfo[this.perms.length];
        System.arraycopy(this.perms, 0, results, 0, this.perms.length);
        return results;
    }

    public void delete() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        this.deleted = true;
        condAdmin.deleteConditionalPermissionInfo(this);
    }

    static void setConditionalPermissionAdminImpl(ConditionalPermissionAdminImpl condAdmin) {
        ConditionalPermissionInfoImpl.condAdmin = condAdmin;
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer();
        if (this.name != null) {
            result.append(this.name);
        }
        ConditionInfo[] curConds = this.getConditionInfos();
        PermissionInfo[] curPerms = this.getPermissionInfos();
        result.append('{').append(' ');
        if (curConds != null) {
            i = 0;
            while (i < curConds.length) {
                result.append(curConds[i].getEncoded()).append(' ');
                ++i;
            }
        }
        if (curPerms != null) {
            i = 0;
            while (i < curPerms.length) {
                result.append(curPerms[i].getEncoded()).append(' ');
                ++i;
            }
        }
        result.append('}');
        return ((Object)result).toString();
    }
}

