/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.MultiPageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PreferenceDialog
extends MultiPageDialog
implements IPreferencePageContainer {
    protected PreferenceManager preferenceManager;
    private Command okCommand = null;
    private Command cancelCommand = null;
    private boolean bDialogClose;
    private IPreferenceNode currentOpenNode = null;
    private static String lastPreferenceId = null;
    private IPreferenceStore preferenceStore;

    public PreferenceDialog(Shell parentShell) {
        super(parentShell, 131072);
    }

    public PreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, 131072);
        this.preferenceManager = manager;
    }

    protected void checkSubclass() {
    }

    protected Control createContents(PreferenceDialog parent) {
        Composite parentDialog = null;
        Iterator iterator = this.preferenceManager.getElements(0).iterator();
        while (iterator.hasNext()) {
            IPreferenceNode next = (IPreferenceNode)iterator.next();
            parentDialog = this.createPage(next);
        }
        return parentDialog;
    }

    protected Composite createSubPages(IPreferenceNode node) {
        Composite control = this.createPage(node);
        IPreferenceNode[] subnodes = node.getSubNodes();
        if (subnodes != null) {
            int i = 0;
            while (i < subnodes.length) {
                control = this.createSubPages(subnodes[i]);
                ++i;
            }
        }
        return control;
    }

    protected Composite createPage(IPreferenceNode node) {
        Composite control = null;
        this.currentOpenNode = node;
        PreferencePage page = (PreferencePage)node.getPage();
        if (page == null) {
            node.createPage();
            page = (PreferencePage)node.getPage();
        }
        if (page != null) {
            page.setContainer(this);
            Composite mpdPage = this.createPage(page.getTitle(), page.getImage());
            this.createPageControl(page, mpdPage);
            control = mpdPage.getParent();
        }
        return control;
    }

    protected void createPageControl(PreferencePage page, Composite parent) {
        page.createControl(parent);
    }

    public void open() {
        this.setText(JFaceResources.getString("PreferenceDialog.title"));
        Control c = this.createContents(this);
        this.createCommands(c);
        this.bDialogClose = true;
        super.open();
        if (this.bDialogClose) {
            this.cancelPressed();
        }
    }

    public void close() {
        if (this.okCommand != null) {
            this.okCommand.dispose();
            this.okCommand = null;
        }
        if (this.cancelCommand != null) {
            this.cancelCommand.dispose();
            this.cancelCommand = null;
        }
        if (!this.bDialogClose) {
            super.close();
        }
    }

    private void createCommands(Control c) {
        this.okCommand = new Command(c, 3, 1);
        this.okCommand.setText(JFaceResources.getString("ok"));
        this.okCommand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog.this.bDialogClose = false;
                PreferenceDialog.this.okPressed();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                PreferenceDialog.this.bDialogClose = false;
                PreferenceDialog.this.okPressed();
            }
        });
        this.cancelCommand = new Command(c, 4, 1);
        this.cancelCommand.setText(JFaceResources.getString("cancel"));
        this.cancelCommand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog.this.bDialogClose = false;
                PreferenceDialog.this.cancelPressed();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                PreferenceDialog.this.bDialogClose = false;
                PreferenceDialog.this.cancelPressed();
            }
        });
    }

    protected void okPressed() {
        SafeRunnable.run(new SafeRunnable(){
            private boolean errorOccurred;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                boolean hasFailedOK;
                block13: {
                    block16: {
                        block14: {
                            this.errorOccurred = false;
                            hasFailedOK = false;
                            try {
                                try {
                                    PreferencePage page = (PreferencePage)PreferenceDialog.this.currentOpenNode.getPage();
                                    if (page == null || page.performOk()) break block13;
                                    hasFailedOK = true;
                                    Object var3_4 = null;
                                    if (!hasFailedOK && !this.errorOccurred) {
                                        PreferenceDialog.this.handleSave();
                                    }
                                    if (!hasFailedOK) break block14;
                                }
                                catch (Exception e) {
                                    this.errorOccurred = true;
                                    this.handleException(e);
                                    break block13;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var3_5 = null;
                                if (!hasFailedOK && !this.errorOccurred) {
                                    PreferenceDialog.this.handleSave();
                                }
                                if (hasFailedOK && !PreferenceDialog.this.bDialogClose) {
                                    PreferenceDialog.this.bDialogClose = true;
                                    throw throwable;
                                }
                                PreferenceDialog.this.close();
                                throw throwable;
                            }
                            if (!PreferenceDialog.this.bDialogClose) break block16;
                        }
                        PreferenceDialog.this.close();
                        return;
                    }
                    PreferenceDialog.this.bDialogClose = true;
                    return;
                }
                Object var3_6 = null;
                if (!hasFailedOK && !this.errorOccurred) {
                    PreferenceDialog.this.handleSave();
                }
                if (hasFailedOK && !PreferenceDialog.this.bDialogClose) {
                    PreferenceDialog.this.bDialogClose = true;
                    return;
                }
                PreferenceDialog.this.close();
            }
        });
    }

    protected void cancelPressed() {
        SafeRunnable.run(new SafeRunnable(){

            public void run() {
                PreferencePage page = (PreferencePage)PreferenceDialog.this.currentOpenNode.getPage();
                if (page != null && !page.performCancel()) {
                    return;
                }
                PreferenceDialog.this.close();
            }
        });
    }

    public void setPreferenceStore(IPreferenceStore store) {
        Assert.isNotNull(store);
        this.preferenceStore = store;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void updateButtons() {
        System.out.println("PreferenceDialog: updateButtons not impl");
    }

    public void updateMessage() {
        System.out.println("PreferenceDialog: updateMessage not impl");
    }

    public void updateTitle() {
        System.out.println("PreferenceDialog: updateTitle not impl");
    }

    protected void handleSave() {
        Iterator nodes = this.preferenceManager.getElements(0).iterator();
        while (nodes.hasNext()) {
            IPreferenceStore store;
            IPreferenceNode node = (IPreferenceNode)nodes.next();
            IPreferencePage page = node.getPage();
            if (!(page instanceof PreferencePage) || (store = ((PreferencePage)page).getPreferenceStore()) == null || !store.needsSaving() || !(store instanceof IPersistentPreferenceStore)) continue;
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                MessageBox mb = new MessageBox(null, 1);
                mb.setText(JFaceResources.getString("PreferenceDialog.saveErrorTitle"));
                mb.setMessage(JFaceResources.format("PreferenceDialog.saveErrorMessage", new Object[]{page.getTitle(), e.getMessage()}));
                mb.open();
            }
        }
    }

    public void setSelectedNode(String pageId) {
        lastPreferenceId = pageId;
    }
}

