/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTreeViewer
extends StructuredViewer {
    public static final int ALL_LEVELS = -1;
    private ListenerList treeListeners = new ListenerList(1);
    private int expandToLevel = 0;

    protected AbstractTreeViewer() {
    }

    public void add(Object parentElement, Object[] childElements) {
        Assert.isNotNull(parentElement);
        this.assertElementsNotNull(childElements);
        Widget widget = this.findItem(parentElement);
        if (widget == null) {
            return;
        }
        this.internalAdd(widget, parentElement, childElements);
    }

    protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
        Item ti;
        if (widget instanceof Item && !this.getExpanded(ti = (Item)widget)) {
            boolean needDummy = this.isExpandable(parentElement);
            boolean haveDummy = false;
            Item[] items = this.getItems(ti);
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() != null) {
                    this.disassociate(items[i]);
                    items[i].dispose();
                } else if (needDummy && !haveDummy) {
                    haveDummy = true;
                } else {
                    items[i].dispose();
                }
                ++i;
            }
            if (needDummy && !haveDummy) {
                this.newItem((Widget)ti, 0, -1);
            }
            return;
        }
        if (childElements.length > 0) {
            Object[] filtered = this.filter(childElements);
            if (this.getSorter() != null) {
                this.getSorter().sort(this, filtered);
            }
            this.createAddedElements(widget, filtered);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createAddedElements(Widget widget, Object[] elements) {
        if (elements.length == 1 && this.equals(elements[0], widget.getData())) {
            return;
        }
        sorter = this.getSorter();
        items = this.getChildren(widget);
        lastInsertion = 0;
        if (items.length == 0) {
            i = 0;
            while (i < elements.length) {
                this.createTreeItem(widget, elements[i], -1);
                ++i;
            }
            return;
        }
        i = 0;
        while (i < elements.length) {
            block9: {
                block8: {
                    newItem = true;
                    element = elements[i];
                    if (sorter != null) break block8;
                    if (this.itemExists(items, element)) {
                        this.refresh(element);
                        newItem = false;
                    }
                    index = -1;
                    break block9;
                }
                if ((lastInsertion = this.insertionPosition(items, sorter, lastInsertion, element)) != items.length) ** GOTO lbl31
                index = -1;
                break block9;
lbl-1000:
                // 1 sources

                {
                    if (items[lastInsertion].getData().equals(element)) {
                        this.refresh(element);
                        newItem = false;
                    }
                    ++lastInsertion;
lbl31:
                    // 2 sources

                    ** while (lastInsertion < items.length && sorter.compare((Viewer)this, (Object)element, (Object)items[lastInsertion].getData()) == 0)
                }
lbl32:
                // 1 sources

                index = lastInsertion == items.length ? -1 : lastInsertion + i;
            }
            if (newItem) {
                this.createTreeItem(widget, element, index);
            }
            ++i;
        }
    }

    private boolean itemExists(Item[] items, Object element) {
        if (this.usingElementMap()) {
            return this.findItem(element) != null;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getData().equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int insertionPosition(Item[] items, ViewerSorter sorter, int lastInsertion, Object element) {
        int size = items.length;
        if (sorter == null) {
            return size;
        }
        int min = lastInsertion;
        int max = size - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = items[mid].getData();
            int compare = sorter.compare(this, data, element);
            if (compare == 0) {
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected int indexForElement(Widget parent, Object element) {
        ViewerSorter sorter = this.getSorter();
        Item[] items = this.getChildren(parent);
        int count = items.length;
        if (sorter == null) {
            return count;
        }
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = items[mid].getData();
            int compare = sorter.compare(this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = items[mid].getData();
                    compare = sorter.compare(this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    public void add(Object parentElement, Object childElement) {
        this.add(parentElement, new Object[]{childElement});
    }

    protected void addSelectionListener(Control control, SelectionListener listener) {
    }

    public void addTreeListener(ITreeViewerListener listener) {
        this.treeListeners.add(listener);
    }

    protected abstract void addTreeListener(Control var1, TreeListener var2);

    protected void associate(Object element, Item item) {
        Object data = item.getData();
        if (data != null && data != element && this.equals(data, element)) {
            this.unmapElement(data, (Widget)item);
            item.setData(element);
            this.mapElement(element, (Widget)item);
        } else {
            super.associate(element, item);
        }
    }

    public void collapseAll() {
        Object root = this.getRoot();
        if (root != null) {
            this.collapseToLevel(root, -1);
        }
    }

    public void collapseToLevel(Object element, int level) {
        Assert.isNotNull(element);
        Widget w = this.findItem(element);
        if (w != null) {
            this.internalCollapseToLevel(w, level);
        }
    }

    protected void createChildren(Widget widget) {
        Object d;
        Object data;
        Item[] tis = this.getChildren(widget);
        if (tis != null && tis.length > 0 && (data = tis[0].getData()) != null) {
            return;
        }
        if (tis != null) {
            int i = 0;
            while (i < tis.length) {
                if (tis[i].getData() != null) {
                    this.disassociate(tis[i]);
                    Assert.isTrue(tis[i].getData() == null, "Second or later child is non -null");
                }
                tis[i].dispose();
                ++i;
            }
        }
        if ((d = widget.getData()) != null) {
            Object parentElement = d;
            Object[] children = this.getSortedChildren(parentElement);
            int i = 0;
            while (i < children.length) {
                this.createTreeItem(widget, children[i], -1);
                ++i;
            }
        }
    }

    protected void createTreeItem(Widget parent, Object element, int index) {
        Item item = this.newItem(parent, 0, index);
        this.updateItem((Widget)item, element);
        this.updatePlus(item, element);
    }

    protected void disassociate(Item item) {
        super.disassociate(item);
        if (this.usingElementMap()) {
            this.disassociateChildren(item);
        }
    }

    private void disassociateChildren(Item item) {
        Item[] items = this.getChildren((Widget)item);
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() != null) {
                this.disassociate(items[i]);
            }
            ++i;
        }
    }

    protected Widget doFindInputItem(Object element) {
        Object root = this.getRoot();
        if (root == null) {
            return null;
        }
        if (this.equals(root, element)) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        Object root = this.getRoot();
        if (root == null) {
            return null;
        }
        Item[] items = this.getChildren((Widget)this.getControl());
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Widget o = this.internalFindItem(items[i], element);
                if (o != null) {
                    return o;
                }
                ++i;
            }
        }
        return null;
    }

    protected abstract void doUpdateItem(Item var1, Object var2);

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof Item) {
            Item item = (Item)widget;
            if (fullMap) {
                this.associate(element, item);
            } else {
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            SafeRunnable.run(new UpdateItemSafeRunnable(item, element));
        }
    }

    public void expandAll() {
        this.expandToLevel(-1);
    }

    public void expandToLevel(int level) {
        this.expandToLevel(this.getRoot(), level);
    }

    public void expandToLevel(Object element, int level) {
        Widget w = this.internalExpand(element, true);
        if (w != null) {
            this.internalExpandToLevel(w, level);
        }
    }

    protected void fireTreeCollapsed(final TreeExpansionEvent event) {
        Object[] listeners = this.treeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ITreeViewerListener l = (ITreeViewerListener)listeners[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    l.treeCollapsed(event);
                }
            });
            ++i;
        }
    }

    protected void fireTreeExpanded(final TreeExpansionEvent event) {
        Object[] listeners = this.treeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ITreeViewerListener l = (ITreeViewerListener)listeners[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    l.treeExpanded(event);
                }
            });
            ++i;
        }
    }

    public int getAutoExpandLevel() {
        return this.expandToLevel;
    }

    protected abstract Item[] getChildren(Widget var1);

    protected Item getChild(Widget widget, int index) {
        return this.getChildren(widget)[index];
    }

    protected abstract boolean getExpanded(Item var1);

    public Object[] getExpandedElements() {
        ArrayList v = new ArrayList();
        this.internalCollectExpanded(v, (Widget)this.getControl());
        return v.toArray();
    }

    public boolean getExpandedState(Object element) {
        Assert.isNotNull(element);
        Widget item = this.findItem(element);
        if (item instanceof Item) {
            return this.getExpanded((Item)item);
        }
        return false;
    }

    protected abstract int getItemCount(Control var1);

    protected abstract int getItemCount(Item var1);

    protected abstract Item[] getItems(Item var1);

    protected Item getNextItem(Item item, boolean includeChildren) {
        Item[] children;
        if (item == null) {
            return null;
        }
        if (includeChildren && this.getExpanded(item) && (children = this.getItems(item)) != null && children.length > 0) {
            return children[0];
        }
        Item parent = this.getParentItem(item);
        if (parent == null) {
            return null;
        }
        Item[] siblings = this.getItems(parent);
        if (siblings != null) {
            if (siblings.length <= 1) {
                return this.getNextItem(parent, false);
            }
            int i = 0;
            while (i < siblings.length) {
                if (siblings[i] == item && i < siblings.length - 1) {
                    return siblings[i + 1];
                }
                ++i;
            }
        }
        return this.getNextItem(parent, false);
    }

    protected abstract Item getParentItem(Item var1);

    protected Item getPreviousItem(Item item) {
        Item parent = this.getParentItem(item);
        if (parent == null) {
            return null;
        }
        Item[] siblings = this.getItems(parent);
        if (siblings.length == 0 || siblings[0] == item) {
            return parent;
        }
        Item previous = siblings[0];
        int i = 1;
        while (i < siblings.length) {
            if (siblings[i] == item) {
                return this.rightMostVisibleDescendent(previous);
            }
            previous = siblings[i];
            ++i;
        }
        return null;
    }

    protected Object[] getRawChildren(Object parent) {
        if (parent != null) {
            Object[] result;
            if (this.equals(parent, this.getRoot())) {
                return super.getRawChildren(parent);
            }
            ITreeContentProvider cp = (ITreeContentProvider)this.getContentProvider();
            if (cp != null && (result = cp.getChildren(parent)) != null) {
                return result;
            }
        }
        return new Object[0];
    }

    protected abstract Item[] getSelection(Control var1);

    protected List getSelectionFromWidget() {
        Item[] items = this.getSelection(this.getControl());
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Object e = item.getData();
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    protected void handleTreeCollapse(TreeEvent event) {
        if (event.item.getData() != null) {
            this.fireTreeCollapsed(new TreeExpansionEvent(this, event.item.getData()));
        }
    }

    protected void handleTreeExpand(TreeEvent event) {
        this.createChildren(event.item);
        if (event.item.getData() != null) {
            this.fireTreeExpanded(new TreeExpansionEvent(this, event.item.getData()));
        }
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.addTreeListener(control, new TreeListener(){

            public void treeExpanded(TreeEvent event) {
                AbstractTreeViewer.this.handleTreeExpand(event);
            }

            public void treeCollapsed(TreeEvent event) {
                AbstractTreeViewer.this.handleTreeCollapse(event);
            }
        });
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.preservingSelection(new Runnable(){

            public void run() {
                Control tree = AbstractTreeViewer.this.getControl();
                boolean useRedraw = true;
                if (useRedraw) {
                    tree.setRedraw(false);
                }
                AbstractTreeViewer.this.removeAll(tree);
                tree.setData(AbstractTreeViewer.this.getRoot());
                AbstractTreeViewer.this.createChildren((Widget)tree);
                AbstractTreeViewer.this.internalExpandToLevel((Widget)tree, AbstractTreeViewer.this.expandToLevel);
                if (useRedraw) {
                    tree.setRedraw(true);
                }
            }
        });
    }

    protected void internalCollapseToLevel(Widget widget, int level) {
        if (level == -1 || level > 0) {
            Item[] children;
            if (widget instanceof Item) {
                this.setExpanded((Item)widget, false);
            }
            if ((level == -1 || level > 1) && (children = this.getChildren(widget)) != null) {
                int nextLevel = level == -1 ? -1 : level - 1;
                int i = 0;
                while (i < children.length) {
                    this.internalCollapseToLevel((Widget)children[i], nextLevel);
                    ++i;
                }
            }
        }
    }

    private void internalCollectExpanded(List result, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Object data;
            Item item = items[i];
            if (this.getExpanded(item) && (data = item.getData()) != null) {
                result.add(data);
            }
            this.internalCollectExpanded(result, (Widget)item);
            ++i;
        }
    }

    protected Widget internalExpand(Object element, boolean expand) {
        if (element == null) {
            return null;
        }
        Widget w = this.internalGetWidgetToSelect(element);
        if (w == null) {
            Widget pw;
            if (this.equals(element, this.getRoot())) {
                return null;
            }
            ITreeContentProvider cp = (ITreeContentProvider)this.getContentProvider();
            if (cp == null) {
                return null;
            }
            Object parent = cp.getParent(element);
            if (parent != null && (pw = this.internalExpand(parent, false)) != null) {
                this.createChildren(pw);
                if (pw instanceof Item) {
                    Item item = (Item)pw;
                    w = this.internalFindChild(item, element);
                    if (expand) {
                        while (item != null && !this.getExpanded(item)) {
                            this.setExpanded(item, true);
                            item = this.getParentItem(item);
                        }
                    }
                }
            }
        }
        return w;
    }

    protected Widget internalGetWidgetToSelect(Object element) {
        return this.findItem(element);
    }

    protected void internalExpandToLevel(Widget widget, int level) {
        if (level == -1 || level > 0) {
            Item[] children;
            this.createChildren(widget);
            if (widget instanceof Item) {
                this.setExpanded((Item)widget, true);
            }
            if ((level == -1 || level > 1) && (children = this.getChildren(widget)) != null) {
                int newLevel = level == -1 ? -1 : level - 1;
                int i = 0;
                while (i < children.length) {
                    this.internalExpandToLevel((Widget)children[i], newLevel);
                    ++i;
                }
            }
        }
    }

    private Widget internalFindChild(Item parent, Object element) {
        Item[] items = this.getChildren((Widget)parent);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Object data = item.getData();
            if (data != null && this.equals(data, element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private Widget internalFindItem(Item parent, Object element) {
        Object data = parent.getData();
        if (data != null && this.equals(data, element)) {
            return parent;
        }
        Item[] items = this.getChildren((Widget)parent);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Widget o = this.internalFindItem(item, element);
            if (o != null) {
                return o;
            }
            ++i;
        }
        return null;
    }

    protected void internalRefresh(Object element) {
        this.internalRefresh(element, true);
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (element == null) {
            this.internalRefresh((Widget)this.getControl(), this.getRoot(), true, updateLabels);
            return;
        }
        Widget item = this.findItem(element);
        if (item != null) {
            this.internalRefresh(item, element, true, updateLabels);
        }
    }

    protected void internalRefresh(Widget widget, Object element, boolean doStruct, boolean updateLabels) {
        if (widget instanceof Item) {
            if (doStruct) {
                this.updatePlus((Item)widget, element);
            }
            if (updateLabels || !this.equals(element, widget.getData())) {
                this.doUpdateItem(widget, element, true);
            } else {
                this.associate(element, (Item)widget);
            }
        }
        if (doStruct) {
            this.internalRefreshStruct(widget, element, updateLabels);
        } else {
            Item[] children = this.getChildren(widget);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Item item = children[i];
                    Object data = item.getData();
                    if (data != null) {
                        this.internalRefresh((Widget)item, data, doStruct, updateLabels);
                    }
                    ++i;
                }
            }
        }
    }

    private void internalRefreshStruct(Widget widget, Object element, boolean updateLabels) {
        this.updateChildren(widget, element, null, updateLabels);
        Item[] children = this.getChildren(widget);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                Item item = children[i];
                Object data = item.getData();
                if (data != null) {
                    this.internalRefreshStruct((Widget)item, data, updateLabels);
                }
                ++i;
            }
        }
    }

    protected void internalRemove(Object[] elements) {
        Item parentItem;
        Object input = this.getInput();
        CustomHashtable parentItems = new CustomHashtable(5);
        int i = 0;
        while (i < elements.length) {
            if (this.equals(elements[i], input)) {
                this.setInput(null);
                return;
            }
            Widget childItem = this.findItem(elements[i]);
            if (childItem instanceof Item) {
                parentItem = this.getParentItem((Item)childItem);
                if (parentItem != null) {
                    parentItems.put(parentItem, parentItem);
                }
                this.disassociate((Item)childItem);
                childItem.dispose();
            }
            ++i;
        }
        Control tree = this.getControl();
        Enumeration e = parentItems.keys();
        while (e.hasMoreElements()) {
            parentItem = (Item)e.nextElement();
            if (parentItem.isDisposed() || this.getExpanded(parentItem) || this.getItemCount(parentItem) != 0) continue;
            if (this.isExpandable(parentItem.getData())) {
                this.newItem((Widget)parentItem, 0, -1);
                continue;
            }
            tree.redraw();
        }
    }

    private void internalSetExpanded(CustomHashtable expandedElements, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Object data = item.getData();
            if (data != null) {
                boolean expanded;
                boolean bl = expanded = expandedElements.remove(data) != null;
                if (expanded != this.getExpanded(item)) {
                    if (expanded) {
                        this.createChildren((Widget)item);
                    }
                    this.setExpanded(item, expanded);
                }
            }
            this.internalSetExpanded(expandedElements, (Widget)item);
            ++i;
        }
    }

    public boolean isExpandable(Object element) {
        ITreeContentProvider cp = (ITreeContentProvider)this.getContentProvider();
        return cp != null && cp.hasChildren(element);
    }

    protected void labelProviderChanged() {
        Control tree = this.getControl();
        tree.setRedraw(false);
        this.internalRefresh((Widget)tree, this.getRoot(), false, true);
        tree.setRedraw(true);
    }

    protected abstract Item newItem(Widget var1, int var2, int var3);

    public void remove(final Object[] elements) {
        this.assertElementsNotNull(elements);
        this.preservingSelection(new Runnable(){

            public void run() {
                AbstractTreeViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    protected abstract void removeAll(Control var1);

    public void removeTreeListener(ITreeViewerListener listener) {
        this.treeListeners.remove(listener);
    }

    public void reveal(Object element) {
        Assert.isNotNull(element);
        Widget w = this.internalExpand(element, true);
        if (w instanceof Item) {
            this.showItem((Item)w);
        }
    }

    private Item rightMostVisibleDescendent(Item item) {
        Item[] children = this.getItems(item);
        if (this.getExpanded(item) && children != null && children.length > 0) {
            return this.rightMostVisibleDescendent(children[children.length - 1]);
        }
        return item;
    }

    public Item scrollDown(int x, int y) {
        Item current = this.getItem(x, y);
        if (current != null) {
            Item next = this.getNextItem(current, true);
            this.showItem(next == null ? current : next);
            return next;
        }
        return null;
    }

    public Item scrollUp(int x, int y) {
        Item current = this.getItem(x, y);
        if (current != null) {
            Item previous = this.getPreviousItem(current);
            this.showItem(previous == null ? current : previous);
            return previous;
        }
        return null;
    }

    public void setAutoExpandLevel(int level) {
        this.expandToLevel = level;
    }

    public void setContentProvider(IContentProvider provider) {
        Assert.isTrue(provider instanceof ITreeContentProvider);
        super.setContentProvider(provider);
    }

    protected abstract void setExpanded(Item var1, boolean var2);

    public void setExpandedElements(Object[] elements) {
        this.assertElementsNotNull(elements);
        CustomHashtable expandedElements = this.newHashtable(elements.length * 2 + 1);
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            this.internalExpand(element, false);
            expandedElements.put(element, element);
            ++i;
        }
        this.internalSetExpanded(expandedElements, (Widget)this.getControl());
    }

    public void setExpandedState(Object element, boolean expanded) {
        Assert.isNotNull(element);
        Widget item = this.internalExpand(element, false);
        if (item instanceof Item) {
            if (expanded) {
                this.createChildren(item);
            }
            this.setExpanded((Item)item, expanded);
        }
    }

    protected abstract void setSelection(List var1);

    protected void setSelectionToWidget(List v, boolean reveal) {
        if (v == null) {
            this.setSelection(new ArrayList(0));
            return;
        }
        int size = v.size();
        ArrayList<Widget> newSelection = new ArrayList<Widget>(size);
        int i = 0;
        while (i < size) {
            Widget w = this.internalExpand(v.get(i), false);
            if (w instanceof Item) {
                newSelection.add(w);
            }
            ++i;
        }
        this.setSelection(newSelection);
    }

    protected abstract void showItem(Item var1);

    protected void updateChildren(Widget widget, Object parent, Object[] elementChildren) {
        this.updateChildren(widget, parent, elementChildren, true);
    }

    private void updateChildren(Widget widget, Object parent, Object[] elementChildren, boolean updateLabels) {
        Item item;
        Item ti;
        if (widget instanceof Item && !this.getExpanded(ti = (Item)widget)) {
            boolean needDummy = this.isExpandable(parent);
            boolean haveDummy = false;
            Item[] items = this.getItems(ti);
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() != null) {
                    this.disassociate(items[i]);
                    items[i].dispose();
                } else if (needDummy && !haveDummy) {
                    haveDummy = true;
                } else {
                    items[i].dispose();
                }
                ++i;
            }
            if (needDummy && !haveDummy) {
                this.newItem((Widget)ti, 0, -1);
            }
            return;
        }
        if (elementChildren == null) {
            elementChildren = this.getSortedChildren(parent);
        }
        Control tree = this.getControl();
        int oldCnt = -1;
        if (widget == tree) {
            oldCnt = this.getItemCount(tree);
        }
        Item[] items = this.getChildren(widget);
        CustomHashtable expanded = this.newHashtable(13);
        int i = 0;
        while (i < items.length) {
            Object element;
            if (this.getExpanded(items[i]) && (element = items[i].getData()) != null) {
                expanded.put(element, element);
            }
            ++i;
        }
        int min = Math.min(elementChildren.length, items.length);
        int i2 = items.length;
        while (--i2 >= min) {
            if (items[i2].getData() != null) {
                this.disassociate(items[i2]);
            }
            items[i2].dispose();
        }
        i2 = 0;
        while (i2 < min) {
            Object newElement;
            item = items[i2];
            Object oldElement = item.getData();
            if (oldElement != null && (newElement = elementChildren[i2]) != oldElement) {
                if (this.equals(newElement, oldElement)) {
                    item.setData(newElement);
                    this.mapElement(newElement, (Widget)item);
                } else {
                    this.disassociate(item);
                    item.setImage(null);
                    item.setText("");
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < min) {
            item = items[i2];
            Object newElement = elementChildren[i2];
            if (item.getData() == null) {
                this.associate(newElement, item);
                this.updatePlus(item, newElement);
                this.updateItem((Widget)item, newElement);
                this.setExpanded(item, expanded.containsKey(newElement));
            } else {
                this.updatePlus(item, newElement);
                if (updateLabels) {
                    this.updateItem((Widget)item, newElement);
                }
            }
            ++i2;
        }
        if (min < elementChildren.length) {
            i2 = min;
            while (i2 < elementChildren.length) {
                this.createTreeItem(widget, elementChildren[i2], i2);
                ++i2;
            }
            if (expanded.size() > 0) {
                items = this.getChildren(widget);
                i2 = min;
                while (i2 < elementChildren.length) {
                    if (expanded.containsKey(elementChildren[i2])) {
                        this.setExpanded(items[i2], true);
                    }
                    ++i2;
                }
            }
        }
        if (widget == tree && oldCnt == 0 && this.getItemCount(tree) != 0) {
            tree.setRedraw(false);
            tree.setRedraw(true);
        }
    }

    protected void updatePlus(Item item, Object element) {
        boolean hasPlus = this.getItemCount(item) > 0;
        boolean needsPlus = this.isExpandable(element);
        boolean removeAll = false;
        boolean addDummy = false;
        Object data = item.getData();
        if (data != null && this.equals(element, data)) {
            if (hasPlus != needsPlus) {
                if (needsPlus) {
                    addDummy = true;
                } else {
                    removeAll = true;
                }
            }
        } else {
            removeAll = true;
            addDummy = needsPlus;
            this.setExpanded(item, false);
        }
        if (removeAll) {
            Item[] items = this.getItems(item);
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() != null) {
                    this.disassociate(items[i]);
                }
                items[i].dispose();
                ++i;
            }
        }
        if (addDummy) {
            this.newItem((Widget)item, 0, -1);
        }
    }

    public Object[] getVisibleExpandedElements() {
        ArrayList v = new ArrayList();
        this.internalCollectVisibleExpanded(v, (Widget)this.getControl());
        return v.toArray();
    }

    private void internalCollectVisibleExpanded(ArrayList result, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            if (this.getExpanded(item)) {
                Object data = item.getData();
                if (data != null) {
                    result.add(data);
                }
                this.internalCollectVisibleExpanded(result, (Widget)item);
            }
            ++i;
        }
    }

    class UpdateItemSafeRunnable
    extends SafeRunnable {
        private Object element;
        private Item item;

        UpdateItemSafeRunnable(Item item, Object element) {
            this.item = item;
            this.element = element;
        }

        public void run() {
            AbstractTreeViewer.this.doUpdateItem(this.item, this.element);
        }
    }
}

