/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TaskTip
extends Widget {
    private static int MARGIN_WIDTH = 3;
    private static int MARGIN_HEIGHT = 3;
    private static int SHELL_MARGIN_WIDTH = 20;
    private static int SHELL_HEIGHT_STYLE_NONE = 26;
    private static int SHELL_HEIGHT_STYLE_SMOOTH = 26;
    private static int SHELL_HEIGHT_STYLE_INDETERMINATE = 22;
    private static int PROGRESS_BAR_HEIGHT = 2;
    private static int TITLE_HEIGHT = 26;
    private static final int PROGRESSBAR_VALUE_MINIMUM = 0;
    private static final int PROGRESSBAR_VALUE_MAXIMUM = 100;
    private static final String STYLE_NONE_SYMBOL = "/resources/stopwatch.png";
    private Display display;
    private Shell shell = null;
    private int style;
    private Label msgLabel;
    private Label progressLabel;
    private ProgressThread progressThread;
    private LocationHandle locHandle;
    private ProgressBar progressBar;
    private int minimum = 0;
    private int maximum = 100;
    private int selection = 0;
    private boolean isOpen = false;
    private boolean isModifyText = false;

    public TaskTip(Shell shell) {
        this(shell, 0);
    }

    public TaskTip(Shell shell, int style) {
        super(shell, style);
        if (shell == null) {
            SWT.error(4);
        }
        if (Display.getCurrent().getDPI().equals(new Point(192, 192))) {
            MARGIN_WIDTH *= 2;
            MARGIN_HEIGHT *= 2;
            SHELL_MARGIN_WIDTH *= 2;
            SHELL_HEIGHT_STYLE_NONE *= 2;
            SHELL_HEIGHT_STYLE_SMOOTH *= 2;
            SHELL_HEIGHT_STYLE_INDETERMINATE *= 2;
            TITLE_HEIGHT *= 2;
        }
        final TaskTip tasktip = this;
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                tasktip.dispose();
            }
        });
        this.display = shell.getDisplay();
        this.style = style != 0 && style != 65536 && style != 2 ? 0 : style;
        this.shell = new Shell(shell, 2048);
        this.locHandle = new LocationHandle(this.shell);
        this.init();
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (this.style != 65536) {
            return;
        }
        if (value < 0 || value < this.minimum) {
            SWT.error(5);
            return;
        }
        this.maximum = value;
        if (this.selection > this.maximum) {
            this.selection = this.maximum;
        }
        this.progressBar.setMaximum(this.maximum);
        this.shell.redraw();
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (this.style != 65536) {
            return;
        }
        if (value < 0 || value > this.maximum) {
            SWT.error(5);
            return;
        }
        this.minimum = value;
        if (this.selection < this.minimum) {
            this.selection = this.minimum;
        }
        this.progressBar.setMinimum(this.minimum);
        this.shell.redraw();
    }

    public void setSelection(int value) {
        this.checkWidget();
        if (this.style != 65536) {
            return;
        }
        if (value < this.minimum || value > this.maximum) {
            SWT.error(5);
            return;
        }
        this.selection = value;
        this.progressBar.setSelection(this.selection);
        this.shell.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            if (!this.msgLabel.getText().equals("")) {
                this.isModifyText = true;
            }
            this.msgLabel.setText("");
        } else {
            if (!this.msgLabel.getText().equals(string)) {
                this.isModifyText = true;
            }
            this.msgLabel.setText(string);
        }
        if (this.shell.isVisible()) {
            this.isModifyText = false;
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.shell.isVisible() == visible) {
            return;
        }
        if (this.progressThread != null) {
            this.progressThread.setActive(visible);
            if (visible) {
                new Thread(this.progressThread).start();
            }
        }
        if (visible) {
            if (this.isModifyText || !this.isOpen) {
                this.isModifyText = false;
            }
            if (!this.isOpen) {
                this.shell.open();
                this.isOpen = true;
            }
            this.shell.setActive();
            this.shell.setBounds(this.locHandle.getShellBounds());
        }
        this.shell.setVisible(visible);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.progressThread != null) {
            this.progressThread.setActive(false);
            this.progressThread = null;
        }
        if (this.locHandle != null) {
            this.locHandle.dispose();
            this.locHandle = null;
        }
        if (this.progressBar != null) {
            this.shell.removePaintListener(this.progressBar);
        }
        this.progressBar = null;
        if (this.msgLabel != null && !this.msgLabel.isDisposed()) {
            this.msgLabel.dispose();
        }
        if (this.progressLabel != null && !this.progressLabel.isDisposed()) {
            this.progressLabel.dispose();
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
        }
        this.shell = null;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.shell == null || this.shell.isDisposed();
    }

    private void init() {
        int progressWidth = 0;
        int shellx = SHELL_MARGIN_WIDTH;
        int shelly = TITLE_HEIGHT;
        int shellw = this.display.getBounds().width - SHELL_MARGIN_WIDTH * 2;
        int shellh = this.style == 0 ? SHELL_HEIGHT_STYLE_NONE : (this.style == 65536 ? SHELL_HEIGHT_STYLE_SMOOTH : SHELL_HEIGHT_STYLE_INDETERMINATE);
        if (SWT.getPlatform().equals("win32")) {
            shellw = this.display.getBounds().width / 2;
            shellx = shellw / 2;
        }
        int validw = shellw - MARGIN_WIDTH * 2;
        Color bgColor = new Color(this.display, 255, 255, 204);
        this.shell.setBackground(bgColor);
        if (this.style == 0) {
            this.progressLabel = new Label(this.shell, 131072);
            this.progressLabel.setForeground(this.display.getSystemColor(9));
            this.progressLabel.setBackground(bgColor);
            this.progressLabel.setImage(new Image((Device)this.display, this.getClass().getResourceAsStream(STYLE_NONE_SYMBOL)));
            this.progressLabel.pack();
            progressWidth = this.progressLabel.getBounds().width + MARGIN_WIDTH;
            this.progressLabel.setLocation(validw - progressWidth + MARGIN_WIDTH, MARGIN_HEIGHT);
        } else if (this.style == 2) {
            this.progressLabel = new Label(this.shell, 131072);
            this.progressLabel.setForeground(this.display.getSystemColor(9));
            this.progressLabel.setBackground(bgColor);
            this.progressLabel.setText("/");
            this.progressLabel.pack();
            progressWidth = this.progressLabel.getBounds().width + MARGIN_WIDTH;
            this.progressLabel.setLocation(validw - progressWidth, MARGIN_HEIGHT);
            this.progressThread = new ProgressThread(this.display, this.progressLabel);
        }
        this.msgLabel = new Label(this.shell, 16384);
        this.msgLabel.setBackground(bgColor);
        this.msgLabel.setText("W");
        this.msgLabel.pack();
        this.msgLabel.setBounds(MARGIN_WIDTH, MARGIN_HEIGHT, validw - progressWidth - MARGIN_WIDTH, this.msgLabel.getSize().y);
        this.msgLabel.setText("");
        this.shell.setBounds(shellx, shelly, shellw, shellh);
        this.locHandle.setShellBounds(shellx, shelly, shellw, shellh);
        this.msgLabel.addMouseListener(this.locHandle);
        this.msgLabel.addMouseMoveListener(this.locHandle);
        this.shell.addMouseListener(this.locHandle);
        this.shell.addMouseMoveListener(this.locHandle);
        if (this.style == 0 || this.style == 2) {
            this.progressLabel.addMouseListener(this.locHandle);
            this.progressLabel.addMouseMoveListener(this.locHandle);
        }
        if (this.style == 65536) {
            int y = this.msgLabel.getLocation().y + this.msgLabel.getSize().y + MARGIN_HEIGHT;
            int w = validw - MARGIN_WIDTH;
            this.progressBar = new ProgressBar(MARGIN_WIDTH, y, w, PROGRESS_BAR_HEIGHT);
            this.shell.addPaintListener(this.progressBar);
        }
    }

    public class LocationHandle
    implements MouseListener,
    MouseMoveListener {
        Point mousePoint;
        Control control;
        Shell shell;
        Rectangle rectangle;
        boolean isMouseDown = false;

        public LocationHandle(Shell shell) {
            this.shell = shell;
            this.mousePoint = new Point(0, 0);
            this.rectangle = new Rectangle(0, 0, 0, 0);
        }

        public void setShellBounds(int x, int y, int width, int height) {
            this.rectangle.x = x;
            this.rectangle.y = y;
            this.rectangle.width = width;
            this.rectangle.height = height;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.control = (Control)e.widget;
            if (this.shell.getSize().y > SHELL_HEIGHT_STYLE_NONE) {
                this.shell.setBounds(this.rectangle);
                return;
            }
            this.mousePoint.x = e.x;
            this.mousePoint.y = e.y;
            this.rectangle.x = this.shell.getLocation().x;
            this.rectangle.y = this.shell.getLocation().y;
            this.isMouseDown = true;
        }

        public void mouseUp(MouseEvent e) {
            if (!this.isMouseDown) {
                return;
            }
            if (this.control == null || (Control)e.widget != this.control) {
                return;
            }
            this.control = null;
            this.isMouseDown = false;
        }

        public void mouseMove(MouseEvent e) {
            if (!this.isMouseDown) {
                return;
            }
            if (this.control == null || (Control)e.widget != this.control) {
                return;
            }
            this.rectangle.x += e.x - this.mousePoint.x;
            this.rectangle.y += e.y - this.mousePoint.y;
            if (this.rectangle.y < 0) {
                this.rectangle.y = 0;
            }
            this.shell.setLocation(this.rectangle.x, this.rectangle.y);
        }

        public Rectangle getShellBounds() {
            return this.rectangle;
        }

        public void dispose() {
            this.mousePoint = null;
            this.rectangle = null;
        }
    }

    private class ProgressThread
    implements Runnable {
        long sleepTime = 500L;
        Display display;
        boolean active = true;
        String[] animations = new String[4];
        int select = 0;
        Label label;

        public ProgressThread(Display display, Label label) {
            this.display = display;
            this.label = label;
            this.animations[0] = "-";
            this.animations[1] = "\\";
            this.animations[2] = "|";
            this.animations[3] = "/";
        }

        public ProgressThread(Display display, Label label, long sleepTime) {
            this(display, label);
            this.sleepTime = sleepTime;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void run() {
            while (this.active) {
                String animation = this.animations[this.select];
                try {
                    if (this.display != null && !this.display.isDisposed()) {
                        this.display.asyncExec(new Runnable(this, animation){
                            private final /* synthetic */ String val$animation;
                            private final /* synthetic */ ProgressThread this$1;
                            {
                                this.this$1 = this$1;
                                this.val$animation = val$animation;
                            }

                            public void run() {
                                if (this.this$1.label != null && !this.this$1.label.isDisposed()) {
                                    this.this$1.label.setText(this.val$animation);
                                }
                            }
                        });
                    }
                    if (++this.select == this.animations.length) {
                        this.select = 0;
                    }
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }

    private class ProgressBar
    implements PaintListener {
        int x;
        int y;
        int w;
        int h;
        int maximum = 100;
        int minimum = 0;
        int selection = 0;
        int prevSelect = -1;

        public ProgressBar(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public void setMaximum(int maximum) {
            this.maximum = maximum;
            this.prevSelect = -1;
        }

        public void setMinimum(int minimum) {
            this.minimum = minimum;
            this.prevSelect = -1;
        }

        public void setSelection(int selection) {
            this.selection = selection;
        }

        public void paintControl(PaintEvent e) {
            if (this.prevSelect == this.selection) {
                return;
            }
            int sw = (this.selection - this.minimum) * this.w / (this.maximum - this.minimum);
            e.gc.setBackground(TaskTip.this.display.getSystemColor(10));
            e.gc.fillRectangle(this.x + sw, this.y, this.w - sw, this.h);
            e.gc.setBackground(TaskTip.this.display.getSystemColor(9));
            e.gc.fillRectangle(this.x, this.y, sw, this.h);
            this.prevSelect = this.selection;
        }
    }
}

