/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DialogUtils;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = null;
    String[] fileNames = new String[0];
    int nativeStyle = 0;
    private boolean setFilterFlag = false;
    static final String FILTER = "*";

    public FileDialog(Shell parent) {
        this(parent, 32768);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.nativeStyle |= DialogUtils.getNativeModalityStyle(this);
        if ((style & 0x1000) == 4096) {
            this.nativeStyle |= 0x1000;
        }
        if ((style & 0x2000) == 8192) {
            this.nativeStyle |= 0x2000;
        }
        if ((style & 2) == 2) {
            this.nativeStyle |= 0x800000;
        }
    }

    public String getFileName() {
        if (this.fileNames == null || this.fileNames.length == 0) {
            return null;
        }
        return this.fileNames[0];
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        if (this.filterPath == null && !this.setFilterFlag) {
            this.filterPath = "";
        }
        return this.filterPath;
    }

    public String open() {
        int handle;
        int parentHandle = 0;
        String name = null;
        if (this.parent != null) {
            parentHandle = this.parent.internal_handle;
        }
        if ((handle = OS.FileDialog_New(parentHandle, this.nativeStyle)) == 0) {
            return null;
        }
        String nativeTitle = DialogUtils.getNativeTitle(this);
        if (nativeTitle != null) {
            OS.FileDialog_SetTitle(handle, nativeTitle);
        }
        OS.FileDialog_SetFileName(handle, this.fileNames.length > 0 ? this.fileNames[0] : "");
        OS.FileDialog_SetFilterPath(handle, this.filterPath);
        OS.FileDialog_SetFilterExtensions(handle, this.filterExtensions);
        OS.FileDialog_SetFilterNames(handle, this.filterNames);
        boolean success = OS.FileDialog_Open(handle);
        if (success) {
            this.fileNames = OS.FileDialog_GetFileNames(handle);
            if (this.fileNames != null && this.fileNames.length > 0) {
                this.filterPath = OS.FileDialog_GetFilterPath(handle);
                name = this.filterPath != null ? this.filterPath + System.getProperty("file.separator") + this.fileNames[0] : this.fileNames[0];
            } else {
                name = null;
            }
        }
        OS.Widget_Dispose(handle);
        return name;
    }

    public void setFileName(String string) {
        if (this.fileNames.length != 1) {
            this.fileNames = new String[1];
        }
        this.fileNames[0] = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.setFilterFlag = true;
        this.filterPath = string;
    }
}

